/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.visitors;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.visitors.IValueVisitor;
import io.usethesource.vallang.visitors.NullVisitor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ValueStreams {
    public static Stream<IValue> bottomup(IValue val) {
        return val.accept(new BottomUp());
    }

    public static Stream<IValue> topdown(IValue val) {
        return val.accept(new TopDown());
    }

    public static Stream<IValue> topdownbf(IValue val) {
        ArrayDeque<IValue> queue = new ArrayDeque<IValue>();
        queue.add(val);
        return ValueStreams.topdownbf(queue);
    }

    private static Stream<IValue> topdownbf(Deque<IValue> queue) {
        if (queue.isEmpty()) {
            return Stream.empty();
        }
        IValue val = queue.remove();
        val.accept(new QueueChildren(queue));
        return Stream.concat(Stream.of(val), ValueStreams.topdownbf(queue));
    }

    public static Stream<IValue> bottomupbf(IValue val) {
        ArrayDeque<IValue> queue = new ArrayDeque<IValue>();
        ArrayDeque<IValue> stack = new ArrayDeque<IValue>();
        queue.add(val);
        while (!queue.isEmpty()) {
            val = (IValue)queue.remove();
            stack.push(val);
            val.accept(new QueueChildren(queue));
        }
        return stack.stream();
    }

    private static class QueueChildren
    extends NullVisitor<Void, RuntimeException> {
        private final Deque<IValue> queue;

        public QueueChildren(Deque<IValue> queue) {
            this.queue = queue;
        }

        @Override
        public Void visitList(IList o) throws RuntimeException {
            o.stream().forEach(e -> this.queue.add((IValue)e));
            return null;
        }

        @Override
        public Void visitSet(ISet o) throws RuntimeException {
            o.stream().forEach(e -> this.queue.add((IValue)e));
            return null;
        }

        @Override
        public Void visitTuple(ITuple o) throws RuntimeException {
            StreamSupport.stream(o.spliterator(), false).forEach(e -> this.queue.add((IValue)e));
            return null;
        }

        @Override
        public Void visitNode(INode o) throws RuntimeException {
            StreamSupport.stream(o.getChildren().spliterator(), false).forEach(e -> this.queue.add((IValue)e));
            return null;
        }

        @Override
        public Void visitConstructor(IConstructor o) throws RuntimeException {
            StreamSupport.stream(o.getChildren().spliterator(), false).forEach(e -> this.queue.add((IValue)e));
            return null;
        }

        @Override
        public Void visitMap(IMap o) throws RuntimeException {
            Iterable it = () -> o.entryIterator();
            StreamSupport.stream(it.spliterator(), false).forEach(e -> {
                this.queue.add((IValue)e.getKey());
                this.queue.add((IValue)e.getValue());
            });
            return null;
        }
    }

    private static class TopDown
    extends Single {
        private TopDown() {
        }

        @Override
        public Stream<IValue> visitNode(INode o) {
            return Stream.concat(Stream.of(o), StreamSupport.stream(o.getChildren().spliterator(), false).flatMap(c -> c.accept(this)));
        }

        @Override
        public Stream<IValue> visitList(IList o) {
            return Stream.concat(Stream.of(o), o.stream().flatMap(c -> c.accept(this)));
        }

        @Override
        public Stream<IValue> visitSet(ISet o) {
            return Stream.concat(Stream.of(o), o.stream().flatMap(c -> c.accept(this)));
        }

        @Override
        public Stream<IValue> visitTuple(ITuple o) {
            return Stream.concat(Stream.of(o), StreamSupport.stream(o.spliterator(), false).flatMap(c -> c.accept(this)));
        }

        @Override
        public Stream<IValue> visitConstructor(IConstructor o) {
            return Stream.concat(Stream.of(o), StreamSupport.stream(o.getChildren().spliterator(), false));
        }

        @Override
        public Stream<IValue> visitMap(IMap o) {
            Iterable it = () -> o.entryIterator();
            return Stream.concat(Stream.of(o), StreamSupport.stream(it.spliterator(), false).flatMap(e -> Stream.of((IValue)e.getKey(), (IValue)e.getValue()).flatMap(c -> c.accept(this))));
        }
    }

    private static class BottomUp
    extends Single {
        private BottomUp() {
        }

        @Override
        public Stream<IValue> visitNode(INode o) {
            return Stream.concat(StreamSupport.stream(o.getChildren().spliterator(), false).flatMap(c -> c.accept(this)), Stream.of(o));
        }

        @Override
        public Stream<IValue> visitList(IList o) {
            return Stream.concat(o.stream().flatMap(c -> c.accept(this)), Stream.of(o));
        }

        @Override
        public Stream<IValue> visitSet(ISet o) {
            return Stream.concat(o.stream().flatMap(c -> c.accept(this)), Stream.of(o));
        }

        @Override
        public Stream<IValue> visitTuple(ITuple o) {
            return Stream.concat(StreamSupport.stream(o.spliterator(), false).flatMap(c -> c.accept(this)), Stream.of(o));
        }

        @Override
        public Stream<IValue> visitConstructor(IConstructor o) {
            return Stream.concat(StreamSupport.stream(o.getChildren().spliterator(), false).flatMap(c -> c.accept(this)), Stream.of(o));
        }

        @Override
        public Stream<IValue> visitMap(IMap o) {
            Iterable it = () -> o.entryIterator();
            return Stream.concat(StreamSupport.stream(it.spliterator(), false).flatMap(e -> Stream.of((IValue)e.getKey(), (IValue)e.getValue()).flatMap(c -> c.accept(this))), Stream.of(o));
        }
    }

    private static abstract class Single
    implements IValueVisitor<Stream<IValue>, RuntimeException> {
        private Single() {
        }

        @Override
        public Stream<IValue> visitNode(INode o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitString(IString o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitReal(IReal o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitRational(IRational o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitList(IList o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitSet(ISet o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitSourceLocation(ISourceLocation o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitTuple(ITuple o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitConstructor(IConstructor o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitInteger(IInteger o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitMap(IMap o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitBoolean(IBool o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitExternal(IExternalValue o) {
            return Stream.of(o);
        }

        @Override
        public Stream<IValue> visitDateTime(IDateTime o) {
            return Stream.of(o);
        }
    }
}

