/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.OptionalExpression;
import org.rascalmpl.ast.QualifiedName;

public abstract class Assignable
extends AbstractAST {
    public Assignable(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasArguments() {
        return false;
    }

    public List<Assignable> getArguments() {
        throw new UnsupportedOperationException();
    }

    public boolean hasElements() {
        return false;
    }

    public List<Assignable> getElements() {
        throw new UnsupportedOperationException();
    }

    public boolean hasArg() {
        return false;
    }

    public Assignable getArg() {
        throw new UnsupportedOperationException();
    }

    public boolean hasReceiver() {
        return false;
    }

    public Assignable getReceiver() {
        throw new UnsupportedOperationException();
    }

    public boolean hasDefaultExpression() {
        return false;
    }

    public Expression getDefaultExpression() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSecond() {
        return false;
    }

    public Expression getSecond() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSubscript() {
        return false;
    }

    public Expression getSubscript() {
        throw new UnsupportedOperationException();
    }

    public boolean hasAnnotation() {
        return false;
    }

    public Name getAnnotation() {
        throw new UnsupportedOperationException();
    }

    public boolean hasField() {
        return false;
    }

    public Name getField() {
        throw new UnsupportedOperationException();
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasOptFirst() {
        return false;
    }

    public OptionalExpression getOptFirst() {
        throw new UnsupportedOperationException();
    }

    public boolean hasOptLast() {
        return false;
    }

    public OptionalExpression getOptLast() {
        throw new UnsupportedOperationException();
    }

    public boolean hasQualifiedName() {
        return false;
    }

    public QualifiedName getQualifiedName() {
        throw new UnsupportedOperationException();
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isBracket() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isFieldAccess() {
        return false;
    }

    public boolean isIfDefinedOrDefault() {
        return false;
    }

    public boolean isSlice() {
        return false;
    }

    public boolean isSliceStep() {
        return false;
    }

    public boolean isSubscript() {
        return false;
    }

    public boolean isTuple() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public static class Variable
    extends Assignable {
        private final QualifiedName qualifiedName;

        public Variable(ISourceLocation src, IConstructor node, QualifiedName qualifiedName) {
            super(src, node);
            this.qualifiedName = qualifiedName;
        }

        @Override
        public boolean isVariable() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableVariable(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.qualifiedName.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.qualifiedName.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Variable)) {
                return false;
            }
            Variable tmp = (Variable)o;
            return tmp.qualifiedName.equals(this.qualifiedName);
        }

        @Override
        public int hashCode() {
            return 337 + 257 * this.qualifiedName.hashCode();
        }

        @Override
        public QualifiedName getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        public boolean hasQualifiedName() {
            return true;
        }

        @Override
        public Object clone() {
            return Variable.newInstance(this.getClass(), this.src, null, this.clone(this.qualifiedName));
        }
    }

    public static class Tuple
    extends Assignable {
        private final List<Assignable> elements;

        public Tuple(ISourceLocation src, IConstructor node, List<Assignable> elements) {
            super(src, node);
            this.elements = elements;
        }

        @Override
        public boolean isTuple() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableTuple(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.elements) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple tmp = (Tuple)o;
            return tmp.elements.equals(this.elements);
        }

        @Override
        public int hashCode() {
            return 353 + 31 * this.elements.hashCode();
        }

        @Override
        public List<Assignable> getElements() {
            return this.elements;
        }

        @Override
        public boolean hasElements() {
            return true;
        }

        @Override
        public Object clone() {
            return Tuple.newInstance(this.getClass(), this.src, null, this.clone(this.elements));
        }
    }

    public static class Subscript
    extends Assignable {
        private final Assignable receiver;
        private final Expression subscript;

        public Subscript(ISourceLocation src, IConstructor node, Assignable receiver, Expression subscript) {
            super(src, node);
            this.receiver = receiver;
            this.subscript = subscript;
        }

        @Override
        public boolean isSubscript() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableSubscript(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.receiver.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.receiver.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.subscript.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.subscript.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Subscript)) {
                return false;
            }
            Subscript tmp = (Subscript)o;
            return tmp.receiver.equals(this.receiver) && tmp.subscript.equals(this.subscript);
        }

        @Override
        public int hashCode() {
            return 29 + 151 * this.receiver.hashCode() + 29 * this.subscript.hashCode();
        }

        @Override
        public Assignable getReceiver() {
            return this.receiver;
        }

        @Override
        public boolean hasReceiver() {
            return true;
        }

        @Override
        public Expression getSubscript() {
            return this.subscript;
        }

        @Override
        public boolean hasSubscript() {
            return true;
        }

        @Override
        public Object clone() {
            return Subscript.newInstance(this.getClass(), this.src, null, this.clone(this.receiver), this.clone(this.subscript));
        }
    }

    public static class SliceStep
    extends Assignable {
        private final Assignable receiver;
        private final OptionalExpression optFirst;
        private final Expression second;
        private final OptionalExpression optLast;

        public SliceStep(ISourceLocation src, IConstructor node, Assignable receiver, OptionalExpression optFirst, Expression second, OptionalExpression optLast) {
            super(src, node);
            this.receiver = receiver;
            this.optFirst = optFirst;
            this.second = second;
            this.optLast = optLast;
        }

        @Override
        public boolean isSliceStep() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableSliceStep(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.receiver.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.receiver.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.optFirst.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.optFirst.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.second.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.second.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.optLast.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.optLast.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SliceStep)) {
                return false;
            }
            SliceStep tmp = (SliceStep)o;
            return tmp.receiver.equals(this.receiver) && tmp.optFirst.equals(this.optFirst) && tmp.second.equals(this.second) && tmp.optLast.equals(this.optLast);
        }

        @Override
        public int hashCode() {
            return 19 + 317 * this.receiver.hashCode() + 883 * this.optFirst.hashCode() + 719 * this.second.hashCode() + 233 * this.optLast.hashCode();
        }

        @Override
        public Assignable getReceiver() {
            return this.receiver;
        }

        @Override
        public boolean hasReceiver() {
            return true;
        }

        @Override
        public OptionalExpression getOptFirst() {
            return this.optFirst;
        }

        @Override
        public boolean hasOptFirst() {
            return true;
        }

        @Override
        public Expression getSecond() {
            return this.second;
        }

        @Override
        public boolean hasSecond() {
            return true;
        }

        @Override
        public OptionalExpression getOptLast() {
            return this.optLast;
        }

        @Override
        public boolean hasOptLast() {
            return true;
        }

        @Override
        public Object clone() {
            return SliceStep.newInstance(this.getClass(), this.src, null, this.clone(this.receiver), this.clone(this.optFirst), this.clone(this.second), this.clone(this.optLast));
        }
    }

    public static class Slice
    extends Assignable {
        private final Assignable receiver;
        private final OptionalExpression optFirst;
        private final OptionalExpression optLast;

        public Slice(ISourceLocation src, IConstructor node, Assignable receiver, OptionalExpression optFirst, OptionalExpression optLast) {
            super(src, node);
            this.receiver = receiver;
            this.optFirst = optFirst;
            this.optLast = optLast;
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableSlice(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.receiver.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.receiver.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.optFirst.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.optFirst.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.optLast.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.optLast.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Slice)) {
                return false;
            }
            Slice tmp = (Slice)o;
            return tmp.receiver.equals(this.receiver) && tmp.optFirst.equals(this.optFirst) && tmp.optLast.equals(this.optLast);
        }

        @Override
        public int hashCode() {
            return 487 + 419 * this.receiver.hashCode() + 2 * this.optFirst.hashCode() + 797 * this.optLast.hashCode();
        }

        @Override
        public Assignable getReceiver() {
            return this.receiver;
        }

        @Override
        public boolean hasReceiver() {
            return true;
        }

        @Override
        public OptionalExpression getOptFirst() {
            return this.optFirst;
        }

        @Override
        public boolean hasOptFirst() {
            return true;
        }

        @Override
        public OptionalExpression getOptLast() {
            return this.optLast;
        }

        @Override
        public boolean hasOptLast() {
            return true;
        }

        @Override
        public Object clone() {
            return Slice.newInstance(this.getClass(), this.src, null, this.clone(this.receiver), this.clone(this.optFirst), this.clone(this.optLast));
        }
    }

    public static class IfDefinedOrDefault
    extends Assignable {
        private final Assignable receiver;
        private final Expression defaultExpression;

        public IfDefinedOrDefault(ISourceLocation src, IConstructor node, Assignable receiver, Expression defaultExpression) {
            super(src, node);
            this.receiver = receiver;
            this.defaultExpression = defaultExpression;
        }

        @Override
        public boolean isIfDefinedOrDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableIfDefinedOrDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.receiver.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.receiver.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.defaultExpression.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.defaultExpression.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof IfDefinedOrDefault)) {
                return false;
            }
            IfDefinedOrDefault tmp = (IfDefinedOrDefault)o;
            return tmp.receiver.equals(this.receiver) && tmp.defaultExpression.equals(this.defaultExpression);
        }

        @Override
        public int hashCode() {
            return 937 + 439 * this.receiver.hashCode() + 439 * this.defaultExpression.hashCode();
        }

        @Override
        public Assignable getReceiver() {
            return this.receiver;
        }

        @Override
        public boolean hasReceiver() {
            return true;
        }

        @Override
        public Expression getDefaultExpression() {
            return this.defaultExpression;
        }

        @Override
        public boolean hasDefaultExpression() {
            return true;
        }

        @Override
        public Object clone() {
            return IfDefinedOrDefault.newInstance(this.getClass(), this.src, null, this.clone(this.receiver), this.clone(this.defaultExpression));
        }
    }

    public static class FieldAccess
    extends Assignable {
        private final Assignable receiver;
        private final Name field;

        public FieldAccess(ISourceLocation src, IConstructor node, Assignable receiver, Name field) {
            super(src, node);
            this.receiver = receiver;
            this.field = field;
        }

        @Override
        public boolean isFieldAccess() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableFieldAccess(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.receiver.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.receiver.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.field.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.field.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof FieldAccess)) {
                return false;
            }
            FieldAccess tmp = (FieldAccess)o;
            return tmp.receiver.equals(this.receiver) && tmp.field.equals(this.field);
        }

        @Override
        public int hashCode() {
            return 263 + 557 * this.receiver.hashCode() + 167 * this.field.hashCode();
        }

        @Override
        public Assignable getReceiver() {
            return this.receiver;
        }

        @Override
        public boolean hasReceiver() {
            return true;
        }

        @Override
        public Name getField() {
            return this.field;
        }

        @Override
        public boolean hasField() {
            return true;
        }

        @Override
        public Object clone() {
            return FieldAccess.newInstance(this.getClass(), this.src, null, this.clone(this.receiver), this.clone(this.field));
        }
    }

    public static class Constructor
    extends Assignable {
        private final Name name;
        private final List<Assignable> arguments;

        public Constructor(ISourceLocation src, IConstructor node, Name name, List<Assignable> arguments) {
            super(src, node);
            this.name = name;
            this.arguments = arguments;
        }

        @Override
        public boolean isConstructor() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableConstructor(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.arguments) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Constructor)) {
                return false;
            }
            Constructor tmp = (Constructor)o;
            return tmp.name.equals(this.name) && tmp.arguments.equals(this.arguments);
        }

        @Override
        public int hashCode() {
            return 601 + 619 * this.name.hashCode() + 167 * this.arguments.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public List<Assignable> getArguments() {
            return this.arguments;
        }

        @Override
        public boolean hasArguments() {
            return true;
        }

        @Override
        public Object clone() {
            return Constructor.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.arguments));
        }
    }

    public static class Bracket
    extends Assignable {
        private final Assignable arg;

        public Bracket(ISourceLocation src, IConstructor node, Assignable arg) {
            super(src, node);
            this.arg = arg;
        }

        @Override
        public boolean isBracket() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableBracket(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.arg.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.arg.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Bracket)) {
                return false;
            }
            Bracket tmp = (Bracket)o;
            return tmp.arg.equals(this.arg);
        }

        @Override
        public int hashCode() {
            return 977 + 797 * this.arg.hashCode();
        }

        @Override
        public Assignable getArg() {
            return this.arg;
        }

        @Override
        public boolean hasArg() {
            return true;
        }

        @Override
        public Object clone() {
            return Bracket.newInstance(this.getClass(), this.src, null, this.clone(this.arg));
        }
    }

    public static class Annotation
    extends Assignable {
        private final Assignable receiver;
        private final Name annotation;

        public Annotation(ISourceLocation src, IConstructor node, Assignable receiver, Name annotation) {
            super(src, node);
            this.receiver = receiver;
            this.annotation = annotation;
        }

        @Override
        public boolean isAnnotation() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitAssignableAnnotation(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.receiver.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.receiver.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.annotation.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.annotation.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Annotation)) {
                return false;
            }
            Annotation tmp = (Annotation)o;
            return tmp.receiver.equals(this.receiver) && tmp.annotation.equals(this.annotation);
        }

        @Override
        public int hashCode() {
            return 233 + 383 * this.receiver.hashCode() + 227 * this.annotation.hashCode();
        }

        @Override
        public Assignable getReceiver() {
            return this.receiver;
        }

        @Override
        public boolean hasReceiver() {
            return true;
        }

        @Override
        public Name getAnnotation() {
            return this.annotation;
        }

        @Override
        public boolean hasAnnotation() {
            return true;
        }

        @Override
        public Object clone() {
            return Annotation.newInstance(this.getClass(), this.src, null, this.clone(this.receiver), this.clone(this.annotation));
        }
    }
}

