/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.EvalCommand;
import org.rascalmpl.ast.IASTVisitor;

public abstract class Commands
extends AbstractAST {
    public Commands(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasCommands() {
        return false;
    }

    public List<EvalCommand> getCommands() {
        throw new UnsupportedOperationException();
    }

    public boolean isCommandlist() {
        return false;
    }

    public static class Commandlist
    extends Commands {
        private final List<EvalCommand> commands;

        public Commandlist(ISourceLocation src, IConstructor node, List<EvalCommand> commands) {
            super(src, node);
            this.commands = commands;
        }

        @Override
        public boolean isCommandlist() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCommandsCommandlist(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.commands) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Commandlist)) {
                return false;
            }
            Commandlist tmp = (Commandlist)o;
            return tmp.commands.equals(this.commands);
        }

        @Override
        public int hashCode() {
            return 127 + 389 * this.commands.hashCode();
        }

        @Override
        public List<EvalCommand> getCommands() {
            return this.commands;
        }

        @Override
        public boolean hasCommands() {
            return true;
        }

        @Override
        public Object clone() {
            return Commandlist.newInstance(this.getClass(), this.src, null, this.clone(this.commands));
        }
    }
}

