/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.PathPart;
import org.rascalmpl.ast.ProtocolPart;

public abstract class LocationLiteral
extends AbstractAST {
    public LocationLiteral(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasPathPart() {
        return false;
    }

    public PathPart getPathPart() {
        throw new UnsupportedOperationException();
    }

    public boolean hasProtocolPart() {
        return false;
    }

    public ProtocolPart getProtocolPart() {
        throw new UnsupportedOperationException();
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends LocationLiteral {
        private final ProtocolPart protocolPart;
        private final PathPart pathPart;

        public Default(ISourceLocation src, IConstructor node, ProtocolPart protocolPart, PathPart pathPart) {
            super(src, node);
            this.protocolPart = protocolPart;
            this.pathPart = pathPart;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitLocationLiteralDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.protocolPart.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.protocolPart.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.pathPart.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.pathPart.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.protocolPart.equals(this.protocolPart) && tmp.pathPart.equals(this.pathPart);
        }

        @Override
        public int hashCode() {
            return 479 + 89 * this.protocolPart.hashCode() + 937 * this.pathPart.hashCode();
        }

        @Override
        public ProtocolPart getProtocolPart() {
            return this.protocolPart;
        }

        @Override
        public boolean hasProtocolPart() {
            return true;
        }

        @Override
        public PathPart getPathPart() {
            return this.pathPart;
        }

        @Override
        public boolean hasPathPart() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.protocolPart), this.clone(this.pathPart));
        }
    }
}

