/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Assoc;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.ProdModifier;
import org.rascalmpl.ast.Sym;

public abstract class Prod
extends AbstractAST {
    public Prod(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasModifiers() {
        return false;
    }

    public List<ProdModifier> getModifiers() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSyms() {
        return false;
    }

    public List<Sym> getSyms() {
        throw new UnsupportedOperationException();
    }

    public boolean hasAssociativity() {
        return false;
    }

    public Assoc getAssociativity() {
        throw new UnsupportedOperationException();
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException();
    }

    public boolean hasReferenced() {
        return false;
    }

    public Name getReferenced() {
        throw new UnsupportedOperationException();
    }

    public boolean hasGroup() {
        return false;
    }

    public Prod getGroup() {
        throw new UnsupportedOperationException();
    }

    public boolean hasLhs() {
        return false;
    }

    public Prod getLhs() {
        throw new UnsupportedOperationException();
    }

    public boolean hasRhs() {
        return false;
    }

    public Prod getRhs() {
        throw new UnsupportedOperationException();
    }

    public boolean isAll() {
        return false;
    }

    public boolean isAssociativityGroup() {
        return false;
    }

    public boolean isFirst() {
        return false;
    }

    public boolean isLabeled() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isUnlabeled() {
        return false;
    }

    public static class Unlabeled
    extends Prod {
        private final List<ProdModifier> modifiers;
        private final List<Sym> syms;

        public Unlabeled(ISourceLocation src, IConstructor node, List<ProdModifier> modifiers, List<Sym> syms) {
            super(src, node);
            this.modifiers = modifiers;
            this.syms = syms;
        }

        @Override
        public boolean isUnlabeled() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProdUnlabeled(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.modifiers) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            for (AbstractAST abstractAST : this.syms) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Unlabeled)) {
                return false;
            }
            Unlabeled tmp = (Unlabeled)o;
            return tmp.modifiers.equals(this.modifiers) && tmp.syms.equals(this.syms);
        }

        @Override
        public int hashCode() {
            return 19 + 19 * this.modifiers.hashCode() + 19 * this.syms.hashCode();
        }

        @Override
        public List<ProdModifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public boolean hasModifiers() {
            return true;
        }

        @Override
        public List<Sym> getSyms() {
            return this.syms;
        }

        @Override
        public boolean hasSyms() {
            return true;
        }

        @Override
        public Object clone() {
            return Unlabeled.newInstance(this.getClass(), this.src, null, this.clone(this.modifiers), this.clone(this.syms));
        }
    }

    public static class Reference
    extends Prod {
        private final Name referenced;

        public Reference(ISourceLocation src, IConstructor node, Name referenced) {
            super(src, node);
            this.referenced = referenced;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProdReference(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.referenced.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.referenced.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Reference)) {
                return false;
            }
            Reference tmp = (Reference)o;
            return tmp.referenced.equals(this.referenced);
        }

        @Override
        public int hashCode() {
            return 197 + 5 * this.referenced.hashCode();
        }

        @Override
        public Name getReferenced() {
            return this.referenced;
        }

        @Override
        public boolean hasReferenced() {
            return true;
        }

        @Override
        public Object clone() {
            return Reference.newInstance(this.getClass(), this.src, null, this.clone(this.referenced));
        }
    }

    public static class Labeled
    extends Prod {
        private final List<ProdModifier> modifiers;
        private final Name name;
        private final List<Sym> syms;

        public Labeled(ISourceLocation src, IConstructor node, List<ProdModifier> modifiers, Name name, List<Sym> syms) {
            super(src, node);
            this.modifiers = modifiers;
            this.name = name;
            this.syms = syms;
        }

        @Override
        public boolean isLabeled() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProdLabeled(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.modifiers) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            $l = this.name.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.syms) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Labeled)) {
                return false;
            }
            Labeled tmp = (Labeled)o;
            return tmp.modifiers.equals(this.modifiers) && tmp.name.equals(this.name) && tmp.syms.equals(this.syms);
        }

        @Override
        public int hashCode() {
            return 23 + 491 * this.modifiers.hashCode() + 617 * this.name.hashCode() + 761 * this.syms.hashCode();
        }

        @Override
        public List<ProdModifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public boolean hasModifiers() {
            return true;
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public List<Sym> getSyms() {
            return this.syms;
        }

        @Override
        public boolean hasSyms() {
            return true;
        }

        @Override
        public Object clone() {
            return Labeled.newInstance(this.getClass(), this.src, null, this.clone(this.modifiers), this.clone(this.name), this.clone(this.syms));
        }
    }

    public static class First
    extends Prod {
        private final Prod lhs;
        private final Prod rhs;

        public First(ISourceLocation src, IConstructor node, Prod lhs, Prod rhs) {
            super(src, node);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean isFirst() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProdFirst(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.lhs.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.lhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.rhs.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.rhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof First)) {
                return false;
            }
            First tmp = (First)o;
            return tmp.lhs.equals(this.lhs) && tmp.rhs.equals(this.rhs);
        }

        @Override
        public int hashCode() {
            return 487 + 29 * this.lhs.hashCode() + 23 * this.rhs.hashCode();
        }

        @Override
        public Prod getLhs() {
            return this.lhs;
        }

        @Override
        public boolean hasLhs() {
            return true;
        }

        @Override
        public Prod getRhs() {
            return this.rhs;
        }

        @Override
        public boolean hasRhs() {
            return true;
        }

        @Override
        public Object clone() {
            return First.newInstance(this.getClass(), this.src, null, this.clone(this.lhs), this.clone(this.rhs));
        }
    }

    public static class AssociativityGroup
    extends Prod {
        private final Assoc associativity;
        private final Prod group;

        public AssociativityGroup(ISourceLocation src, IConstructor node, Assoc associativity, Prod group) {
            super(src, node);
            this.associativity = associativity;
            this.group = group;
        }

        @Override
        public boolean isAssociativityGroup() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProdAssociativityGroup(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.associativity.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.associativity.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.group.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.group.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof AssociativityGroup)) {
                return false;
            }
            AssociativityGroup tmp = (AssociativityGroup)o;
            return tmp.associativity.equals(this.associativity) && tmp.group.equals(this.group);
        }

        @Override
        public int hashCode() {
            return 191 + 191 * this.associativity.hashCode() + 409 * this.group.hashCode();
        }

        @Override
        public Assoc getAssociativity() {
            return this.associativity;
        }

        @Override
        public boolean hasAssociativity() {
            return true;
        }

        @Override
        public Prod getGroup() {
            return this.group;
        }

        @Override
        public boolean hasGroup() {
            return true;
        }

        @Override
        public Object clone() {
            return AssociativityGroup.newInstance(this.getClass(), this.src, null, this.clone(this.associativity), this.clone(this.group));
        }
    }

    public static class All
    extends Prod {
        private final Prod lhs;
        private final Prod rhs;

        public All(ISourceLocation src, IConstructor node, Prod lhs, Prod rhs) {
            super(src, node);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public boolean isAll() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitProdAll(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.lhs.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.lhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.rhs.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.rhs.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof All)) {
                return false;
            }
            All tmp = (All)o;
            return tmp.lhs.equals(this.lhs) && tmp.rhs.equals(this.rhs);
        }

        @Override
        public int hashCode() {
            return 757 + 449 * this.lhs.hashCode() + 167 * this.rhs.hashCode();
        }

        @Override
        public Prod getLhs() {
            return this.lhs;
        }

        @Override
        public boolean hasLhs() {
            return true;
        }

        @Override
        public Prod getRhs() {
            return this.rhs;
        }

        @Override
        public boolean hasRhs() {
            return true;
        }

        @Override
        public Object clone() {
            return All.newInstance(this.getClass(), this.src, null, this.clone(this.lhs), this.clone(this.rhs));
        }
    }
}

