/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.BasicType;
import org.rascalmpl.ast.DataTypeSelector;
import org.rascalmpl.ast.FunctionType;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.StructuredType;
import org.rascalmpl.ast.Sym;
import org.rascalmpl.ast.TypeVar;
import org.rascalmpl.ast.UserType;

public abstract class Type
extends AbstractAST {
    public Type(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasBasic() {
        return false;
    }

    public BasicType getBasic() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSelector() {
        return false;
    }

    public DataTypeSelector getSelector() {
        throw new UnsupportedOperationException();
    }

    public boolean hasFunction() {
        return false;
    }

    public FunctionType getFunction() {
        throw new UnsupportedOperationException();
    }

    public boolean hasStructured() {
        return false;
    }

    public StructuredType getStructured() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSymbol() {
        return false;
    }

    public Sym getSymbol() {
        throw new UnsupportedOperationException();
    }

    public boolean hasType() {
        return false;
    }

    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public boolean hasTypeVar() {
        return false;
    }

    public TypeVar getTypeVar() {
        throw new UnsupportedOperationException();
    }

    public boolean hasUser() {
        return false;
    }

    public UserType getUser() {
        throw new UnsupportedOperationException();
    }

    public boolean isBasic() {
        return false;
    }

    public boolean isBracket() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isSelector() {
        return false;
    }

    public boolean isStructured() {
        return false;
    }

    public boolean isSymbol() {
        return false;
    }

    public boolean isUser() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public static class Variable
    extends Type {
        private final TypeVar typeVar;

        public Variable(ISourceLocation src, IConstructor node, TypeVar typeVar) {
            super(src, node);
            this.typeVar = typeVar;
        }

        @Override
        public boolean isVariable() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeVariable(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.typeVar.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.typeVar.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Variable)) {
                return false;
            }
            Variable tmp = (Variable)o;
            return tmp.typeVar.equals(this.typeVar);
        }

        @Override
        public int hashCode() {
            return 277 + 487 * this.typeVar.hashCode();
        }

        @Override
        public TypeVar getTypeVar() {
            return this.typeVar;
        }

        @Override
        public boolean hasTypeVar() {
            return true;
        }

        @Override
        public Object clone() {
            return Variable.newInstance(this.getClass(), this.src, null, this.clone(this.typeVar));
        }
    }

    public static class User
    extends Type {
        private final UserType user;

        public User(ISourceLocation src, IConstructor node, UserType user) {
            super(src, node);
            this.user = user;
        }

        @Override
        public boolean isUser() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeUser(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.user.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.user.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof User)) {
                return false;
            }
            User tmp = (User)o;
            return tmp.user.equals(this.user);
        }

        @Override
        public int hashCode() {
            return 101 + 421 * this.user.hashCode();
        }

        @Override
        public UserType getUser() {
            return this.user;
        }

        @Override
        public boolean hasUser() {
            return true;
        }

        @Override
        public Object clone() {
            return User.newInstance(this.getClass(), this.src, null, this.clone(this.user));
        }
    }

    public static class Symbol
    extends Type {
        private final Sym symbol;

        public Symbol(ISourceLocation src, IConstructor node, Sym symbol) {
            super(src, node);
            this.symbol = symbol;
        }

        @Override
        public boolean isSymbol() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeSymbol(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Symbol)) {
                return false;
            }
            Symbol tmp = (Symbol)o;
            return tmp.symbol.equals(this.symbol);
        }

        @Override
        public int hashCode() {
            return 181 + 599 * this.symbol.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Object clone() {
            return Symbol.newInstance(this.getClass(), this.src, null, this.clone(this.symbol));
        }
    }

    public static class Structured
    extends Type {
        private final StructuredType structured;

        public Structured(ISourceLocation src, IConstructor node, StructuredType structured) {
            super(src, node);
            this.structured = structured;
        }

        @Override
        public boolean isStructured() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeStructured(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.structured.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.structured.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Structured)) {
                return false;
            }
            Structured tmp = (Structured)o;
            return tmp.structured.equals(this.structured);
        }

        @Override
        public int hashCode() {
            return 67 + 19 * this.structured.hashCode();
        }

        @Override
        public StructuredType getStructured() {
            return this.structured;
        }

        @Override
        public boolean hasStructured() {
            return true;
        }

        @Override
        public Object clone() {
            return Structured.newInstance(this.getClass(), this.src, null, this.clone(this.structured));
        }
    }

    public static class Selector
    extends Type {
        private final DataTypeSelector selector;

        public Selector(ISourceLocation src, IConstructor node, DataTypeSelector selector) {
            super(src, node);
            this.selector = selector;
        }

        @Override
        public boolean isSelector() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeSelector(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.selector.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.selector.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Selector)) {
                return false;
            }
            Selector tmp = (Selector)o;
            return tmp.selector.equals(this.selector);
        }

        @Override
        public int hashCode() {
            return 149 + 431 * this.selector.hashCode();
        }

        @Override
        public DataTypeSelector getSelector() {
            return this.selector;
        }

        @Override
        public boolean hasSelector() {
            return true;
        }

        @Override
        public Object clone() {
            return Selector.newInstance(this.getClass(), this.src, null, this.clone(this.selector));
        }
    }

    public static class Function
    extends Type {
        private final FunctionType function;

        public Function(ISourceLocation src, IConstructor node, FunctionType function) {
            super(src, node);
            this.function = function;
        }

        @Override
        public boolean isFunction() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeFunction(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.function.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.function.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Function)) {
                return false;
            }
            Function tmp = (Function)o;
            return tmp.function.equals(this.function);
        }

        @Override
        public int hashCode() {
            return 509 + 563 * this.function.hashCode();
        }

        @Override
        public FunctionType getFunction() {
            return this.function;
        }

        @Override
        public boolean hasFunction() {
            return true;
        }

        @Override
        public Object clone() {
            return Function.newInstance(this.getClass(), this.src, null, this.clone(this.function));
        }
    }

    public static class Bracket
    extends Type {
        private final Type type;

        public Bracket(ISourceLocation src, IConstructor node, Type type) {
            super(src, node);
            this.type = type;
        }

        @Override
        public boolean isBracket() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeBracket(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.type.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.type.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Bracket)) {
                return false;
            }
            Bracket tmp = (Bracket)o;
            return tmp.type.equals(this.type);
        }

        @Override
        public int hashCode() {
            return 641 + 313 * this.type.hashCode();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public Object clone() {
            return Bracket.newInstance(this.getClass(), this.src, null, this.clone(this.type));
        }
    }

    public static class Basic
    extends Type {
        private final BasicType basic;

        public Basic(ISourceLocation src, IConstructor node, BasicType basic) {
            super(src, node);
            this.basic = basic;
        }

        @Override
        public boolean isBasic() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTypeBasic(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.basic.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.basic.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Basic)) {
                return false;
            }
            Basic tmp = (Basic)o;
            return tmp.basic.equals(this.basic);
        }

        @Override
        public int hashCode() {
            return 769 + 163 * this.basic.hashCode();
        }

        @Override
        public BasicType getBasic() {
            return this.basic;
        }

        @Override
        public boolean hasBasic() {
            return true;
        }

        @Override
        public Object clone() {
            return Basic.newInstance(this.getClass(), this.src, null, this.clone(this.basic));
        }
    }
}

