/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.Type;

public abstract class UserType
extends AbstractAST {
    public UserType(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasParameters() {
        return false;
    }

    public List<Type> getParameters() {
        throw new UnsupportedOperationException();
    }

    public boolean hasName() {
        return false;
    }

    public QualifiedName getName() {
        throw new UnsupportedOperationException();
    }

    public boolean isName() {
        return false;
    }

    public boolean isParametric() {
        return false;
    }

    public static class Parametric
    extends UserType {
        private final QualifiedName name;
        private final List<Type> parameters;

        public Parametric(ISourceLocation src, IConstructor node, QualifiedName name, List<Type> parameters) {
            super(src, node);
            this.name = name;
            this.parameters = parameters;
        }

        @Override
        public boolean isParametric() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitUserTypeParametric(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.parameters) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Parametric)) {
                return false;
            }
            Parametric tmp = (Parametric)o;
            return tmp.name.equals(this.name) && tmp.parameters.equals(this.parameters);
        }

        @Override
        public int hashCode() {
            return 373 + 449 * this.name.hashCode() + 571 * this.parameters.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public List<Type> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean hasParameters() {
            return true;
        }

        @Override
        public Object clone() {
            return Parametric.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.parameters));
        }
    }

    public static class Name
    extends UserType {
        private final QualifiedName name;

        public Name(ISourceLocation src, IConstructor node, QualifiedName name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isName() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitUserTypeName(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Name)) {
                return false;
            }
            Name tmp = (Name)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 809 + 109 * this.name.hashCode();
        }

        @Override
        public QualifiedName getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return Name.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }
}

