/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Name;

public abstract class Variable
extends AbstractAST {
    public Variable(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasInitial() {
        return false;
    }

    public Expression getInitial() {
        throw new UnsupportedOperationException();
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException();
    }

    public boolean isInitialized() {
        return false;
    }

    public boolean isUnInitialized() {
        return false;
    }

    public static class UnInitialized
    extends Variable {
        private final Name name;

        public UnInitialized(ISourceLocation src, IConstructor node, Name name) {
            super(src, node);
            this.name = name;
        }

        @Override
        public boolean isUnInitialized() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitVariableUnInitialized(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof UnInitialized)) {
                return false;
            }
            UnInitialized tmp = (UnInitialized)o;
            return tmp.name.equals(this.name);
        }

        @Override
        public int hashCode() {
            return 19 + 137 * this.name.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Object clone() {
            return UnInitialized.newInstance(this.getClass(), this.src, null, this.clone(this.name));
        }
    }

    public static class Initialized
    extends Variable {
        private final Name name;
        private final Expression initial;

        public Initialized(ISourceLocation src, IConstructor node, Name name, Expression initial) {
            super(src, node);
            this.name = name;
            this.initial = initial;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitVariableInitialized(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.initial.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.initial.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Initialized)) {
                return false;
            }
            Initialized tmp = (Initialized)o;
            return tmp.name.equals(this.name) && tmp.initial.equals(this.initial);
        }

        @Override
        public int hashCode() {
            return 467 + 691 * this.name.hashCode() + 701 * this.initial.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public Expression getInitial() {
            return this.initial;
        }

        @Override
        public boolean hasInitial() {
            return true;
        }

        @Override
        public Object clone() {
            return Initialized.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.initial));
        }
    }
}

