/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.KeywordFormals;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.TypeArg;

public abstract class Variant
extends AbstractAST {
    public Variant(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasArguments() {
        return false;
    }

    public List<TypeArg> getArguments() {
        throw new UnsupportedOperationException();
    }

    public boolean hasKeywordArguments() {
        return false;
    }

    public KeywordFormals getKeywordArguments() {
        throw new UnsupportedOperationException();
    }

    public boolean hasName() {
        return false;
    }

    public Name getName() {
        throw new UnsupportedOperationException();
    }

    public boolean isNAryConstructor() {
        return false;
    }

    public static class NAryConstructor
    extends Variant {
        private final Name name;
        private final List<TypeArg> arguments;
        private final KeywordFormals keywordArguments;

        public NAryConstructor(ISourceLocation src, IConstructor node, Name name, List<TypeArg> arguments, KeywordFormals keywordArguments) {
            super(src, node);
            this.name = name;
            this.arguments = arguments;
            this.keywordArguments = keywordArguments;
        }

        @Override
        public boolean isNAryConstructor() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitVariantNAryConstructor(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.name.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.name.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.arguments) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
            $l = this.keywordArguments.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.keywordArguments.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NAryConstructor)) {
                return false;
            }
            NAryConstructor tmp = (NAryConstructor)o;
            return tmp.name.equals(this.name) && tmp.arguments.equals(this.arguments) && tmp.keywordArguments.equals(this.keywordArguments);
        }

        @Override
        public int hashCode() {
            return 907 + 41 * this.name.hashCode() + 59 * this.arguments.hashCode() + 823 * this.keywordArguments.hashCode();
        }

        @Override
        public Name getName() {
            return this.name;
        }

        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public List<TypeArg> getArguments() {
            return this.arguments;
        }

        @Override
        public boolean hasArguments() {
            return true;
        }

        @Override
        public KeywordFormals getKeywordArguments() {
            return this.keywordArguments;
        }

        @Override
        public boolean hasKeywordArguments() {
            return true;
        }

        @Override
        public Object clone() {
            return NAryConstructor.newInstance(this.getClass(), this.src, null, this.clone(this.name), this.clone(this.arguments), this.clone(this.keywordArguments));
        }
    }
}

