/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.exceptions;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.io.StandardTextWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

class StackTraceEntry {
    private final ISourceLocation loc;
    private final String name;

    StackTraceEntry(ISourceLocation loc, String funName) {
        this.loc = loc;
        this.name = funName;
    }

    public void format(Writer b, StandardTextWriter prettyPrinter) throws IOException {
        b.append("\tat ");
        if (this.loc != null) {
            if (this.name != null) {
                b.append(this.name);
            } else {
                b.append("*** somewhere ***");
            }
            b.append("(");
            prettyPrinter.write(this.loc, b);
            b.append(")");
        } else if (this.name != null) {
            b.append(this.name);
            b.append("(");
            b.append("*** somewhere ***");
            b.append(")");
        } else {
            b.append("*** unknown ***");
        }
        b.append("\n");
    }

    public String toString() {
        String string;
        StringWriter b = new StringWriter(128);
        try {
            this.format(b, new StandardTextWriter(false));
            string = b.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    b.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return e.toString();
            }
        }
        b.close();
        return string;
    }

    public ISourceLocation getLocation() {
        return this.loc;
    }

    public String getScopeName() {
        return this.name;
    }
}

