/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ideservices;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.io.PrintWriter;
import java.net.URI;
import org.jline.terminal.Terminal;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.uri.LogicalMapResolver;
import org.rascalmpl.uri.URIResolverRegistry;

public interface IDEServices
extends IRascalMonitor {
    public PrintWriter stderr();

    public void browse(URI var1, String var2, int var3);

    public void edit(ISourceLocation var1);

    default public ISourceLocation resolveProjectLocation(ISourceLocation input) {
        return input;
    }

    default public void registerLanguage(IConstructor language) {
        throw new UnsupportedOperationException("registerLanguage is not implemented in this environment.");
    }

    default public void unregisterLanguage(IConstructor language) {
        throw new UnsupportedOperationException("registerLanguage is not implemented in this environment.");
    }

    default public Terminal activeTerminal() {
        return null;
    }

    default public void applyDocumentsEdits(IList edits) {
        throw new UnsupportedOperationException("applyDocumentEdits is not implemented in this environment.");
    }

    default public void showMessage(IConstructor message) {
        this.logMessage(message);
    }

    default public void logMessage(IConstructor msg) {
        this.stderr().println(this.messageToString(msg));
    }

    default public String messageToString(IConstructor msg) {
        String type = msg.getName();
        boolean isError = type.equals("error");
        boolean isWarning = type.equals("warning");
        String locString = "unknown location";
        int col = 0;
        int line = 0;
        if (msg.has("at")) {
            ISourceLocation loc = (ISourceLocation)msg.get("at");
            locString = loc.top().toString().substring(1, loc.top().toString().length() - 1);
            if (loc.hasLineColumn()) {
                col = loc.getBeginColumn();
                line = loc.getBeginLine();
            }
        }
        String output = locString + ":" + String.format("%04d", line) + ":" + String.format("%04d", col) + ": " + ((IString)msg.get("msg")).getValue();
        if (isError) {
            return "[ERROR]  " + output;
        }
        if (isWarning) {
            return "[WARNING]" + output;
        }
        return "[INFO]   " + output;
    }

    default public void registerDiagnostics(IList messages) {
        for (IValue m4 : messages) {
            this.logMessage((IConstructor)m4);
        }
    }

    default public void unregisterDiagnostics(IList resources) {
    }

    default public void registerLocations(IString scheme, IString auth, IMap map) {
        URIResolverRegistry.getInstance().registerLogical(new LogicalMapResolver(scheme.getValue(), auth.getValue(), map));
    }

    default public void unregisterLocations(IString scheme, IString auth) {
        URIResolverRegistry.getInstance().unregisterLogical(scheme.getValue(), auth.getValue());
    }
}

