/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.ConstructorFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UninitializedPatternMatch;
import org.rascalmpl.interpreter.utils.Cases;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.interpreter.utils.TreeAsNode;
import org.rascalmpl.semantics.dynamic.QualifiedName;
import org.rascalmpl.types.RascalType;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class NodePattern
extends AbstractMatchingResult {
    private final TypeFactory tf = TypeFactory.getInstance();
    private Type type;
    private final Type patternConstructorType;
    private final QualifiedName qName;
    private final List<IMatchingResult> patternChildren;
    private INode subject;
    private int nextChild;
    private final IMatchingResult namePattern;
    private final Map<String, IMatchingResult> keywordParameters;
    private final boolean matchUPTR;

    public NodePattern(IEvaluatorContext ctx, Expression x, IMatchingResult matchPattern, QualifiedName name, Type constructorType, List<IMatchingResult> list, Map<String, IMatchingResult> keywordParameters) {
        super(ctx, x);
        this.patternConstructorType = constructorType;
        this.patternChildren = list;
        this.keywordParameters = keywordParameters;
        if (matchPattern != null) {
            this.namePattern = matchPattern;
            this.matchUPTR = false;
            this.qName = null;
        } else if (name != null) {
            this.namePattern = null;
            this.qName = name;
            this.matchUPTR = Cases.IUPTR_NAMES.contains(Names.fullName(this.qName));
        } else {
            this.namePattern = null;
            this.qName = null;
            this.matchUPTR = false;
        }
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        INode node;
        super.initMatch(subject);
        this.hasNext = false;
        if (subject.isVoid()) {
            throw new UninitializedPatternMatch("Uninitialized pattern match: trying to match a value of the type 'void'", this.ctx.getCurrentAST());
        }
        if (!subject.getValue().getType().isSubtypeOf(this.tf.nodeType())) {
            return;
        }
        this.subject = !this.matchUPTR && RascalType.isNonterminal(subject.getDynamicType()) && TreeAdapter.isAppl((ITree)subject.getValue()) ? new TreeAsNode((ITree)subject.getValue()) : (INode)subject.getValue();
        String sname = this.subject.getName();
        if (this.qName != null) {
            if (!((QualifiedName.Default)this.qName).lastName().equals(sname)) {
                return;
            }
        } else {
            IString nameVal = this.ctx.getValueFactory().string(sname);
            this.namePattern.initMatch(ResultFactory.makeResult(this.tf.stringType(), nameVal, this.ctx));
            if (!this.namePattern.hasNext() || !this.namePattern.next()) {
                return;
            }
        }
        Type patternType = this.getType(this.ctx.getCurrentEnvt(), null);
        Type subjectType = this.subject.getType();
        if (subjectType.isAbstractData()) {
            subjectType = ((IConstructor)this.subject).getConstructorType();
        }
        if ((node = this.subject).arity() != this.patternChildren.size()) {
            return;
        }
        if (!patternType.comparable(subjectType)) {
            return;
        }
        this.hasNext = true;
        IValue[] subjectChildren = new IValue[this.patternChildren.size()];
        for (int i = 0; i < this.patternChildren.size(); ++i) {
            subjectChildren[i] = this.subject.get(i);
            IMatchingResult patternChild = this.patternChildren.get(i);
            patternChild.initMatch(ResultFactory.makeResult(subjectChildren[i].getType(), subjectChildren[i], this.ctx));
            this.hasNext = patternChild.hasNext();
            if (!this.hasNext) break;
        }
        if (this.ctx.getCurrentEnvt().getStore().hasKeywordParameters(this.type)) {
            ConstructorFunction func = this.ctx.getCurrentEnvt().getConstructorFunction(this.type);
            Map<String, IValue> kwArgs = ((INode)((Object)subject)).asWithKeywordParameters().getParameters();
            Map<String, Type> kwFormals = this.ctx.getCurrentEnvt().getStore().getKeywordParameters(this.type);
            for (String kwLabel : this.keywordParameters.keySet()) {
                IValue subjectParam = kwArgs.get(kwLabel);
                if (subjectParam == null) {
                    subjectParam = func.computeDefaultKeywordParameter(kwLabel, (IConstructor)subject.getValue(), this.ctx.getCurrentEnvt()).getValue();
                }
                IMatchingResult matcher = this.keywordParameters.get(kwLabel);
                matcher.initMatch(ResultFactory.makeResult(kwFormals.get(kwLabel), subjectParam, this.ctx));
                if (matcher.hasNext()) continue;
                this.hasNext = false;
                break;
            }
        } else if (this.subject.mayHaveKeywordParameters()) {
            Map<String, IValue> kwArgs = this.subject.asWithKeywordParameters().getParameters();
            ConstructorFunction func = null;
            Type paramType = this.tf.valueType();
            if (this.subject.getType().isAbstractData()) {
                func = this.ctx.getCurrentEnvt().getConstructorFunction(((IConstructor)this.subject).getConstructorType());
            }
            for (Map.Entry<String, IMatchingResult> entry : this.keywordParameters.entrySet()) {
                IValue subjectParam = kwArgs.get(entry.getKey());
                if (subjectParam == null && func != null) {
                    subjectParam = func.computeDefaultKeywordParameter(entry.getKey(), (IConstructor)subject.getValue(), this.ctx.getCurrentEnvt()).getValue();
                }
                if (func != null) {
                    paramType = this.ctx.getCurrentEnvt().getStore().getKeywordParameterType(func.getConstructorType(), entry.getKey());
                }
                if (subjectParam != null) {
                    IMatchingResult matcher = entry.getValue();
                    matcher.initMatch(ResultFactory.makeResult(paramType, subjectParam, this.ctx));
                    if (matcher.hasNext()) continue;
                    this.hasNext = false;
                } else {
                    this.hasNext = false;
                }
                break;
            }
        }
        this.nextChild = 0;
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        if (this.type == null) {
            this.type = this.getConstructorType(env);
            if (this.type != null && this.type.isConstructor()) {
                this.type = this.getConstructorType(env).getAbstractDataType();
            }
            if (this.type == null) {
                this.type = TypeFactory.getInstance().nodeType();
            }
        }
        return this.type;
    }

    public Type getConstructorType(Environment env) {
        return this.patternConstructorType;
    }

    @Override
    public List<IVarPattern> getVariables() {
        LinkedList<IVarPattern> res = new LinkedList<IVarPattern>();
        for (IMatchingResult c : this.patternChildren) {
            res.addAll(c.getVariables());
        }
        for (IMatchingResult v : this.keywordParameters.values()) {
            res.addAll(v.getVariables());
        }
        if (res.isEmpty()) {
            res.add(new IVarPattern(){

                @Override
                public String name() {
                    return "_";
                }

                @Override
                public boolean isVarIntroducing() {
                    return false;
                }

                @Override
                public Type getType() {
                    return NodePattern.this.tf.voidType();
                }
            });
        }
        return res;
    }

    @Override
    public boolean next() {
        this.checkInitialized();
        if (!this.hasNext) {
            return false;
        }
        if (this.patternChildren.size() == 0) {
            this.hasNext = false;
            return this.nextKeywordParameters();
        }
        while (this.nextChild >= 0) {
            int i;
            IMatchingResult nextPattern = this.patternChildren.get(this.nextChild);
            if (nextPattern.hasNext() && nextPattern.next()) {
                if (this.nextChild == this.patternChildren.size() - 1) {
                    this.hasNext = false;
                    for (i = this.nextChild; i >= 0; --i) {
                        IMatchingResult child = this.patternChildren.get(i);
                        this.hasNext |= child.hasNext();
                        if (this.patternConstructorType == null || this.patternConstructorType.isNode() || !this.hasNext) continue;
                        child.updateType(this.patternConstructorType.getFieldType(i++));
                    }
                    return this.nextKeywordParameters();
                }
                ++this.nextChild;
                continue;
            }
            --this.nextChild;
            if (this.nextChild < 0) continue;
            for (i = this.nextChild + 1; i < this.patternChildren.size(); ++i) {
                IValue childValue = this.subject.get(i);
                IMatchingResult tailChild = this.patternChildren.get(i);
                tailChild.initMatch(ResultFactory.makeResult(childValue.getType(), childValue, this.ctx));
            }
        }
        this.hasNext = false;
        return false;
    }

    private boolean nextKeywordParameters() {
        for (Map.Entry<String, IMatchingResult> entry : this.keywordParameters.entrySet()) {
            if (entry.getValue().next()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n = this.patternChildren.size();
        StringBuilder res = new StringBuilder(this.qName != null ? Names.fullName(this.qName) : this.namePattern.toString());
        res.append("(");
        if (n == 1) {
            res.append(")");
            return res.toString();
        }
        String sep = "";
        for (IMatchingResult iMatchingResult : this.patternChildren) {
            res.append(sep);
            sep = ", ";
            res.append(iMatchingResult.toString());
        }
        for (Map.Entry entry : this.keywordParameters.entrySet()) {
            res.append(sep);
            sep = ", ";
            res.append((String)entry.getKey());
            res.append("=");
            res.append(((IMatchingResult)entry.getValue()).toString());
        }
        res.append(")");
        return res.toString();
    }
}

