/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import java.util.Iterator;
import org.rascalmpl.interpreter.IEvaluatorContext;

class SubSetGenerator
implements Iterator<ISet> {
    private final IEvaluatorContext ctx;
    private ISet remainingElements;
    private Iterator<IValue> elementGen;
    private SubSetGenerator subsetGen;
    private IValue currentElement;
    private boolean hasNext;
    private boolean debug = false;

    SubSetGenerator(ISet elements, IEvaluatorContext ctx) {
        this.remainingElements = elements;
        this.elementGen = elements.iterator();
        this.ctx = ctx;
        this.hasNext = true;
    }

    @Override
    public boolean hasNext() {
        if (this.debug) {
            System.err.println("SubSetGenerator.hasNext: " + this.hasNext);
        }
        return this.hasNext;
    }

    @Override
    public ISet next() {
        if (this.debug) {
            System.err.println("SubSetGenerator.next: hasNext = " + this.hasNext);
        }
        if (this.subsetGen == null || !this.subsetGen.hasNext()) {
            if (this.elementGen.hasNext()) {
                this.currentElement = this.elementGen.next();
                this.remainingElements = this.remainingElements.subtract(this.ctx.getValueFactory().set(this.currentElement));
                this.subsetGen = new SubSetGenerator(this.remainingElements, this.ctx);
            } else {
                this.hasNext = false;
                return this.ctx.getValueFactory().set(new IValue[0]);
            }
        }
        ISet result = this.subsetGen.next().insert(this.currentElement);
        if (this.debug) {
            System.err.println("SubSetGenerator.next returns: " + result);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove in SubSetGenerator");
    }
}

