/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result.util;

import io.usethesource.vallang.IValue;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MemoizationCache<TResult> {
    private static final int PRIME1 = -1640531535;
    private static final int PRIME2 = -2048144777;
    private static final int PRIME3 = -1028477379;
    private static final int PRIME4 = 668265263;
    private static final int PRIME5 = 374761393;
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Map<Object, KeySoftReference<TResult>> cache = new HashMap<Object, KeySoftReference<TResult>>();

    private static int calculateHash(IValue[] params, Map<String, IValue> keyArgs) {
        int h2;
        int len = params.length;
        int i = 0;
        if (len >= 4) {
            int v1 = 981052377;
            int v2 = -1673383384;
            int v3 = 374761393;
            int v4 = 2015292928;
            int limit = len - 4;
            do {
                v1 += params[i++].hashCode() * -2048144777;
                v1 = Integer.rotateLeft(v1, 13) * -1640531535;
                v2 += params[i++].hashCode() * -2048144777;
                v2 = Integer.rotateLeft(v2, 13) * -1640531535;
                v3 += params[i++].hashCode() * -2048144777;
                v3 = Integer.rotateLeft(v3, 13) * -1640531535;
                v4 += params[i++].hashCode() * -2048144777;
                v4 = Integer.rotateLeft(v4, 13) * -1640531535;
            } while (i < limit);
            h2 = Integer.rotateLeft(v1, 1) + Integer.rotateLeft(v2, 7) + Integer.rotateLeft(v3, 12) + Integer.rotateLeft(v4, 18);
        } else {
            h2 = 374761393;
        }
        while (i < len) {
            h2 += params[i++].hashCode() * -1028477379;
            h2 = Integer.rotateLeft(h2, 17) * 668265263;
        }
        if (keyArgs != null) {
            h2 += keyArgs.hashCode() * -1028477379;
            h2 = Integer.rotateLeft(h2, 17) * 668265263;
        }
        h2 ^= h2 >>> 15;
        h2 *= -2048144777;
        h2 ^= h2 >>> 13;
        h2 *= -1028477379;
        h2 ^= h2 >>> 16;
        return h2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupCache() {
        HashSet<CacheKeyWrapper> toCleanup = new HashSet<CacheKeyWrapper>();
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            Reference cleared = null;
            do {
                if ((cleared = this.queue.poll()) == null || !(cleared instanceof KeySoftReference)) continue;
                toCleanup.add(new CacheKeyWrapper(((KeySoftReference)cleared).key));
            } while (cleared != null);
        }
        for (CacheKeyWrapper ckw : toCleanup) {
            CacheKey cl = ckw.key;
            this.cache.remove(cl);
            if (cl.keyArgs != null) {
                cl.keyArgs.clear();
            }
            for (int i = 0; i < cl.params.length; ++i) {
                cl.params[i] = null;
            }
        }
    }

    public TResult getStoredResult(IValue[] params, Map<String, IValue> keyArgs) {
        this.cleanupCache();
        KeySoftReference<TResult> result = this.cache.get(new LookupKey(params, keyArgs));
        return result == null ? null : (TResult)result.get();
    }

    public void clear() {
        for (Map.Entry<Object, KeySoftReference<TResult>> e : this.cache.entrySet()) {
            e.getValue().clear();
        }
        this.cache.clear();
    }

    public TResult storeResult(IValue[] params, Map<String, IValue> keyArgs, TResult result) {
        this.cleanupCache();
        CacheKey newKey = new CacheKey(params, keyArgs, this.queue);
        this.cache.put(newKey, new KeySoftReference<TResult>(result, newKey, this.queue));
        return result;
    }

    private static class CacheKeyWrapper {
        private final CacheKey key;

        public CacheKeyWrapper(CacheKey key) {
            this.key = key;
        }

        public int hashCode() {
            return this.key.storedHash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKeyWrapper) {
                return ((CacheKeyWrapper)obj).key == this.key;
            }
            return false;
        }
    }

    private static class KeySoftReference<K>
    extends SoftReference<K> {
        private CacheKey key;

        public KeySoftReference(K ref, CacheKey key, ReferenceQueue queue) {
            super(ref, queue);
            this.key = key;
        }
    }

    private static class LookupKey {
        private final int storedHash;
        private final IValue[] params;
        private final Map<String, IValue> keyArgs;
        private final int keyArgsSize;

        public LookupKey(IValue[] params, Map<String, IValue> keyArgs) {
            this.storedHash = MemoizationCache.calculateHash(params, keyArgs);
            this.params = params;
            this.keyArgs = keyArgs;
            this.keyArgsSize = keyArgs == null ? 0 : keyArgs.size();
        }

        public int hashCode() {
            return this.storedHash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                if (other.storedHash != this.storedHash) {
                    return false;
                }
                if (other.params.length != this.params.length) {
                    return false;
                }
                for (int i = 0; i < this.params.length; ++i) {
                    IValue tp = this.params[i];
                    IValue op = (IValue)other.params[i].get();
                    if (tp == null || op == null) {
                        return false;
                    }
                    if (tp.equals(op)) continue;
                    return false;
                }
                if (other.keyArgsSize != this.keyArgsSize) {
                    return false;
                }
                if (this.keyArgsSize > 0) {
                    for (Map.Entry<String, IValue> kv : this.keyArgs.entrySet()) {
                        IValue tp = kv.getValue();
                        IValue op = (IValue)other.keyArgs.get(kv.getKey()).get();
                        if (tp == null || op == null) {
                            return false;
                        }
                        if (tp.equals(op)) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static class CacheKey {
        private final int storedHash;
        private final KeySoftReference[] params;
        private final int keyArgsSize;
        private final Map<String, KeySoftReference<IValue>> keyArgs;

        public CacheKey(IValue[] params, Map<String, IValue> keyArgs, ReferenceQueue queue) {
            this.storedHash = MemoizationCache.calculateHash(params, keyArgs);
            this.params = new KeySoftReference[params.length];
            for (int i = 0; i < params.length; ++i) {
                this.params[i] = new KeySoftReference<IValue>(params[i], this, queue);
            }
            if (keyArgs != null) {
                this.keyArgs = new HashMap<String, KeySoftReference<IValue>>(keyArgs.size());
                for (Map.Entry<String, IValue> e : keyArgs.entrySet()) {
                    this.keyArgs.put(e.getKey(), new KeySoftReference<IValue>(e.getValue(), this, queue));
                }
                this.keyArgsSize = keyArgs.size();
            } else {
                this.keyArgs = null;
                this.keyArgsSize = 0;
            }
        }

        public int hashCode() {
            return this.storedHash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof LookupKey) {
                return ((LookupKey)obj).equals(this);
            }
            return false;
        }
    }
}

