/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.staticErrors;

import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import org.rascalmpl.interpreter.result.AbstractFunction;

public class CommandlineError
extends RuntimeException {
    private static final long serialVersionUID = -5679812063174925071L;
    private final AbstractFunction main;

    public CommandlineError(String message, AbstractFunction main) {
        super(message);
        this.main = main;
    }

    public String help(String command) {
        TypeFactory tf = TypeFactory.getInstance();
        StringBuilder b = new StringBuilder();
        b.append("Usage: ");
        b.append(command);
        Type kwargs = this.main.getKeywordArgumentTypes(this.main.getEnv());
        if (kwargs.getArity() > 1) {
            b.append(" [options]\n\nOptions:\n");
            for (String param : kwargs.getFieldNames()) {
                b.append("\t-");
                b.append(param);
                if (kwargs.getFieldType(param).isSubtypeOf(tf.boolType())) {
                    b.append("\t[arg]: one of nothing (true), '1', '0', 'true' or 'false';\n");
                    continue;
                }
                b.append("\t[arg]: " + kwargs.getFieldType(param) + " argument;\n");
            }
        } else {
            b.append('\n');
        }
        return b.toString();
    }
}

