/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValueFactory;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.library.Prelude;

public class Clipboard {
    private final IValueFactory vf;
    private final java.awt.datatransfer.Clipboard cp;
    private IRascalMonitor monitor;

    public Clipboard(IValueFactory vf, IRascalMonitor monitor) {
        this.vf = vf;
        this.cp = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.monitor = monitor;
    }

    public void copy(IString arg) {
        StringSelection selection = new StringSelection(arg.getValue());
        this.cp.setContents(selection, selection);
    }

    public IString paste() {
        IString iString;
        block8: {
            DataFlavor flavor = DataFlavor.getTextPlainUnicodeFlavor();
            Reader data = flavor.getReaderForText(this.cp.getContents(null));
            try {
                iString = this.vf.string(Prelude.consumeInputStream(data));
                if (data == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (data != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    this.monitor.warning("Clipboard::paste failed", null);
                    return this.vf.string("");
                }
            }
            data.close();
        }
        return iString;
    }

    public IString paste(IString mimetype) {
        IString iString;
        block10: {
            DataFlavor flavor = new DataFlavor(mimetype.getValue());
            Reader data = flavor.getReaderForText(this.cp.getContents(null));
            try {
                iString = this.vf.string(Prelude.consumeInputStream(data));
                if (data == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (data != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClassNotFoundException e) {
                    throw RuntimeExceptionFactory.illegalArgument(this.vf.string("Unsupported clipboard mimetype: " + mimetype));
                }
                catch (UnsupportedFlavorException e) {
                    throw RuntimeExceptionFactory.illegalArgument(this.vf.string("Unsupported clipboard mimetype: " + e.getMessage()));
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(e.getMessage());
                }
            }
            data.close();
        }
        return iString;
    }

    public ISet availableTextMimetypes() {
        return Arrays.stream(this.cp.getAvailableDataFlavors()).filter(flavor -> flavor.isFlavorTextType()).map(flavor -> this.vf.tuple(this.vf.string(flavor.getHumanPresentableName()), this.vf.string(flavor.getMimeType()))).collect(this.vf.setWriter());
    }

    public ISet availableTextMimetypesFor(IString shortMimetype) {
        return Arrays.stream(this.cp.getAvailableDataFlavors()).filter(flavor -> flavor.isFlavorTextType()).filter(flavor -> flavor.isMimeTypeEqual(shortMimetype.getValue())).map(flavor -> this.vf.tuple(this.vf.string(flavor.getHumanPresentableName()), this.vf.string(flavor.getMimeType()))).collect(this.vf.setWriter());
    }
}

