/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValueFactory;
import org.rascalmpl.debug.IRascalMonitor;

public class Monitor {
    private final IValueFactory values;
    private final IRascalMonitor services;

    public Monitor(IValueFactory vf, IRascalMonitor monitor) {
        this.values = vf;
        this.services = monitor;
    }

    public void jobStart(IString name, IInteger work, IInteger totalWork) {
        this.services.jobStart(name.getValue(), work.intValue(), totalWork.intValue());
    }

    public void jobStep(IString name, IString message, IInteger inc) {
        this.services.jobStep(name.getValue(), message.getValue(), inc.intValue());
    }

    public IInteger jobEnd(IString name, IBool succeeded) {
        return this.values.integer(this.services.jobEnd(name.getValue(), succeeded.getValue()));
    }

    public IBool jobIsCancelled(IString name) {
        return this.values.bool(this.services.jobIsCanceled(name.getValue()));
    }

    public void jobTodo(IString name, IInteger work) {
        this.services.jobTodo(name.getValue(), work.intValue());
    }

    public void jobWarning(IString message, ISourceLocation src) {
        this.services.warning(message.getValue(), src);
    }
}

