/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.util;

import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.library.util.SemVer;

public class SemVerLib {
    private final IValueFactory vf;

    public SemVerLib(IValueFactory values) {
        this.vf = values;
    }

    private SemVer makeSemVer(IString version) {
        try {
            return new SemVer(version.getValue());
        }
        catch (Exception e) {
            throw RuntimeExceptionFactory.illegalArgument(version);
        }
    }

    public IValue satisfiesVersion(IString version, IString rangeSet) {
        try {
            return this.vf.bool(this.makeSemVer(version).satisfiesVersion(rangeSet.getValue()));
        }
        catch (Exception e) {
            throw RuntimeExceptionFactory.illegalArgument(rangeSet);
        }
    }

    public IValue lessVersion(IString version1, IString version2) {
        return this.vf.bool(this.makeSemVer(version1).lessVersion(this.makeSemVer(version2)));
    }

    public IValue lessEqualVersion(IString version1, IString version2) {
        return this.vf.bool(this.makeSemVer(version1).lessEqualVersion(this.makeSemVer(version2)));
    }

    public IValue greaterVersion(IString version1, IString version2) {
        return this.vf.bool(this.makeSemVer(version1).greaterVersion(this.makeSemVer(version2)));
    }

    public IValue greaterEqualVersion(IString version1, IString version2) {
        return this.vf.bool(this.makeSemVer(version1).greaterEqualVersion(this.makeSemVer(version2)));
    }

    public IValue equalVersion(IString version1, IString version2) {
        return this.vf.bool(this.makeSemVer(version1).equalVersion(this.makeSemVer(version2)));
    }

    public IValue getRascalVersion() {
        return this.vf.string("0.0.0");
    }

    public IValue getRascalRuntimeVersion() {
        return this.vf.string("0.0.0");
    }

    public IValue getRascalCompilerVersion() {
        return this.vf.string("0.0.0");
    }

    public IValue getJavaRuntimeVersion() {
        return this.vf.string(Runtime.version().toString());
    }
}

