/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.exception;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValueFactory;
import java.net.URI;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.parser.gtd.util.DoubleStack;
import org.rascalmpl.parser.gtd.util.Stack;
import org.rascalmpl.values.ValueFactoryFactory;

public class ParseError
extends RuntimeException {
    private static final long serialVersionUID = 3755880608516802997L;
    private final URI location;
    private final int offset;
    private final int length;
    private final int beginLine;
    private final int endLine;
    private final int beginColumn;
    private final int endColumn;
    private final Stack<AbstractStackNode<?>> unexpandableNodes;
    private final Stack<AbstractStackNode<?>> unmatchableLeafNodes;
    private final DoubleStack<ArrayList<AbstractStackNode<?>>, AbstractStackNode<?>> unmatchableMidProductionNodes;
    private final DoubleStack<AbstractStackNode<?>, AbstractNode> filteredNodes;

    public ParseError(String message, URI location, int offset, int length, int beginLine, int endLine, int beginColumn, int endColumn, Stack<AbstractStackNode<?>> unexpandableNodes, Stack<AbstractStackNode<?>> unmatchableLeafNodes, DoubleStack<ArrayList<AbstractStackNode<?>>, AbstractStackNode<?>> unmatchableMidProductionNodes, DoubleStack<AbstractStackNode<?>, AbstractNode> filteredNodes) {
        super(message);
        this.location = location;
        this.offset = offset;
        this.length = length;
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.beginColumn = beginColumn;
        this.endColumn = endColumn;
        this.unexpandableNodes = unexpandableNodes;
        this.unmatchableLeafNodes = unmatchableLeafNodes;
        this.unmatchableMidProductionNodes = unmatchableMidProductionNodes;
        this.filteredNodes = filteredNodes;
    }

    public ParseError(String message, URI location, int offset, int length, int beginLine, int endLine, int beginColumn, int endColumn) {
        super(message);
        this.location = location;
        this.offset = offset;
        this.length = length;
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.beginColumn = beginColumn;
        this.endColumn = endColumn;
        this.unexpandableNodes = null;
        this.unmatchableLeafNodes = null;
        this.unmatchableMidProductionNodes = null;
        this.filteredNodes = null;
    }

    public ISourceLocation getLocation() {
        IValueFactory vf = ValueFactoryFactory.getValueFactory();
        ISourceLocation loc = vf.sourceLocation(this.location);
        return vf.sourceLocation(loc, this.offset, this.length, this.beginLine, this.endLine, this.beginColumn, this.endColumn);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public Stack<AbstractStackNode<?>> getUnexpandableNodes() {
        return this.unexpandableNodes;
    }

    public Stack<AbstractStackNode<?>> getUnmatchableLeafNodes() {
        return this.unmatchableLeafNodes;
    }

    public DoubleStack<ArrayList<AbstractStackNode<?>>, AbstractStackNode<?>> getUnmatchableMidProductionNodes() {
        return this.unmatchableMidProductionNodes;
    }

    public DoubleStack<AbstractStackNode<?>, AbstractNode> getFilteredNodes() {
        return this.filteredNodes;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage());
        sb.append("\n");
        sb.append("at ");
        sb.append(this.location);
        sb.append(" offset=");
        sb.append(this.offset);
        sb.append(" length=");
        sb.append(this.length);
        sb.append(" begin=");
        sb.append(this.beginLine);
        sb.append(":");
        sb.append(this.beginColumn);
        sb.append(" end=");
        sb.append(this.endLine);
        sb.append(":");
        sb.append(this.endColumn);
        return sb.toString();
    }

    public String toDetailedString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage());
        sb.append("\n");
        sb.append("at ");
        sb.append(this.location);
        sb.append(" offset=");
        sb.append(this.offset);
        sb.append(" length=");
        sb.append(this.length);
        sb.append(" begin=");
        sb.append(this.beginLine);
        sb.append(":");
        sb.append(this.beginColumn);
        sb.append(" end=");
        sb.append(this.endLine);
        sb.append(":");
        sb.append(this.endColumn);
        sb.append("\n");
        sb.append("Unexpandable nodes: ");
        int nrOfUnexpandableNodes = this.unexpandableNodes.getSize();
        if (nrOfUnexpandableNodes == 0) {
            sb.append("none");
        } else {
            for (int i = nrOfUnexpandableNodes - 1; i >= 0; --i) {
                sb.append("\n");
                sb.append(this.unexpandableNodes.get(i));
            }
        }
        sb.append("\n");
        sb.append("Unmatchable nodes: ");
        int nrOfUnmatchableLeafNodes = this.unmatchableLeafNodes.getSize();
        if (nrOfUnmatchableLeafNodes == 0) {
            sb.append("none");
        } else {
            for (int i = nrOfUnmatchableLeafNodes - 1; i >= 0; --i) {
                sb.append("\n");
                sb.append(this.unmatchableLeafNodes.get(i));
            }
        }
        sb.append("\n");
        sb.append("Unmatchable nodes: ");
        int nrOfUnmatchableMidProductionNodes = this.unmatchableMidProductionNodes.getSize();
        if (nrOfUnmatchableMidProductionNodes == 0) {
            sb.append("none");
        } else {
            for (int i = nrOfUnmatchableMidProductionNodes - 1; i >= 0; --i) {
                sb.append("\n");
                sb.append(this.unmatchableMidProductionNodes.getSecond(i));
            }
        }
        sb.append("\n");
        sb.append("Filtered nodes: ");
        int nrOfFilteredNodes = this.filteredNodes.getSize();
        if (nrOfFilteredNodes == 0) {
            sb.append("none");
        } else {
            for (int i = nrOfFilteredNodes - 1; i >= 0; --i) {
                sb.append("\n");
                sb.append(this.filteredNodes.getFirst(i));
            }
        }
        return sb.toString();
    }
}

