/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.result.out;

import java.net.URI;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.SortContainerNode;
import org.rascalmpl.parser.gtd.result.action.IActionExecutor;
import org.rascalmpl.parser.gtd.result.out.FilteringTracker;
import org.rascalmpl.parser.gtd.result.out.INodeConstructorFactory;
import org.rascalmpl.parser.gtd.result.out.INodeFlattener;
import org.rascalmpl.parser.gtd.result.struct.Link;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.parser.gtd.util.ForwardLink;
import org.rascalmpl.parser.gtd.util.IndexedStack;

public class SortContainerNodeFlattener<P, T, S> {
    private static final ForwardLink<AbstractNode> NO_NODES = ForwardLink.TERMINATOR;

    private void gatherAlternatives(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, Link child, ArrayList<T> gatheredAlternatives, Object production, IndexedStack<AbstractNode> stack, int depth, PositionStore positionStore, S sourceLocation, int offset, int endOffset, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment, boolean hasSideEffects) {
        AbstractNode resultNode = child.getNode();
        if (!resultNode.isEpsilon() || child.getPrefixes() != null) {
            boolean cacheable = child.isCacheable();
            INodeFlattener.CacheMode cacheMode = INodeFlattener.getCacheMode(cacheable, hasSideEffects);
            this.gatherProduction(converter, nodeConstructorFactory, child, new ForwardLink<AbstractNode>(NO_NODES, resultNode, cacheMode), gatheredAlternatives, production, stack, depth, positionStore, sourceLocation, offset, endOffset, filteringTracker, actionExecutor, environment, cacheable, hasSideEffects);
        } else {
            this.buildAlternative(converter, nodeConstructorFactory, NO_NODES, gatheredAlternatives, production, stack, depth, positionStore, sourceLocation, offset, endOffset, filteringTracker, actionExecutor, environment);
        }
    }

    private void gatherProduction(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, Link child, ForwardLink<AbstractNode> postFix, ArrayList<T> gatheredAlternatives, Object production, IndexedStack<AbstractNode> stack, int depth, PositionStore positionStore, S sourceLocation, int offset, int endOffset, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment, boolean parentCacheable, boolean hasSideEffects) {
        ArrayList<Link> prefixes = child.getPrefixes();
        if (prefixes == null) {
            this.buildAlternative(converter, nodeConstructorFactory, postFix, gatheredAlternatives, production, stack, depth, positionStore, sourceLocation, offset, endOffset, filteringTracker, actionExecutor, environment);
            return;
        }
        for (int i = prefixes.size() - 1; i >= 0; --i) {
            Link prefix = prefixes.get(i);
            boolean cacheable = parentCacheable || prefix.isCacheable();
            INodeFlattener.CacheMode cacheMode = INodeFlattener.getCacheMode(cacheable, hasSideEffects);
            this.gatherProduction(converter, nodeConstructorFactory, prefix, new ForwardLink<AbstractNode>(postFix, prefix.getNode(), cacheMode), gatheredAlternatives, production, stack, depth, positionStore, sourceLocation, offset, endOffset, filteringTracker, actionExecutor, environment, cacheable, hasSideEffects);
        }
    }

    private void buildAlternative(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, ForwardLink<AbstractNode> postFix, ArrayList<T> gatheredAlternatives, Object production, IndexedStack<AbstractNode> stack, int depth, PositionStore positionStore, S sourceLocation, int offset, int endOffset, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment) {
        Object newEnvironment = actionExecutor.enteringProduction(production, environment);
        int postFixLength = postFix.length;
        ArrayList<T> children = new ArrayList<T>();
        for (int i = 0; i < postFixLength; ++i) {
            AbstractNode node = (AbstractNode)postFix.element;
            postFix = postFix.next;
            newEnvironment = actionExecutor.enteringNode(production, i, newEnvironment);
            T constructedNode = converter.convert(nodeConstructorFactory, node, stack, depth, positionStore, filteringTracker, actionExecutor, environment, postFix.cacheMode);
            if (constructedNode == null) {
                actionExecutor.exitedProduction(production, true, newEnvironment);
                return;
            }
            children.add(constructedNode);
        }
        T result = nodeConstructorFactory.createSortNode(children, production);
        if (sourceLocation != null) {
            result = nodeConstructorFactory.addPositionInformation(result, sourceLocation);
        }
        if ((result = actionExecutor.filterProduction(result, environment)) == null) {
            filteringTracker.setLastFiltered(offset, endOffset);
            actionExecutor.exitedProduction(production, true, environment);
            return;
        }
        gatheredAlternatives.add(result);
        actionExecutor.exitedProduction(production, false, environment);
    }

    public T convertToUPTR(INodeFlattener<T, S> converter, INodeConstructorFactory<T, S> nodeConstructorFactory, SortContainerNode<P> node, IndexedStack<AbstractNode> stack, int depth, PositionStore positionStore, FilteringTracker filteringTracker, IActionExecutor<T> actionExecutor, Object environment) {
        int index;
        int offset = node.getOffset();
        int endOffset = node.getEndOffset();
        Object firstProduction = node.getFirstProduction();
        Object rhs = nodeConstructorFactory.getRhs(node.getFirstProduction());
        boolean hasSideEffects = actionExecutor.isImpure(rhs);
        S sourceLocation = null;
        URI input = node.getInput();
        if (!node.isLayout() && input != null) {
            sourceLocation = nodeConstructorFactory.createPositionInformation(input, offset, endOffset, positionStore);
        }
        if ((index = stack.contains(node)) != -1) {
            T cycle = nodeConstructorFactory.createCycleNode(depth - index, firstProduction);
            if ((cycle = actionExecutor.filterCycle(cycle, environment)) != null) {
                if (sourceLocation != null) {
                    cycle = nodeConstructorFactory.addPositionInformation(cycle, sourceLocation);
                }
            } else {
                filteringTracker.setLastFiltered(offset, endOffset);
            }
            return cycle;
        }
        int childDepth = depth + 1;
        stack.push(node, depth);
        ArrayList gatheredAlternatives = new ArrayList();
        this.gatherAlternatives(converter, nodeConstructorFactory, node.getFirstAlternative(), gatheredAlternatives, firstProduction, stack, childDepth, positionStore, sourceLocation, offset, endOffset, filteringTracker, actionExecutor, environment, hasSideEffects);
        ArrayList<Link> alternatives = node.getAdditionalAlternatives();
        ArrayList productions = node.getAdditionalProductions();
        if (alternatives != null) {
            for (int i = alternatives.size() - 1; i >= 0; --i) {
                this.gatherAlternatives(converter, nodeConstructorFactory, alternatives.get(i), gatheredAlternatives, productions.get(i), stack, childDepth, positionStore, sourceLocation, offset, endOffset, filteringTracker, actionExecutor, environment, hasSideEffects);
            }
        }
        Object result = null;
        int nrOfAlternatives = gatheredAlternatives.size();
        if (nrOfAlternatives == 1) {
            result = gatheredAlternatives.get(0);
        } else if (nrOfAlternatives > 0) {
            result = nodeConstructorFactory.createAmbiguityNode(gatheredAlternatives);
            if ((result = actionExecutor.filterAmbiguity(result, environment)) != null) {
                if (sourceLocation != null) {
                    result = nodeConstructorFactory.addPositionInformation(result, sourceLocation);
                }
            } else {
                filteringTracker.setLastFiltered(offset, endOffset);
            }
        }
        stack.dirtyPurge();
        return result;
    }
}

