/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack;

import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.stack.AbstractStackNode;
import org.rascalmpl.parser.gtd.stack.StackNodeVisitor;

public class RecoveryPointStackNode<P>
extends AbstractStackNode<P> {
    private final String name;
    private final P parent;

    public RecoveryPointStackNode(int id, P parent, AbstractStackNode<P> robustNode) {
        super(id, robustNode, robustNode.startLocation);
        this.prefixesMap = robustNode.prefixesMap;
        int productionLength = robustNode.dot + 1;
        if (productionLength == robustNode.production.length) {
            this.production = robustNode.production;
        } else {
            this.production = new AbstractStackNode[productionLength];
            System.arraycopy(robustNode.production, 0, this.production, 0, productionLength);
        }
        this.parent = parent;
        this.name = "recovery " + id;
        this.edgesMap = robustNode.edgesMap;
    }

    @Override
    public P getParentProduction() {
        return this.parent;
    }

    @Override
    public boolean isRecovered() {
        return true;
    }

    @Override
    public boolean isEmptyLeafNode() {
        return false;
    }

    @Override
    public boolean isEndNode() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractNode match(int[] input, int location) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractStackNode<P> getCleanCopy(int startLocation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractStackNode<P> getCleanCopyWithResult(int startLocation, AbstractNode result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractStackNode<P>[] getChildren() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canBeEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractStackNode<P> getEmptyChild() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractNode getResult() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toShortString() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(':');
        sb.append(this.getId());
        sb.append('(');
        sb.append(this.startLocation);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object peer) {
        return super.equals(peer);
    }

    @Override
    public boolean isEqual(AbstractStackNode<P> stackNode) {
        if (!(stackNode instanceof RecoveryPointStackNode)) {
            return false;
        }
        RecoveryPointStackNode otherNode = (RecoveryPointStackNode)stackNode;
        return otherNode.name.equals(this.name) && otherNode.startLocation == this.startLocation;
    }

    @Override
    public <R> R accept(StackNodeVisitor<P, R> visitor) {
        return visitor.visit(this);
    }
}

