/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class ObjectKeyedIntegerMap<K> {
    private Entry<K>[] entries;
    private int hashMask;
    private int bitSize = 2;
    private int threshold;
    private int load;

    public ObjectKeyedIntegerMap() {
        int nrOfEntries = 1 << this.bitSize;
        this.hashMask = nrOfEntries - 1;
        this.entries = new Entry[nrOfEntries];
        this.threshold = nrOfEntries;
        this.load = 0;
    }

    private void rehash() {
        int nrOfEntries = 1 << ++this.bitSize;
        int newHashMask = nrOfEntries - 1;
        Entry<K>[] oldEntries = this.entries;
        Entry[] newEntries = new Entry[nrOfEntries];
        Entry<Object> currentEntryRoot = new Entry<Object>(null, -1, -1, null);
        Entry<Object> shiftedEntryRoot = new Entry<Object>(null, -1, -1, null);
        int oldSize = oldEntries.length;
        for (int i = oldSize - 1; i >= 0; --i) {
            Entry<K> e = oldEntries[i];
            if (e == null) continue;
            Entry<Object> lastCurrentEntry = currentEntryRoot;
            Entry<Object> lastShiftedEntry = shiftedEntryRoot;
            int lastPosition = -1;
            do {
                int position;
                if ((position = e.hash & newHashMask) == i) {
                    if (position != lastPosition) {
                        lastCurrentEntry.next = e;
                    }
                    lastCurrentEntry = e;
                    continue;
                }
                if (position != lastPosition) {
                    lastShiftedEntry.next = e;
                }
                lastShiftedEntry = e;
            } while ((e = e.next) != null);
            lastCurrentEntry.next = null;
            lastShiftedEntry.next = null;
            newEntries[i] = currentEntryRoot.next;
            newEntries[i | oldSize] = shiftedEntryRoot.next;
        }
        this.threshold <<= 1;
        this.entries = newEntries;
        this.hashMask = newHashMask;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    public void put(K key, int value) {
        this.ensureCapacity();
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<K> entry = currentStartEntry;
            do {
                if (hash != entry.hash || !entry.key.equals(key)) continue;
                entry.value = value;
            } while ((entry = entry.next) != null);
        }
        this.entries[position] = new Entry<K>(key, value, hash, currentStartEntry);
        ++this.load;
    }

    public void putUnsafe(K key, int value) {
        this.ensureCapacity();
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        this.entries[position] = new Entry<K>(key, value, hash, this.entries[position]);
        ++this.load;
    }

    public boolean remove(K key) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K> previous = null;
        Entry<K> currentStartEntry = this.entries[position];
        if (currentStartEntry != null) {
            Entry<K> entry = currentStartEntry;
            do {
                if (hash == entry.hash && entry.key.equals(key)) {
                    if (previous == null) {
                        this.entries[position] = entry.next;
                    } else {
                        previous.next = entry.next;
                    }
                    --this.load;
                    return true;
                }
                previous = entry;
            } while ((entry = entry.next) != null);
        }
        return false;
    }

    public int get(K key) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K> entry = this.entries[position];
        while (entry != null) {
            if (hash == entry.hash && key.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    public boolean contains(K key) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K> entry = this.entries[position];
        while (entry != null) {
            if (hash == entry.hash && key.equals(entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public int size() {
        return this.load;
    }

    public void clear() {
        this.entries = new Entry[this.entries.length];
        this.load = 0;
    }

    public static class Entry<K> {
        public final int hash;
        public final K key;
        public int value;
        public Entry<K> next;

        public Entry(K key, int value, int hash, Entry<K> next) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
        }
    }
}

