/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class PointerKeyedHashMap<K, V> {
    private static final int DEFAULT_INITIAL_LOG_SIZE = 5;
    private int hashMask;
    private Entry<K, V>[] data;
    private int threshold;
    private int load;

    public PointerKeyedHashMap() {
        int tableSize = 32;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
    }

    public PointerKeyedHashMap(int initialLogSize) {
        int tableSize = 1 << initialLogSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = tableSize;
        this.load = 0;
    }

    public PointerKeyedHashMap(int initialLogSize, float loadFactor) {
        int tableSize = 1 << initialLogSize;
        this.hashMask = tableSize - 1;
        this.data = new Entry[tableSize];
        this.threshold = (int)((float)tableSize * loadFactor);
        this.load = 0;
    }

    private void rehash() {
        Entry<K, V>[] oldData = this.data;
        int tableSize = this.data.length << 1;
        int newHashMask = tableSize - 1;
        Entry[] newData = new Entry[tableSize];
        Entry<Object, Object> currentEntryRoot = new Entry<Object, Object>(0, null, null, null);
        Entry<Object, Object> shiftedEntryRoot = new Entry<Object, Object>(0, null, null, null);
        int oldSize = oldData.length;
        for (int i = oldSize - 1; i >= 0; --i) {
            Entry<K, V> e = oldData[i];
            if (e == null) continue;
            Entry<Object, Object> lastCurrentEntry = currentEntryRoot;
            Entry<Object, Object> lastShiftedEntry = shiftedEntryRoot;
            int lastPosition = -1;
            do {
                int position;
                if ((position = e.hash & newHashMask) == i) {
                    if (position != lastPosition) {
                        lastCurrentEntry.next = e;
                    }
                    lastCurrentEntry = e;
                    continue;
                }
                if (position != lastPosition) {
                    lastShiftedEntry.next = e;
                }
                lastShiftedEntry = e;
            } while ((e = e.next) != null);
            lastCurrentEntry.next = null;
            lastShiftedEntry.next = null;
            newData[i] = currentEntryRoot.next;
            newData[i | oldSize] = shiftedEntryRoot.next;
        }
        this.threshold <<= 1;
        this.data = newData;
        this.hashMask = newHashMask;
    }

    private void ensureCapacity() {
        if (this.load > this.threshold) {
            this.rehash();
        }
    }

    public V store(K key, V value) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K, V> startEntry = this.data[position];
        if (startEntry != null) {
            Entry<K, V> entry = startEntry;
            do {
                if (key != entry.key) continue;
                return entry.value;
            } while ((entry = entry.next) != null);
        }
        this.ensureCapacity();
        this.data[position] = new Entry<K, V>(hash, key, value, startEntry);
        ++this.load;
        return value;
    }

    public V get(K key) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        Entry<K, V> entry = this.data[position];
        while (entry != null) {
            if (key == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public void putUnsafe(K key, V value) {
        int hash = key.hashCode();
        int position = hash & this.hashMask;
        this.ensureCapacity();
        this.data[position] = new Entry<K, V>(hash, key, value, this.data[position]);
        ++this.load;
    }

    public int size() {
        return this.load;
    }

    public void clear() {
        this.data = new Entry[this.data.length];
        this.load = 0;
    }

    private static class Entry<K, V> {
        public final int hash;
        public final K key;
        public final V value;
        public Entry<K, V> next;

        public Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

