/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.util;

public class Stack<E> {
    private static final int DEFAULT_SIZE = 8;
    private E[] data;
    private int size;

    public Stack() {
        this.data = new Object[8];
        this.size = 0;
    }

    public Stack(int initialSize) {
        this.data = new Object[initialSize];
        this.size = 0;
    }

    public void enlarge() {
        E[] oldData = this.data;
        this.data = new Object[this.size << 1];
        System.arraycopy(oldData, 0, this.data, 0, this.size);
    }

    public void push(E object) {
        while (this.size >= this.data.length) {
            this.enlarge();
        }
        this.data[this.size++] = object;
    }

    public E peek() {
        return this.data[this.size - 1];
    }

    public E pop() {
        E object = this.data[--this.size];
        this.data[this.size] = null;
        return object;
    }

    public void purge() {
        this.data[--this.size] = null;
    }

    public E get(int index) {
        return this.data[index];
    }

    public boolean contains(E object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.data[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.data = new Object[this.data.length];
        this.size = 0;
    }

    public void dirtyClear() {
        this.size = 0;
    }
}

