/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.uptr.action;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.IValue;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.control_exceptions.Filtered;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.OverloadedFunction;
import org.rascalmpl.interpreter.staticErrors.StaticError;
import org.rascalmpl.parser.gtd.result.action.IActionExecutor;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class RascalFunctionActionExecutor
implements IActionExecutor<ITree> {
    private final boolean isPure;
    private @Nullable OverloadedFunction filters;

    public RascalFunctionActionExecutor(ISet functions, boolean isPure) {
        this.isPure = isPure;
        this.filters = !functions.isEmpty() ? this.constructFilterFunction(functions) : null;
    }

    private OverloadedFunction constructFilterFunction(ISet functions) {
        List<AbstractFunction> alts = functions.stream().map(v -> (AbstractFunction)v).collect(Collectors.toList());
        return new OverloadedFunction("filters", alts);
    }

    @Override
    public void completed(Object environment, boolean filtered) {
    }

    @Override
    public Object createRootEnvironment() {
        return new Object();
    }

    @Override
    public Object enteringListNode(Object production, int index, Object environment) {
        return environment;
    }

    @Override
    public Object enteringListProduction(Object production, Object env) {
        return env;
    }

    @Override
    public Object enteringNode(Object production, int index, Object environment) {
        return environment;
    }

    @Override
    public Object enteringProduction(Object production, Object env) {
        return env;
    }

    @Override
    public void exitedListProduction(Object production, boolean filtered, Object environment) {
    }

    @Override
    public void exitedProduction(Object production, boolean filtered, Object environment) {
    }

    @Override
    public ITree filterAmbiguity(ITree ambCluster, Object environment) {
        if (!TreeAdapter.isAmb(ambCluster)) {
            return ambCluster;
        }
        if (TreeAdapter.getAlternatives(ambCluster).size() == 0) {
            return null;
        }
        if (this.filters == null) {
            return ambCluster;
        }
        try {
            ITree result = (ITree)this.filters.call(ambCluster);
            if (!TreeAdapter.isAmb(result)) {
                return result;
            }
            if (TreeAdapter.getAlternatives(result).size() == 1) {
                return (ITree)TreeAdapter.getAlternatives(result).iterator().next();
            }
            return result;
        }
        catch (MatchFailed m4) {
            return ambCluster;
        }
        catch (Throw t2) {
            IValue exc = t2.getException();
            if (exc.getType().isAbstractData() && ((IConstructor)exc).getConstructorType() == RuntimeExceptionFactory.CallFailed) {
                return ambCluster;
            }
            throw t2;
        }
        catch (Filtered f) {
            return null;
        }
    }

    @Override
    public ITree filterCycle(ITree cycle, Object environment) {
        return cycle;
    }

    @Override
    public ITree filterListAmbiguity(ITree ambCluster, Object environment) {
        return this.filterAmbiguity(ambCluster, environment);
    }

    @Override
    public ITree filterListCycle(ITree cycle, Object environment) {
        return cycle;
    }

    @Override
    public ITree filterListProduction(ITree tree, Object environment) {
        return tree;
    }

    @Override
    public ITree filterProduction(ITree tree, Object environment) {
        if (this.filters == null) {
            return tree;
        }
        try {
            ITree result = (ITree)this.filters.call(tree);
            if (!TreeAdapter.isAmb(result)) {
                return result;
            }
            if (TreeAdapter.getAlternatives(result).size() == 1) {
                return (ITree)TreeAdapter.getAlternatives(result).iterator().next();
            }
            return result;
        }
        catch (MatchFailed m4) {
            return tree;
        }
        catch (Throw t2) {
            IValue exc = t2.getException();
            if (exc.getType().isAbstractData() && ((IConstructor)exc).getConstructorType() == RuntimeExceptionFactory.CallFailed) {
                return tree;
            }
            throw t2;
        }
        catch (StaticError e) {
            throw e;
        }
        catch (Filtered f) {
            return null;
        }
    }

    @Override
    public boolean isImpure(Object rhs) {
        return !this.isPure;
    }
}

