/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.util;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IValue;
import org.rascalmpl.values.parsetrees.ProductionAdapter;

public class DebugUtil {
    private DebugUtil() {
    }

    public static String prodToString(IConstructor prod) {
        StringBuilder builder = new StringBuilder("'");
        String sortName = ProductionAdapter.getSortName(prod);
        if (sortName.equals("LAYOUT")) {
            return sortName + " -> ...";
        }
        builder.append(DebugUtil.quotedStringToPlain(sortName));
        builder.append(" ->");
        if (prod.getName().equals("prod")) {
            ProductionAdapter.getConstructorName(prod);
            IList symbols = (IList)prod.get(1);
            for (IValue symbol : symbols) {
                builder.append(" ");
                IConstructor conSymbol = (IConstructor)symbol;
                builder.append(DebugUtil.quotedStringToPlain(String.valueOf(conSymbol.get(0))));
            }
        } else if (prod.getName().equals("error")) {
            builder.append("err." + prod.get(2) + ":" + DebugUtil.prodToString((IConstructor)prod.get(1)));
        } else {
            builder.append(prod.getName() + "...");
        }
        builder.append("'");
        return builder.toString();
    }

    private static String quotedStringToPlain(String s2) {
        if (s2.isEmpty()) {
            return s2;
        }
        if (s2.equals("\"LAYOUTLIST\"") || s2.equals("LAYOUTLIST")) {
            return "L*";
        }
        if (s2.charAt(0) == '\"' && s2.charAt(s2.length() - 1) == '\"') {
            return s2.substring(1, s2.length() - 1).replace("\\", "");
        }
        return s2;
    }

    public static void opportunityToBreak() {
    }
}

