/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rascalmpl.ast.RegExpLiteral;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.RegExpPatternValue;
import org.rascalmpl.interpreter.result.IRascalResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.RedeclaredVariable;
import org.rascalmpl.interpreter.staticErrors.SyntaxError;
import org.rascalmpl.interpreter.staticErrors.UndeclaredVariable;
import org.rascalmpl.interpreter.staticErrors.UninitializedVariable;

public abstract class RegExpLiteral
extends org.rascalmpl.ast.RegExpLiteral {
    public RegExpLiteral(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class StaticInterpolationElement
    implements InterpolationElement {
        private String elem;

        public StaticInterpolationElement(String elem) {
            this.elem = this.removeRascalSpecificEscapes(elem);
        }

        @Override
        public String getString(IEvaluatorContext env) {
            return this.elem;
        }

        private String removeRascalSpecificEscapes(String s2) {
            StringBuilder b = new StringBuilder(s2.length());
            char[] chars = s2.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '\\' && i + 1 < chars.length) {
                    switch (chars[++i]) {
                        case '>': {
                            b.append('>');
                            break;
                        }
                        case '<': {
                            b.append('<');
                            break;
                        }
                        default: {
                            b.append('\\');
                            b.append(chars[i]);
                            break;
                        }
                    }
                    continue;
                }
                b.append(chars[i]);
            }
            return b.toString();
        }

        public String toString() {
            return this.elem;
        }
    }

    public static class NamedInterpolationElement
    implements InterpolationElement {
        private final String name;

        public NamedInterpolationElement(String name) {
            this.name = name;
        }

        private String escape(IValue val) {
            String name = val.getType().isString() ? ((IString)val).getValue() : val.toString();
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if ("^.|?*+()[\\".indexOf(ch) != -1) {
                    b.append('\\');
                }
                b.append(ch);
            }
            return b.toString();
        }

        @Override
        public String getString(IEvaluatorContext env) {
            IRascalResult variable = env.getCurrentEnvt().getFrameVariable(this.name);
            if (variable == null) {
                throw new UndeclaredVariable(this.name, env.getCurrentAST());
            }
            Object value = ((Result)variable).getValue();
            if (value == null) {
                throw new UninitializedVariable(this.name, env.getCurrentAST());
            }
            return this.escape((IValue)value);
        }

        public String toString() {
            return "(?" + this.name + ")";
        }
    }

    public static interface InterpolationElement {
        public String getString(IEvaluatorContext var1);
    }

    public static class Lexical
    extends RegExpLiteral.Lexical {
        public Lexical(ISourceLocation __param1, IConstructor tree, String __param2) {
            super(__param1, tree, __param2);
        }

        private void interpolate(String re, List<InterpolationElement> elems, List<String> vars) {
            Pattern replacePat = Pattern.compile("(?<!\\\\)<([a-zA-Z0-9]+)>");
            Matcher m4 = replacePat.matcher(re);
            int start = 0;
            while (m4.find()) {
                elems.add(new StaticInterpolationElement(this.addGroups(re.substring(start, m4.start(0)), vars)));
                elems.add(new NamedInterpolationElement(m4.group(1)));
                start = m4.end(0);
            }
            elems.add(new StaticInterpolationElement(re.substring(start, re.length())));
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            int end;
            String subjectPat = this.getString();
            LinkedList<InterpolationElement> resultRegExp = new LinkedList<InterpolationElement>();
            if (subjectPat.charAt(0) != '/') {
                throw new SyntaxError("Malformed Regular expression: " + subjectPat, this.getLocation());
            }
            int start = 1;
            for (end = subjectPat.length() - 1; end > 0 && subjectPat.charAt(end) != '/'; --end) {
            }
            String modifiers = subjectPat.substring(end + 1);
            if (subjectPat.charAt(end) != '/') {
                throw new SyntaxError("Regular expression does not end with /", this.getLocation());
            }
            if (modifiers.length() > 0) {
                resultRegExp.add(new StaticInterpolationElement("(?" + modifiers + ")"));
            }
            String Name2 = "[a-zA-Z0-9]+";
            String NR1 = "[^\\\\<>]";
            String NR2 = "(?:\\\\[\\\\<>])";
            String NR3 = "(?:\\\\)";
            String NR4 = "(?:<" + Name2 + ">)";
            String NamedRegexp = "(?:" + NR1 + "|" + NR2 + "|" + NR3 + "|" + NR4 + ")";
            String RE = "(?:(?<!\\\\)|(?<=\\\\\\\\))<(" + Name2 + ")(?:\\s*:\\s*(" + NamedRegexp + "*))?>";
            Pattern replacePat = Pattern.compile(RE);
            Matcher m4 = replacePat.matcher(subjectPat);
            ArrayList<String> patternVars = new ArrayList<String>();
            while (m4.find()) {
                String varName = m4.group(1);
                resultRegExp.add(new StaticInterpolationElement(this.addGroups(subjectPat.substring(start, m4.start(0)), patternVars)));
                if (m4.end(2) > -1) {
                    if (patternVars.contains(varName)) {
                        throw new RedeclaredVariable(varName, this);
                    }
                    patternVars.add(varName);
                    resultRegExp.add(new StaticInterpolationElement("("));
                    this.interpolate(m4.group(2), resultRegExp, patternVars);
                    resultRegExp.add(new StaticInterpolationElement(")"));
                } else {
                    int varIndex = patternVars.indexOf(varName);
                    if (varIndex >= 0) {
                        resultRegExp.add(new StaticInterpolationElement("(?:\\" + (1 + varIndex) + ")"));
                    } else {
                        resultRegExp.add(new NamedInterpolationElement(varName));
                    }
                }
                start = m4.end(0);
            }
            resultRegExp.add(new StaticInterpolationElement(this.addGroups(subjectPat.substring(start, end), patternVars)));
            return new RegExpPatternValue(eval, this, resultRegExp, patternVars);
        }

        private String addGroups(String s2, List<String> patternVars) {
            int i = -1;
            while ((i = s2.indexOf("(", i + 1)) != -1) {
                if (i == 0) {
                    if (s2.length() != 1 && s2.charAt(i + 1) == '?') continue;
                    patternVars.add("_" + i);
                    continue;
                }
                if (i == s2.length() - 1) {
                    if (s2.charAt(i - 1) == '\\') continue;
                    patternVars.add("_" + i);
                    continue;
                }
                if (s2.charAt(i - 1) == '\\' || s2.charAt(i + 1) == '?') continue;
                patternVars.add("_" + i);
            }
            return s2;
        }
    }
}

