/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.List;
import org.rascalmpl.ast.Case;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.Strategy;
import org.rascalmpl.ast.Visit;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.TraversalEvaluator;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.utils.Cases;

public abstract class Visit
extends org.rascalmpl.ast.Visit {
    public Visit(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class GivenStrategy
    extends Visit.GivenStrategy {
        private final TraversalEvaluator.CaseBlockList blocks = new TraversalEvaluator.CaseBlockList(Cases.precompute(this.getCases(), true));

        public GivenStrategy(ISourceLocation __param1, IConstructor tree, Strategy __param2, Expression __param3, List<Case> __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> subject = this.getSubject().interpret(__eval);
            Type subjectType = subject.getStaticType();
            if (subjectType.isConstructor()) {
                subjectType = subjectType.getAbstractDataType();
            }
            Strategy s2 = this.getStrategy();
            TraversalEvaluator.DIRECTION direction = TraversalEvaluator.DIRECTION.BottomUp;
            TraversalEvaluator.PROGRESS progress = TraversalEvaluator.PROGRESS.Continuing;
            TraversalEvaluator.FIXEDPOINT fixedpoint = TraversalEvaluator.FIXEDPOINT.No;
            if (s2.isBottomUp()) {
                direction = TraversalEvaluator.DIRECTION.BottomUp;
            } else if (s2.isBottomUpBreak()) {
                direction = TraversalEvaluator.DIRECTION.BottomUp;
                progress = TraversalEvaluator.PROGRESS.Breaking;
            } else if (s2.isInnermost()) {
                direction = TraversalEvaluator.DIRECTION.BottomUp;
                fixedpoint = TraversalEvaluator.FIXEDPOINT.Yes;
            } else if (s2.isTopDown()) {
                direction = TraversalEvaluator.DIRECTION.TopDown;
            } else if (s2.isTopDownBreak()) {
                direction = TraversalEvaluator.DIRECTION.TopDown;
                progress = TraversalEvaluator.PROGRESS.Breaking;
            } else if (s2.isOutermost()) {
                direction = TraversalEvaluator.DIRECTION.TopDown;
                fixedpoint = TraversalEvaluator.FIXEDPOINT.Yes;
            } else {
                throw new ImplementationError("Unknown strategy " + s2);
            }
            TraversalEvaluator te = new TraversalEvaluator(__eval);
            try {
                __eval.__pushTraversalEvaluator(te);
                IValue val = te.traverse(subject.getValue(), this.blocks, direction, progress, fixedpoint);
                Type t2 = val.getType();
                Result<IValue> result = ResultFactory.makeResult(t2, val, __eval);
                return result;
            }
            catch (UnexpectedType e) {
                e.setLocation(this.getLocation());
                throw e;
            }
            finally {
                __eval.__popTraversalEvaluator();
            }
        }
    }

    public static class DefaultStrategy
    extends Visit.DefaultStrategy {
        private final TraversalEvaluator.CaseBlockList blocks = new TraversalEvaluator.CaseBlockList(Cases.precompute(this.getCases(), true));

        public DefaultStrategy(ISourceLocation __param1, IConstructor tree, Expression __param2, List<Case> __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> subject = this.getSubject().interpret(__eval);
            TraversalEvaluator te = new TraversalEvaluator(__eval);
            try {
                __eval.__pushTraversalEvaluator(te);
                IValue val = te.traverse(subject.getValue(), this.blocks, TraversalEvaluator.DIRECTION.BottomUp, TraversalEvaluator.PROGRESS.Continuing, TraversalEvaluator.FIXEDPOINT.No);
                if (!val.getType().isSubtypeOf(subject.getStaticType())) {
                    throw new ImplementationError("this should really never happen", new UnexpectedType(subject.getStaticType(), val.getType(), this));
                }
                Result<IValue> result = ResultFactory.makeResult(subject.getStaticType(), val, __eval);
                return result;
            }
            catch (UnexpectedType e) {
                e.setLocation(this.getLocation());
                throw e;
            }
            finally {
                __eval.__popTraversalEvaluator();
            }
        }
    }
}

