/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.test.infrastructure;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.ITestResultListener;
import org.rascalmpl.interpreter.TestEvaluator;
import org.rascalmpl.interpreter.env.GlobalEnvironment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.load.StandardLibraryContributor;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.library.Messages;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.test.infrastructure.CompilationFailed;
import org.rascalmpl.test.infrastructure.RascalJUnitTestPrefix;
import org.rascalmpl.test.infrastructure.RascalJunitConsoleMonitor;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.SourceLocationClassLoader;
import org.rascalmpl.uri.file.MavenRepositoryURIResolver;
import org.rascalmpl.uri.project.ProjectURIResolver;
import org.rascalmpl.uri.project.TargetURIResolver;
import org.rascalmpl.values.ValueFactoryFactory;

public class RascalJUnitTestRunner
extends Runner {
    private static Evaluator evaluator;
    private static GlobalEnvironment heap;
    private static ModuleEnvironment root;
    private Description desc;
    private final String prefix;
    private final ISourceLocation projectRoot;
    private final Class<?> clazz;

    public RascalJUnitTestRunner(Class<?> clazz) {
        this.prefix = clazz.getAnnotation(RascalJUnitTestPrefix.class).value();
        this.projectRoot = RascalJUnitTestRunner.inferProjectRoot(clazz);
        this.clazz = clazz;
        System.err.println("Rascal JUnit test runner uses Rascal version " + RascalManifest.getRascalVersionNumber());
        System.err.println("Rascal JUnit project root: " + this.projectRoot);
        if (this.projectRoot == null) {
            throw new IllegalArgumentException("could not setup tests for " + clazz.getCanonicalName());
        }
        RascalJUnitTestRunner.configureProjectEvaluator(evaluator, this.projectRoot);
    }

    public static void configureProjectEvaluator(Evaluator evaluator, ISourceLocation projectRoot) {
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        String projectName = new RascalManifest().getProjectName(projectRoot);
        reg.registerLogical(new ProjectURIResolver(projectRoot, projectName));
        reg.registerLogical(new TargetURIResolver(projectRoot, projectName));
        try {
            PathConfig pcfg = PathConfig.fromSourceProjectRascalManifest(projectRoot, PathConfig.RascalConfigMode.INTERPRETER, true);
            System.err.println("Source path:");
            for (IValue path : pcfg.getSrcs()) {
                ISourceLocation locPath = MavenRepositoryURIResolver.mavenize((ISourceLocation)path);
                evaluator.addRascalSearchPath(locPath);
                System.err.println("- " + locPath);
            }
            System.err.println("Class loader path:");
            for (IValue p : pcfg.getLibsAndTarget()) {
                System.err.println("- " + p);
            }
            SourceLocationClassLoader cl = new SourceLocationClassLoader(pcfg.getLibsAndTarget(), ShellEvaluatorFactory.class.getClassLoader());
            evaluator.addClassLoader(cl);
            if (pcfg.getMessages().length() > 0) {
                System.err.println("Messages:");
                Messages.write(pcfg.getMessages(), pcfg.getSrcs(), new PrintWriter(System.err, true));
            }
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
            throw e;
        }
    }

    public static ISourceLocation inferProjectRoot(Class<?> clazz) {
        try {
            String file = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (file.endsWith(".jar")) {
                throw new IllegalArgumentException("can not run Rascal JUnit tests from within a jar file");
            }
            File current = new File(file);
            while (current != null && current.exists() && current.isDirectory()) {
                if (new File(current, "META-INF/RASCAL.MF").exists()) {
                    if (current.getName().equals("classes") && current.getParentFile().getName().equals("target")) {
                        current = current.getParentFile().getParentFile();
                        continue;
                    }
                    return URIUtil.createFileLocation(current.getAbsolutePath());
                }
                current = current.getParentFile();
            }
        }
        catch (URISyntaxException e) {
            System.err.println("[ERROR] can not infer project root:" + e);
            return null;
        }
        return null;
    }

    public static String computeTestName(String name, ISourceLocation loc) {
        return name + ": <" + loc.getOffset() + "," + loc.getLength() + ">";
    }

    public static List<String> getRecursiveModuleList(ISourceLocation root, List<String> result) throws IOException {
        LinkedList<ISourceLocation> todo = new LinkedList<ISourceLocation>();
        todo.add(root);
        while (!todo.isEmpty()) {
            ISourceLocation currentDir = (ISourceLocation)todo.poll();
            if (!URIResolverRegistry.getInstance().exists(currentDir)) continue;
            String prefix = currentDir.getPath().replaceFirst(root.getPath(), "").replaceFirst("/", "").replaceAll("/", "::");
            for (ISourceLocation ent : URIResolverRegistry.getInstance().list(currentDir)) {
                if (ent.getPath().endsWith(".rsc")) {
                    if (prefix.isEmpty()) {
                        result.add(URIUtil.getLocationName(ent).replace(".rsc", ""));
                        continue;
                    }
                    result.add(prefix + "::" + URIUtil.getLocationName(ent).replace(".rsc", ""));
                    continue;
                }
                if (!URIResolverRegistry.getInstance().isDirectory(ent)) continue;
                todo.add(ent);
            }
        }
        return result;
    }

    @Override
    public Description getDescription() {
        Description desc;
        this.desc = desc = Description.createSuiteDescription(this.prefix, new Annotation[0]);
        evaluator.job("loading modules", 1, jobName -> {
            try {
                ArrayList<String> modules = new ArrayList<String>(10);
                evaluator.jobTodo((String)jobName, modules.size());
                for (String src : new RascalManifest().getSourceRoots(this.projectRoot)) {
                    RascalJUnitTestRunner.getRecursiveModuleList(URIUtil.getChildLocation(this.projectRoot, src + "/" + this.prefix.replaceAll("::", "/")), modules);
                }
                Collections.shuffle(modules);
                for (String module : modules) {
                    String name = this.prefix + "::" + module;
                    Description modDesc = Description.createSuiteDescription(name, new Annotation[0]);
                    try {
                        evaluator.doNextImport((String)jobName, name);
                        List<AbstractFunction> tests = heap.getModule(name.replaceAll("\\\\", "")).getTests();
                        if (tests.isEmpty()) continue;
                        desc.addChild(modDesc);
                        for (AbstractFunction f : tests) {
                            modDesc.addChild(Description.createTestDescription(this.clazz, RascalJUnitTestRunner.computeTestName(f.getName(), f.getAst().getLocation())));
                        }
                    }
                    catch (Throwable e) {
                        desc.addChild(modDesc);
                        Description testDesc = Description.createTestDescription(this.clazz, name + " compilation failed", new CompilationFailed(){

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return this.getClass();
                            }
                        });
                        modDesc.addChild(testDesc);
                    }
                }
                return true;
            }
            catch (IOException e) {
                Description testDesc = Description.createTestDescription(this.clazz, this.prefix + " compilation failed: " + e.getMessage(), new CompilationFailed(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return this.getClass();
                    }
                });
                desc.addChild(testDesc);
                evaluator.warning("Could not create tests suite: " + e, URIUtil.rootLocation("unknown"));
                return false;
            }
        });
        return desc;
    }

    @Override
    public void run(RunNotifier notifier) {
        if (this.desc == null) {
            this.desc = this.getDescription();
        }
        notifier.fireTestRunStarted(this.desc);
        for (Description mod : this.desc.getChildren()) {
            if (mod.getAnnotations().stream().anyMatch(t2 -> t2 instanceof CompilationFailed)) {
                notifier.fireTestFailure(new Failure(this.desc, new IllegalArgumentException(mod.getDisplayName() + " had importing errors")));
                break;
            }
            Listener listener = new Listener(notifier, mod);
            TestEvaluator runner = new TestEvaluator(evaluator, listener);
            runner.test(mod.getDisplayName());
        }
        notifier.fireTestRunFinished(new Result());
    }

    static {
        try {
            heap = new GlobalEnvironment();
            root = heap.addModule(new ModuleEnvironment("___junit_test___", heap));
            evaluator = new Evaluator(ValueFactoryFactory.getValueFactory(), Reader.nullReader(), new PrintWriter(System.err, true), new PrintWriter(System.out, false), root, heap, RascalJunitConsoleMonitor.getInstance());
            evaluator.addRascalSearchPathContributor(StandardLibraryContributor.getInstance());
            evaluator.getConfiguration().setErrors(true);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
            throw e;
        }
    }

    private final class Listener
    implements ITestResultListener {
        private final RunNotifier notifier;
        private final Description module;

        private Listener(RunNotifier notifier, Description module) {
            this.notifier = notifier;
            this.module = module;
        }

        private Description getDescription(String name, ISourceLocation loc) {
            String testName = RascalJUnitTestRunner.computeTestName(name, loc);
            for (Description child : this.module.getChildren()) {
                if (!child.getMethodName().equals(testName)) continue;
                return child;
            }
            throw new IllegalArgumentException(name + " test was never registered");
        }

        @Override
        public void start(String context, int count) {
            this.notifier.fireTestRunStarted(this.module);
        }

        @Override
        public void ignored(String test, ISourceLocation loc) {
            this.notifier.fireTestIgnored(this.getDescription(test, loc));
        }

        @Override
        public void report(boolean successful, String test, ISourceLocation loc, String message, Throwable t2) {
            Description desc = this.getDescription(test, loc);
            this.notifier.fireTestStarted(desc);
            if (!successful) {
                this.notifier.fireTestFailure(new Failure(desc, t2 != null ? t2 : new Exception(message != null ? message : "no message")));
            } else {
                this.notifier.fireTestFinished(desc);
            }
        }

        @Override
        public void done() {
            this.notifier.fireTestRunFinished(new Result());
        }
    }
}

