/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.tutor.lang.rascal.tutor.repl;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.io.StandardTextWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.utils.RascalManifest;
import org.rascalmpl.interpreter.utils.ReadEvalPrintDialogMessages;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.repl.StopREPLException;
import org.rascalmpl.repl.output.IBinaryOutputPrinter;
import org.rascalmpl.repl.output.ICommandOutput;
import org.rascalmpl.repl.output.IErrorCommandOutput;
import org.rascalmpl.repl.output.IImageCommandOutput;
import org.rascalmpl.repl.output.IWebContentOutput;
import org.rascalmpl.repl.rascal.RascalInterpreterREPL;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.tutor.lang.rascal.tutor.repl.ITutorScreenshotFeature;
import org.rascalmpl.tutor.lang.rascal.tutor.repl.TutorIDEServices;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.SourceLocationClassLoader;
import org.rascalmpl.uri.project.ProjectURIResolver;
import org.rascalmpl.uri.project.TargetURIResolver;

public class TutorCommandExecutor {
    private final RascalInterpreterREPL interpreter;
    private final StringWriter outWriter = new StringWriter();
    private final PrintWriter outPrinter = new PrintWriter(this.outWriter);
    private final StringWriter errWriter = new StringWriter();
    private final PrintWriter errPrinter = new PrintWriter((Writer)this.errWriter, true);
    private final ITutorScreenshotFeature screenshot;
    private String currentInput = "";

    public TutorCommandExecutor(final PathConfig pcfg) throws IOException, URISyntaxException {
        this.interpreter = new RascalInterpreterREPL(){

            @Override
            protected Evaluator buildEvaluator(Reader input, PrintWriter stdout, PrintWriter stderr, IDEServices services) {
                Evaluator eval = super.buildEvaluator(input, stdout, stderr, services);
                if (!pcfg.getSrcs().isEmpty()) {
                    ISourceLocation projectRoot = TutorCommandExecutor.inferProjectRoot((ISourceLocation)pcfg.getSrcs().get(0));
                    String projectName = new RascalManifest().getProjectName(projectRoot);
                    URIResolverRegistry reg = URIResolverRegistry.getInstance();
                    reg.registerLogical(new ProjectURIResolver(projectRoot, projectName));
                    reg.registerLogical(new TargetURIResolver(projectRoot, projectName));
                    for (IValue path : pcfg.getSrcs()) {
                        eval.addRascalSearchPath((ISourceLocation)path);
                    }
                    for (IValue path : pcfg.getLibs()) {
                        eval.addRascalSearchPath((ISourceLocation)path);
                    }
                    SourceLocationClassLoader cl = new SourceLocationClassLoader(pcfg.getLibsAndTarget(), ShellEvaluatorFactory.class.getClassLoader());
                    eval.addClassLoader(cl);
                } else {
                    services.warning("No src path configured for tutor", URIUtil.rootLocation("unknown"));
                }
                return eval;
            }

            @Override
            protected IDEServices buildIDEService(PrintWriter err, IRascalMonitor monitor, Terminal term) {
                return monitor instanceof IDEServices ? (IDEServices)monitor : new TutorIDEServices(err);
            }
        };
        Terminal terminal = TerminalBuilder.builder().system(false).streams(InputStream.nullInputStream(), OutputStream.nullOutputStream()).dumb(true).color(false).encoding(StandardCharsets.UTF_8).build();
        this.interpreter.initialize(Reader.nullReader(), this.outPrinter, this.errPrinter, new TutorIDEServices(this.errPrinter), terminal);
        this.screenshot = this.loadScreenShotter();
    }

    private ITutorScreenshotFeature loadScreenShotter() {
        try {
            return (ITutorScreenshotFeature)this.getClass().getClassLoader().loadClass("org.rascalmpl.tutor.Screenshotter").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new Error("WARNING: Could not load screenshot feature from org.rascalmpl.tutor.Screenshotter", e);
        }
    }

    private static ISourceLocation inferProjectRoot(ISourceLocation member) {
        ISourceLocation current = member;
        URIResolverRegistry reg = URIResolverRegistry.getInstance();
        while (current != null && reg.exists(current) && reg.isDirectory(current)) {
            if (reg.exists(URIUtil.getChildLocation(current, "META-INF/RASCAL.MF"))) {
                return current;
            }
            if (URIUtil.getParentLocation(current).equals(current)) {
                return reg.isDirectory(member) ? member : URIUtil.getParentLocation(member);
            }
            current = URIUtil.getParentLocation(current);
        }
        return current;
    }

    public void reset() {
        this.interpreter.cancelRunningCommandRequested();
        this.interpreter.cleanEnvironment();
        this.outPrinter.flush();
        this.outWriter.getBuffer().setLength(0);
        this.errPrinter.flush();
        this.errWriter.getBuffer().setLength(0);
        this.currentInput = "";
    }

    private String collectFullCommand(String line) {
        this.currentInput = !this.currentInput.isEmpty() ? this.currentInput + "\n" + line : line;
        return this.currentInput;
    }

    private boolean isValidCommand(String cmd) {
        try {
            return this.interpreter.parseCommand(cmd) != null;
        }
        catch (ParseError pe) {
            return false;
        }
    }

    public String prompt() {
        if (this.currentInput.isEmpty()) {
            return "rascal>";
        }
        long lines = this.currentInput.codePoints().filter(ch -> ch == 10).count() + 1L;
        return String.format("|%d %s", lines, ">".repeat(lines > 10L ? 3 : 4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<String, String> eval(String line) throws InterruptedException, IOException {
        HashMap<String, String> result;
        block20: {
            String input = this.collectFullCommand(line);
            if (!this.isValidCommand(input) && !line.isBlank()) {
                return Collections.emptyMap();
            }
            result = new HashMap<String, String>();
            try {
                ICommandOutput replResult = this.interpreter.handleInput(input);
                if (replResult instanceof IErrorCommandOutput) {
                    ((IErrorCommandOutput)replResult).asPlain().write(this.errPrinter, true);
                } else if (replResult instanceof IImageCommandOutput) {
                    IBinaryOutputPrinter img = ((IImageCommandOutput)replResult).asImage();
                    result.put(img.mimeType(), this.uuencode(img));
                } else if (replResult instanceof IWebContentOutput && this.screenshot != null) {
                    IWebContentOutput webResult = (IWebContentOutput)replResult;
                    try {
                        String pngImage = this.screenshot.takeScreenshotAsBase64PNG(webResult.webUri().toASCIIString());
                        if (!pngImage.isEmpty()) {
                            result.put("application/rascal+screenshot", pngImage);
                        }
                    }
                    catch (Throwable e) {
                        this.errPrinter.write(e.getMessage());
                    }
                } else if (replResult != null) {
                    StringWriter txt = new StringWriter();
                    PrintWriter txtPrinter = new PrintWriter((Writer)txt, false);
                    replResult.asPlain().write(txtPrinter, true);
                    txtPrinter.flush();
                    result.put("text/plain", txt.toString());
                } else {
                    result.put("text/plain", "ok\n");
                }
                this.currentInput = "";
            }
            catch (ParseError pe) {
                ReadEvalPrintDialogMessages.parseErrorMessage(this.errPrinter, line, this.interpreter.promptRootLocation().getScheme(), pe, new StandardTextWriter(true));
                this.currentInput = "";
                result.put("application/rascal+stdout", this.getPrintedOutput());
                result.put("application/rascal+stderr", this.getErrorOutput());
                break block20;
            }
            catch (StopREPLException e1) {
                this.errWriter.write("Quiting REPL");
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.currentInput = "";
                result.put("application/rascal+stdout", this.getPrintedOutput());
                result.put("application/rascal+stderr", this.getErrorOutput());
            }
            result.put("application/rascal+stdout", this.getPrintedOutput());
            result.put("application/rascal+stderr", this.getErrorOutput());
        }
        return result;
    }

    private String uuencode(IBinaryOutputPrinter content) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (OutputStream wrapped = Base64.getEncoder().wrap(result);){
            content.write(wrapped);
        }
        return result.toString(StandardCharsets.ISO_8859_1);
    }

    private String getPrintedOutput() {
        this.outPrinter.flush();
        String result = this.outWriter.toString();
        this.outWriter.getBuffer().setLength(0);
        return result;
    }

    private String getErrorOutput() {
        this.errPrinter.flush();
        String result = this.errWriter.toString();
        this.errWriter.getBuffer().setLength(0);
        return result;
    }
}

