/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.types;

import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.HashSet;
import java.util.Set;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.types.DefaultRascalTypeVisitor;
import org.rascalmpl.types.RascalType;

public class TypeReachability {
    public static boolean mayOccurIn(Type small, Type large, Environment env) {
        return TypeReachability.mayOccurIn(small, large, new HashSet<Type>(), env);
    }

    private static boolean mayOccurIn(final Type small, final Type large, final Set<Type> seen, final Environment env) {
        if (small.isBottom() && !large.isBottom()) {
            return false;
        }
        if (small.comparable(large)) {
            return true;
        }
        return large.accept(new DefaultRascalTypeVisitor<Boolean, RuntimeException>(Boolean.valueOf(false)){

            @Override
            public Boolean visitList(Type type) {
                return TypeReachability.mayOccurIn(small, large.getElementType(), seen, env);
            }

            @Override
            public Boolean visitSet(Type type) {
                return TypeReachability.mayOccurIn(small, large.getElementType(), seen, env);
            }

            @Override
            public Boolean visitMap(Type type) {
                return TypeReachability.mayOccurIn(small, large.getKeyType(), seen, env) || TypeReachability.mayOccurIn(small, large.getValueType(), seen, env);
            }

            @Override
            public Boolean visitTuple(Type type) {
                for (int i = 0; i < large.getArity(); ++i) {
                    if (!TypeReachability.mayOccurIn(small, large.getFieldType(i), seen, env)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitFunction(Type type) {
                return false;
            }

            @Override
            public Boolean visitReified(RascalType type) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitNonTerminal(RascalType type) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitConstructor(Type type) {
                for (int i = 0; i < type.getArity(); ++i) {
                    if (!TypeReachability.mayOccurIn(small, type.getFieldType(i), seen, env)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean visitAbstractData(Type type) {
                if (small.equivalent(TypeFactory.getInstance().nodeType())) {
                    return true;
                }
                seen.add(large);
                for (Type alt : env.lookupAlternatives(large)) {
                    for (int i = 0; i < alt.getArity(); ++i) {
                        Type fType = alt.getFieldType(i);
                        if (!seen.add(fType) || !TypeReachability.mayOccurIn(small, fType, seen, env)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

