/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.unicode;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class UnicodeOffsetLengthReader
extends FilterReader {
    private int charsRead;
    private int offset;
    private int length;

    public UnicodeOffsetLengthReader(Reader in, int offset, int len) {
        super(in);
        this.offset = offset;
        this.length = len;
    }

    private void offset() throws IOException {
        if (this.offset > 0) {
            char[] buf = new char[8096];
            while (this.offset > 0) {
                int res = this.in.read(buf, 0, Math.min(this.offset, buf.length));
                if (res == -1) {
                    this.offset = 0;
                    return;
                }
                this.offset -= res;
                for (int i = 0; i < res; ++i) {
                    if (!Character.isHighSurrogate(buf[i])) continue;
                    ++this.offset;
                }
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.offset();
        if (this.length != -1 && this.charsRead >= this.length) {
            return -1;
        }
        int res = super.read();
        if (res != -1 && !Character.isHighSurrogate((char)res)) {
            ++this.charsRead;
        }
        return res;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.offset();
        if (this.length != -1 && this.charsRead >= this.length) {
            return -1;
        }
        int res = super.read(cbuf, off, len);
        if (res == 0) {
            return res;
        }
        if (res != -1) {
            int count = 0;
            for (int i = 0; i < res; ++i) {
                ++count;
                if (Character.isHighSurrogate(cbuf[i])) continue;
                ++this.charsRead;
                if (this.length == -1 || this.charsRead < this.length) continue;
                return count;
            }
            return count;
        }
        return res;
    }
}

