/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.jar;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.usethesource.vallang.ISourceLocation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.rascalmpl.uri.FileTree;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.jar.JarFileTree;

public class JarFileResolver {
    protected final Cache<ISourceLocation, FileTree> fsCache = Caffeine.newBuilder().weigher((e, v) -> (int)(v.totalSize() / 1024L)).maximumWeight(Runtime.getRuntime().maxMemory() / 100L / 1024L).expireAfterAccess(10L, TimeUnit.MINUTES).softValues().build();

    protected FileTree getFileHierchyCache(ISourceLocation jar) {
        try {
            File jarFile = new File(jar.getPath());
            return this.fsCache.get(URIUtil.changeQuery(jar, "mod=" + jarFile.lastModified()), j -> new JarFileTree(jarFile));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream(ISourceLocation jar, String path) throws IOException {
        JarFile jarFile = new JarFile(jar.getPath());
        JarEntry jarEntry = jarFile.getJarEntry(path);
        if (jarEntry == null) {
            throw new FileNotFoundException(path + " inside " + jar);
        }
        return jarFile.getInputStream(jarEntry);
    }

    public boolean exists(ISourceLocation jar, String path) {
        if (path == null || path.isEmpty() || path.equals("/")) {
            return true;
        }
        return this.getFileHierchyCache(jar).exists(path);
    }

    public boolean isDirectory(ISourceLocation jar, String path) {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return this.getFileHierchyCache(jar).isDirectory((String)path);
    }

    public boolean isFile(ISourceLocation jar, String path) {
        return this.getFileHierchyCache(jar).isFile(path);
    }

    public long lastModified(ISourceLocation jar, String path) throws IOException {
        return this.getFileHierchyCache(jar).getLastModified(path);
    }

    public String[] list(ISourceLocation jar, String path) throws IOException {
        if (!((String)path).endsWith("/") && !((String)path).isEmpty()) {
            path = (String)path + "/";
        }
        return this.getFileHierchyCache(jar).directChildren((String)path);
    }
}

