/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rascalmpl.uri.FileTree;

public class ZipInputStreamFileTree
extends FileTree {
    public ZipInputStreamFileTree(InputStream in) {
        this.totalSize = 0L;
        try (ZipInputStream stream = new ZipInputStream(in);){
            ZipEntry next = null;
            int pos = 0;
            while ((next = stream.getNextEntry()) != null) {
                if (!next.isDirectory()) {
                    String name = next.getName();
                    this.totalSize += (long)(16 + name.length() * 2);
                    this.fs.put(name, new IndexFSEntry(next.getTime(), pos++));
                    continue;
                }
                ++pos;
            }
        }
        catch (IOException e) {
            this.throwMe = e;
            this.fs.clear();
        }
    }

    public int getPosition(String path) {
        IndexFSEntry ent = (IndexFSEntry)this.fs.get(path);
        if (ent == null) {
            return -1;
        }
        return ent.position;
    }

    private static class IndexFSEntry
    extends FileTree.FSEntry {
        public int position;

        public IndexFSEntry(long lastModified, int position) {
            super(lastModified);
            this.position = position;
        }
    }
}

