/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.settings.Mirror;
import org.rascalmpl.util.maven.ArtifactCoordinate;
import org.rascalmpl.util.maven.MirrorRepo;
import org.rascalmpl.util.maven.Repo;
import org.rascalmpl.util.maven.SimpleRepositoryDownloader;

class SimpleResolver
implements ModelResolver {
    private final List<SimpleRepositoryDownloader> availableRepostories = new ArrayList<SimpleRepositoryDownloader>();
    private final Path rootRepository;
    private final ModelBuilder builder;
    private final HttpClient client;
    private final Map<String, Mirror> mirrors;

    public SimpleResolver(Path rootRepository, ModelBuilder builder, HttpClient client, Map<String, Mirror> mirrors) {
        this.rootRepository = rootRepository;
        this.builder = builder;
        this.client = client;
        this.mirrors = new HashMap<String, Mirror>(mirrors);
    }

    public Path calculatePomPath(ArtifactCoordinate coordinate) {
        return this.calculatePomPath(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion());
    }

    public Path calculatePomPath(String groupId, String artifactId, String version) {
        Path result = this.rootRepository;
        for (String path : groupId.split("\\.")) {
            result = result.resolve(path);
        }
        result = result.resolve(artifactId);
        result = result.resolve(version);
        return result.resolve(String.format("%s-%s.pom", artifactId, version));
    }

    private Path calculateJarPath(ArtifactCoordinate coordinate) {
        return this.calculateJarPath(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion(), coordinate.getClassifier());
    }

    private Path calculateJarPath(String groupId, String artifactId, String version, String classifier) {
        Path pomLocation = this.calculatePomPath(groupId, artifactId, version);
        String fileName = artifactId + "-" + version;
        if (!classifier.isEmpty()) {
            fileName = fileName + "-" + classifier;
        }
        return pomLocation.resolveSibling(fileName + ".jar");
    }

    @Override
    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Path local = this.calculatePomPath(groupId, artifactId, version);
        if (!Files.exists(local, new LinkOption[0])) {
            this.downloadPom(local, groupId, artifactId, version);
        }
        return new FileModelSource(local.toFile());
    }

    @Override
    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    @Override
    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    public ModelSource resolveModel(ArtifactCoordinate coordinate) throws UnresolvableModelException {
        return this.resolveModel(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion());
    }

    @Override
    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    @Override
    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        Mirror mirror;
        if (replace) {
            this.availableRepostories.removeIf(r -> r.repo.getId().equals(repository.getId()));
        }
        Repo repo = (mirror = this.mirrors.get(repository.getId())) == null ? new Repo(repository) : new MirrorRepo(mirror, repository);
        this.availableRepostories.add(new SimpleRepositoryDownloader(repo, this.client));
    }

    @Override
    public ModelResolver newCopy() {
        SimpleResolver result = new SimpleResolver(this.rootRepository, this.builder, this.client, this.mirrors);
        result.availableRepostories.addAll(this.availableRepostories);
        return result;
    }

    private void downloadPom(Path local, String groupId, String artifactId, String version) throws UnresolvableModelException {
        if (version.endsWith("-SNAPSHOT")) {
            throw new UnresolvableModelException("No downloading & updating logic of SNAPSHOTs yet", groupId, artifactId, version);
        }
        this.downloadArtifact(local, groupId, artifactId, version, false);
    }

    private void downloadJar(Path local, String groupId, String artifactId, String version) throws UnresolvableModelException {
        if (version.endsWith("-SNAPSHOT")) {
            throw new UnresolvableModelException("No downloading & updating logic of SNAPSHOTs yet", groupId, artifactId, version);
        }
        this.downloadArtifact(local, groupId, artifactId, version, false);
    }

    private void downloadArtifact(Path local, String groupId, String artifactId, String version, boolean force) throws UnresolvableModelException {
        String url = this.getUrl(local, groupId, artifactId, version);
        for (SimpleRepositoryDownloader repoDownloader : this.availableRepostories) {
            if (repoDownloader.getRepo().getLayout().equals("legacy") || !repoDownloader.download(url, local, force)) continue;
            return;
        }
        throw new UnresolvableModelException("Could not download artifact from available repositories", groupId, artifactId, version);
    }

    private String getUrl(Path local, String groupId, String artifactId, String version) {
        return String.format("/%s/%s/%s/%s", groupId.replace('.', '/'), artifactId, version, local.getFileName().toString());
    }

    public Path resolveJar(ArtifactCoordinate coordinate) throws UnresolvableModelException {
        Path jarPath = this.calculateJarPath(coordinate);
        if (Files.notExists(jarPath, new LinkOption[0])) {
            this.downloadJar(jarPath, coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion());
        }
        return jarPath;
    }
}

