/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.values.parsetrees;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jline.jansi.Ansi;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.utils.LimitedResultWriter;
import org.rascalmpl.values.ValueFactoryFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.visitors.TreeVisitor;

public class TreeAdapter {
    private static final String CHARACTER_TREE_ITEM = "character";
    private static final String NO_POSITION_INFORMATION_ERROR = "locate assumes position information on the tree";
    private static final String NO_ARGS_EXCEPTION_MESSAGE = "Node has no args: ";
    public static final String NORMAL = "Normal";
    public static final String TYPE = "Type";
    public static final String IDENTIFIER = "Identifier";
    public static final String VARIABLE = "variable";
    public static final String CONSTANT = "constant";
    public static final String COMMENT = "comment";
    public static final String COMMENT_LEGACY = "Comment";
    public static final String TODO = "Todo";
    public static final String QUOTE = "Quote";
    public static final String META_AMBIGUITY = "MetaAmbiguity";
    public static final String META_VARIABLE = "MetaVariable";
    public static final String META_KEYWORD = "MetaKeyword";
    public static final String META_SKIPPED = "MetaSkipped";
    public static final String NONTERMINAL_LABEL = "NonterminalLabel";
    public static final String RESULT = "Result";
    public static final String STDOUT = "StdOut";
    public static final String STDERR = "StdErr";

    private TreeAdapter() {
    }

    public static boolean isTree(IConstructor cons) {
        return cons instanceof ITree;
    }

    public static boolean isAppl(ITree tree) {
        return tree.isAppl();
    }

    private static int findLabelPosition(ITree tree, String label) {
        if (!TreeAdapter.isAppl(tree)) {
            throw new ImplementationError("can not call getArg on a non-tree");
        }
        IConstructor prod = TreeAdapter.getProduction(tree);
        if (!ProductionAdapter.isDefault(prod)) {
            return -1;
        }
        IList syms = ProductionAdapter.getSymbols(prod);
        for (int i = 0; i < syms.length(); ++i) {
            IConstructor sym = (IConstructor)syms.get(i);
            while (SymbolAdapter.isConditional(sym)) {
                sym = SymbolAdapter.getSymbol(sym);
            }
            if (!SymbolAdapter.isLabel(sym) || !SymbolAdapter.getLabel(sym).equals(label)) continue;
            return i;
        }
        return -1;
    }

    public static ITree getArg(ITree tree, String label) {
        return (ITree)TreeAdapter.getArgs(tree).get(TreeAdapter.findLabelPosition(tree, label));
    }

    public static ITree setArg(ITree tree, String label, IConstructor newArg) {
        return TreeAdapter.setArgs(tree, TreeAdapter.getArgs(tree).put(TreeAdapter.findLabelPosition(tree, label), newArg));
    }

    public static boolean isAmb(ITree tree) {
        return tree.isAmb();
    }

    public static boolean isTop(ITree tree) {
        return SymbolAdapter.isStartSort(TreeAdapter.getType(tree));
    }

    public static boolean isChar(ITree tree) {
        return tree.isChar();
    }

    public static boolean isCycle(ITree tree) {
        return tree.isCycle();
    }

    public static boolean isComment(ITree tree) {
        String treeProdCategory;
        IConstructor treeProd = TreeAdapter.getProduction(tree);
        return treeProd != null && (treeProdCategory = ProductionAdapter.getCategory(treeProd)) != null && (treeProdCategory.equals(COMMENT) || treeProdCategory.equals(COMMENT_LEGACY));
    }

    public static IConstructor getProduction(ITree tree) {
        return tree.getProduction();
    }

    public static ITree putLabeledField(ITree tree, String field, ITree repl) {
        if (TreeAdapter.isAppl(tree)) {
            IConstructor prod = TreeAdapter.getProduction(tree);
            if (ProductionAdapter.isDefault(prod)) {
                int index = SymbolAdapter.indexOfLabel(ProductionAdapter.getSymbols(prod), field);
                IList args = TreeAdapter.getArgs(tree);
                if (index != -1) {
                    return TreeAdapter.setArgs(tree, args.put(index, repl));
                }
            } else if (ProductionAdapter.isRegular(prod)) {
                IConstructor sym = ProductionAdapter.getType(prod);
                IList args = TreeAdapter.getArgs(tree);
                switch (sym.getName()) {
                    case "seq": {
                        IList syms = SymbolAdapter.getSymbols(sym);
                        int index = SymbolAdapter.indexOfLabel(syms, field);
                        if (index == -1) break;
                        return TreeAdapter.setArgs(tree, args.put(index, repl));
                    }
                    case "opt": {
                        sym = SymbolAdapter.getSymbol(sym);
                        if (!SymbolAdapter.isLabel(sym) || !SymbolAdapter.getLabel(sym).equals(field)) break;
                        if (args.length() == 0) {
                            return TreeAdapter.setArgs(tree, args.append(repl));
                        }
                        return TreeAdapter.setArgs(tree, args.put(0, repl));
                    }
                    case "alt": {
                        IList syms = SymbolAdapter.getSymbols(sym);
                        int index = SymbolAdapter.indexOfLabel(syms, field);
                        if (index == -1) break;
                        sym = (IConstructor)syms.get(index);
                        if (!SymbolAdapter.isEqual(TreeAdapter.getType((ITree)args.get(0)), sym)) break;
                        return TreeAdapter.setArgs(tree, args.put(0, repl));
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public static FieldResult getLabeledField(ITree tree, String field) {
        if (TreeAdapter.isAppl(tree)) {
            IConstructor prod = TreeAdapter.getProduction(tree);
            if (ProductionAdapter.isDefault(prod)) {
                IList syms = ProductionAdapter.getSymbols(prod);
                int index = SymbolAdapter.indexOfLabel(syms, field);
                if (index != -1) {
                    IConstructor sym = (IConstructor)syms.get(index);
                    return new FieldResult(SymbolAdapter.stripLabelsAndConditions(sym), (ITree)TreeAdapter.getArgs(tree).get(index));
                }
            } else if (ProductionAdapter.isRegular(prod)) {
                IConstructor sym = ProductionAdapter.getType(prod);
                IList args = TreeAdapter.getArgs(tree);
                switch (sym.getName()) {
                    case "seq": {
                        IList syms = SymbolAdapter.getSymbols(sym);
                        int index = SymbolAdapter.indexOfLabel(syms, field);
                        if (index == -1) break;
                        sym = (IConstructor)syms.get(index);
                        return new FieldResult(SymbolAdapter.stripLabelsAndConditions(sym), (ITree)args.get(index));
                    }
                    case "opt": {
                        if (args.length() == 0) {
                            return null;
                        }
                        if (!SymbolAdapter.isLabel(sym = SymbolAdapter.getSymbol(sym)) || !SymbolAdapter.getLabel(sym).equals(field)) break;
                        return new FieldResult(SymbolAdapter.stripLabelsAndConditions(sym), (ITree)args.get(0));
                    }
                    case "alt": {
                        ISet alts = SymbolAdapter.getAlternatives(sym);
                        for (IValue elt : alts) {
                            sym = (IConstructor)elt;
                            if (!SymbolAdapter.isLabel(sym) || !SymbolAdapter.getLabel((IConstructor)elt).equals(field)) continue;
                            sym = SymbolAdapter.stripLabelsAndConditions(sym);
                            for (IValue arg : args) {
                                if (!SymbolAdapter.isEqual(TreeAdapter.getType((ITree)arg), sym)) continue;
                                return new FieldResult(sym, (ITree)arg);
                            }
                        }
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public static IConstructor getType(ITree tree) {
        if (TreeAdapter.isAppl(tree)) {
            IConstructor sym = ProductionAdapter.getType(TreeAdapter.getProduction(tree));
            if (SymbolAdapter.isStarList(sym) && !TreeAdapter.getArgs(tree).isEmpty()) {
                sym = SymbolAdapter.starToPlus(sym);
            }
            return sym;
        }
        if (TreeAdapter.isCycle(tree)) {
            return (IConstructor)tree.get("symbol");
        }
        if (TreeAdapter.isChar(tree)) {
            return SymbolAdapter.charClass(TreeAdapter.getCharacter(tree));
        }
        if (TreeAdapter.isAmb(tree)) {
            return TreeAdapter.getType((ITree)TreeAdapter.getAlternatives(tree).iterator().next());
        }
        throw new ImplementationError("ITree does not have a type");
    }

    public static String getSortName(ITree tree) {
        return ProductionAdapter.getSortName(TreeAdapter.getProduction(tree));
    }

    public static String getConstructorName(ITree tree) {
        return ProductionAdapter.getConstructorName(TreeAdapter.getProduction(tree));
    }

    public static boolean isProduction(ITree tree, String sortName, String consName) {
        IConstructor prod = TreeAdapter.getProduction(tree);
        return ProductionAdapter.getSortName(prod).equals(sortName) && ProductionAdapter.getConstructorName(prod).equals(consName);
    }

    public static boolean isContextFree(ITree tree) {
        return TreeAdapter.isAppl(tree) && ProductionAdapter.isContextFree(TreeAdapter.getProduction(tree));
    }

    public static boolean isList(ITree tree) {
        return TreeAdapter.isAppl(tree) && ProductionAdapter.isList(TreeAdapter.getProduction(tree));
    }

    public static boolean isOpt(ITree tree) {
        return TreeAdapter.isAppl(tree) && ProductionAdapter.isOpt(TreeAdapter.getProduction(tree));
    }

    public static IList getArgs(ITree tree) {
        return tree.getArgs();
    }

    public static ITree setArgs(ITree tree, IList args) {
        if (TreeAdapter.isAppl(tree)) {
            return (ITree)tree.set("args", (IValue)args);
        }
        throw new ImplementationError(NO_ARGS_EXCEPTION_MESSAGE + tree.getName());
    }

    public static ITree setProduction(ITree tree, IConstructor prod) {
        if (TreeAdapter.isAppl(tree)) {
            return (ITree)tree.set("prod", (IValue)prod);
        }
        throw new ImplementationError(NO_ARGS_EXCEPTION_MESSAGE + tree.getName());
    }

    public static boolean isLiteral(ITree tree) {
        return TreeAdapter.isAppl(tree) && ProductionAdapter.isLiteral(TreeAdapter.getProduction(tree));
    }

    public static IList getListASTArgs(ITree tree) {
        if (!TreeAdapter.isList(tree)) {
            throw new ImplementationError("This is not a context-free list production: " + tree);
        }
        IList children = TreeAdapter.getArgs(tree);
        IListWriter writer = ValueFactoryFactory.getValueFactory().listWriter();
        for (int i = 0; i < children.length(); i += 2) {
            IValue kid = children.get(i);
            writer.append(kid);
            if (!TreeAdapter.isSeparatedList(tree)) continue;
            i += TreeAdapter.getSeparatorCount(tree) - 1;
        }
        return (IList)writer.done();
    }

    public static int getSeparatorCount(ITree tree) {
        IConstructor nt = ProductionAdapter.getType(TreeAdapter.getProduction(tree));
        return SymbolAdapter.isSepList(nt) ? SymbolAdapter.getSeparators(nt).length() : 0;
    }

    public static boolean isLexical(ITree tree) {
        return TreeAdapter.isAppl(tree) && ProductionAdapter.isLexical(TreeAdapter.getProduction(tree));
    }

    public static boolean isSort(ITree tree) {
        return TreeAdapter.isAppl(tree) && ProductionAdapter.isSort(TreeAdapter.getProduction(tree));
    }

    public static boolean isLayout(ITree tree) {
        return TreeAdapter.isAppl(tree) && ProductionAdapter.isLayout(TreeAdapter.getProduction(tree));
    }

    public static boolean isSeparatedList(ITree tree) {
        return TreeAdapter.isAppl(tree) && TreeAdapter.isList(tree) && ProductionAdapter.isSeparatedList(TreeAdapter.getProduction(tree));
    }

    public static IList getASTArgs(ITree tree) {
        if (SymbolAdapter.isStartSort(TreeAdapter.getType(tree))) {
            return TreeAdapter.getArgs(tree).delete(0).delete(1);
        }
        if (TreeAdapter.isLexical(tree)) {
            throw new ImplementationError("This is not a context-free production: " + tree);
        }
        IList children = TreeAdapter.getArgs(tree);
        IListWriter writer = ValueFactoryFactory.getValueFactory().listWriter();
        for (int i = 0; i < children.length(); i += 2) {
            ITree kid = (ITree)children.get(i);
            if (TreeAdapter.isLiteral(kid) || TreeAdapter.isCILiteral(kid)) continue;
            writer.append(kid);
        }
        return (IList)writer.done();
    }

    public static boolean isCILiteral(ITree tree) {
        return TreeAdapter.isAppl(tree) && ProductionAdapter.isCILiteral(TreeAdapter.getProduction(tree));
    }

    public static ISet getAlternatives(ITree tree) {
        if (TreeAdapter.isAmb(tree)) {
            return (ISet)tree.get("alternatives");
        }
        throw new ImplementationError("Node has no alternatives");
    }

    public static ISourceLocation getLocation(ITree tree) {
        return (ISourceLocation)tree.asWithKeywordParameters().getParameter("src");
    }

    public static ITree setLocation(ITree tree, ISourceLocation loc) {
        return (ITree)tree.asWithKeywordParameters().setParameter("src", loc);
    }

    public static int getCharacter(ITree tree) {
        return ((IInteger)tree.get(CHARACTER_TREE_ITEM)).intValue();
    }

    public static IConstructor locateLexical(ITree tree, int offset) {
        ISourceLocation l = TreeAdapter.getLocation(tree);
        if (l == null) {
            throw new IllegalArgumentException(NO_POSITION_INFORMATION_ERROR);
        }
        if (TreeAdapter.isLexical(tree)) {
            if (l.getOffset() <= offset && offset < l.getOffset() + l.getLength()) {
                return tree;
            }
            return null;
        }
        if (TreeAdapter.isAmb(tree)) {
            return null;
        }
        if (TreeAdapter.isAppl(tree)) {
            IList children = TreeAdapter.getASTArgs(tree);
            for (IValue child : children) {
                ISourceLocation childLoc = TreeAdapter.getLocation((ITree)child);
                if (childLoc == null || childLoc.getOffset() > offset || offset >= childLoc.getOffset() + childLoc.getLength()) continue;
                IConstructor result = TreeAdapter.locateLexical((ITree)child, offset);
                if (result == null) break;
                return result;
            }
            if (l.getOffset() <= offset && l.getOffset() + l.getLength() >= offset) {
                return tree;
            }
        }
        return null;
    }

    public static ITree locateLexical(ITree tree, int line, int column) {
        ISourceLocation l = TreeAdapter.getLocation(tree);
        if (l == null) {
            throw new IllegalArgumentException("no position info");
        }
        if (!l.hasLineColumn()) {
            return null;
        }
        if (TreeAdapter.isLexical(tree)) {
            if (l.getBeginLine() == line && l.getBeginColumn() <= column && column <= l.getEndColumn()) {
                return tree;
            }
            return null;
        }
        if (TreeAdapter.isAmb(tree)) {
            return null;
        }
        if (TreeAdapter.isAppl(tree)) {
            IList children = TreeAdapter.getASTArgs(tree);
            for (IValue child : children) {
                ITree result;
                ISourceLocation childLoc = TreeAdapter.getLocation((ITree)child);
                if (childLoc == null || childLoc.getBeginLine() > line || line > childLoc.getEndLine() || !(childLoc.getBeginLine() == line && childLoc.getEndColumn() == line ? childLoc.getBeginColumn() <= column && column <= childLoc.getEndColumn() && (result = TreeAdapter.locateLexical((ITree)child, line, column)) != null : (result = TreeAdapter.locateLexical((ITree)child, line, column)) != null)) continue;
                return result;
            }
        }
        return null;
    }

    public static ITree locateAnnotatedTree(ITree tree, String label, int offset) {
        ISourceLocation l = TreeAdapter.getLocation(tree);
        if (l == null) {
            throw new IllegalArgumentException(NO_POSITION_INFORMATION_ERROR);
        }
        if (TreeAdapter.isAmb(tree)) {
            if (tree.asWithKeywordParameters().hasParameter(label)) {
                return tree;
            }
            return null;
        }
        if (TreeAdapter.isAppl(tree) && !TreeAdapter.isLexical(tree)) {
            IList children = TreeAdapter.getArgs(tree);
            for (IValue child : children) {
                ITree result;
                ISourceLocation childLoc = TreeAdapter.getLocation((ITree)child);
                if (childLoc == null || childLoc.getOffset() > offset || offset >= childLoc.getOffset() + childLoc.getLength() || (result = TreeAdapter.locateAnnotatedTree((ITree)child, label, offset)) == null) continue;
                return result;
            }
        }
        if (l.getOffset() <= offset && l.getOffset() + l.getLength() >= offset && tree.asWithKeywordParameters().hasParameter(label)) {
            return tree;
        }
        return null;
    }

    public static void unparse(IConstructor tree, Writer stream) throws IOException {
        TreeAdapter.unparse(tree, false, stream);
    }

    public static void unparse(IConstructor tree, boolean highlight, Writer stream) throws IOException {
        if (!(tree instanceof ITree)) {
            throw new ImplementationError("Can not unparse this " + tree + " (type = " + tree.getType() + ")");
        }
        tree.accept(new Unparser(stream, highlight));
    }

    public static void unparseWithFocus(IConstructor tree, Writer stream, ISourceLocation focus) throws IOException {
        if (!(tree instanceof ITree)) {
            throw new ImplementationError("Can not unparse this " + tree + " (type = " + tree.getType() + ")");
        }
        tree.accept(new UnparserWithFocus(stream, focus));
    }

    public static String yield(IConstructor tree, boolean highlight, int limit) {
        LimitedResultWriter stream = new LimitedResultWriter(limit);
        try {
            TreeAdapter.unparse(tree, highlight, stream);
            return ((Object)stream).toString();
        }
        catch (RuntimeException e) {
            return ((Object)stream).toString();
        }
        catch (IOException e) {
            throw new ImplementationError("Method yield failed", e);
        }
    }

    public static String yield(IConstructor tree, int limit) {
        return TreeAdapter.yield(tree, false, limit);
    }

    public static String yield(IConstructor tree) {
        return TreeAdapter.yield(tree, false);
    }

    public static String yield(IConstructor tree, boolean highlight) {
        try {
            CharArrayWriter stream = new CharArrayWriter();
            TreeAdapter.unparse(tree, highlight, stream);
            return ((Object)stream).toString();
        }
        catch (IOException e) {
            throw new ImplementationError("Method yield failed", e);
        }
    }

    public static void yield(IConstructor tree, Writer out) throws IOException {
        TreeAdapter.unparse(tree, out);
    }

    public static void yield(IConstructor tree, boolean highlight, Writer out) throws IOException {
        TreeAdapter.unparse(tree, highlight, out);
    }

    public static boolean isInjectionOrSingleton(ITree tree) {
        IConstructor prod = TreeAdapter.getProduction(tree);
        if (TreeAdapter.isAppl(tree)) {
            if (ProductionAdapter.isDefault(prod)) {
                return ProductionAdapter.getSymbols(prod).length() == 1;
            }
            if (ProductionAdapter.isList(prod)) {
                return TreeAdapter.getArgs(tree).length() == 1;
            }
        }
        return false;
    }

    public static boolean isAmbiguousList(ITree tree) {
        ITree first;
        return TreeAdapter.isAmb(tree) && TreeAdapter.isList(first = (ITree)TreeAdapter.getAlternatives(tree).iterator().next());
    }

    public static boolean isNonEmptyStarList(ITree tree) {
        IConstructor sym;
        IConstructor prod;
        if (TreeAdapter.isAppl(tree) && ProductionAdapter.isList(prod = TreeAdapter.getProduction(tree)) && (SymbolAdapter.isIterStar(sym = ProductionAdapter.getType(prod)) || SymbolAdapter.isIterStarSeps(sym))) {
            return TreeAdapter.getArgs(tree).length() > 0;
        }
        return false;
    }

    public static boolean isPlusList(ITree tree) {
        IConstructor sym;
        IConstructor prod;
        return TreeAdapter.isAppl(tree) && ProductionAdapter.isList(prod = TreeAdapter.getProduction(tree)) && (SymbolAdapter.isIterPlus(sym = ProductionAdapter.getType(prod)) || SymbolAdapter.isIterPlusSeps(sym));
    }

    public static boolean isEpsilon(ITree tree) {
        if (TreeAdapter.isAppl(tree)) {
            for (IValue arg : TreeAdapter.getArgs(tree)) {
                if (TreeAdapter.isEpsilon((ITree)arg)) continue;
                return false;
            }
            return true;
        }
        if (TreeAdapter.isAmb(tree)) {
            return TreeAdapter.isEpsilon((ITree)TreeAdapter.getAlternatives(tree).iterator().next());
        }
        return TreeAdapter.isCycle(tree);
    }

    public static IList searchCategory(ITree tree, String category) {
        IListWriter writer = ValueFactoryFactory.getValueFactory().listWriter();
        if (TreeAdapter.isAppl(tree)) {
            String s2 = ProductionAdapter.getCategory(TreeAdapter.getProduction(tree));
            if (s2.equals(category)) {
                writer.append(tree);
            } else {
                IList z = TreeAdapter.getArgs(tree);
                for (IValue q : z) {
                    if (!(q instanceof IConstructor)) continue;
                    IList p = TreeAdapter.searchCategory((ITree)q, category);
                    writer.appendAll(p);
                }
            }
        }
        return (IList)writer.done();
    }

    public static boolean isRascalLexical(ITree tree) {
        return SymbolAdapter.isLex(TreeAdapter.getType(tree));
    }

    public static IConstructor locateDeepestContextFreeNode(ITree tree, int offset) {
        ISourceLocation l = TreeAdapter.getLocation(tree);
        if (l == null) {
            throw new IllegalArgumentException(NO_POSITION_INFORMATION_ERROR);
        }
        if (TreeAdapter.isLexical(tree)) {
            if (l.getOffset() <= offset && offset < l.getOffset() + l.getLength()) {
                return tree;
            }
            return null;
        }
        if (TreeAdapter.isAmb(tree)) {
            return null;
        }
        if (TreeAdapter.isAppl(tree)) {
            IList children = TreeAdapter.getASTArgs(tree);
            for (IValue child : children) {
                ISourceLocation childLoc = TreeAdapter.getLocation((ITree)child);
                if (childLoc == null || childLoc.getOffset() > offset || offset >= childLoc.getOffset() + childLoc.getLength()) continue;
                IConstructor result = TreeAdapter.locateDeepestContextFreeNode((ITree)child, offset);
                if (result == null) break;
                return result;
            }
            if (l.getOffset() <= offset && l.getOffset() + l.getLength() >= offset) {
                return tree;
            }
        }
        return null;
    }

    public static boolean isEmpty(ITree kid) {
        return TreeAdapter.isAppl(kid) && SymbolAdapter.isEmpty(ProductionAdapter.getType(TreeAdapter.getProduction(kid)));
    }

    public static int getCycleLength(ITree tree) {
        return ((IInteger)tree.get("cycleLength")).intValue();
    }

    public static IConstructor getCycleType(ITree tree) {
        return (IConstructor)tree.get("symbol");
    }

    public static ITree getStartTop(ITree prefix) {
        return (ITree)TreeAdapter.getArgs(prefix).get(1);
    }

    public static IList getNonLayoutArgs(ITree treeSubject) {
        IListWriter w = ValueFactoryFactory.getValueFactory().listWriter();
        for (IValue v : TreeAdapter.getArgs(treeSubject)) {
            if (TreeAdapter.isLayout((ITree)v)) continue;
            w.append(v);
        }
        return (IList)w.done();
    }

    public static int getListLength(ITree in) {
        return in.getArgs().length() / TreeAdapter.getSeparatorCount(in) + 1;
    }

    private static class UnparserWithFocus
    extends Unparser {
        private ISourceLocation focus;
        private final String BACKGROUND_ON = Ansi.ansi().bgBright(Ansi.Color.CYAN).toString();
        private final String BACKGROUND_OFF = Ansi.ansi().bg(Ansi.Color.DEFAULT).toString();
        private boolean insideFocus = false;

        public UnparserWithFocus(Writer stream, ISourceLocation focus) {
            super(stream, true);
            this.focus = focus;
        }

        @Override
        public ITree visitTreeChar(ITree arg) throws IOException {
            char[] chars = Character.toChars(((IInteger)arg.get(TreeAdapter.CHARACTER_TREE_ITEM)).intValue());
            if (this.insideFocus) {
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] == '\n') {
                        this.fStream.write(this.BACKGROUND_OFF);
                        this.fStream.write(chars[i]);
                        this.fStream.write(this.BACKGROUND_ON);
                        continue;
                    }
                    this.fStream.write(chars[i]);
                }
            } else {
                this.fStream.write(Character.toChars(((IInteger)arg.get(TreeAdapter.CHARACTER_TREE_ITEM)).intValue()));
            }
            return arg;
        }

        @Override
        public ITree visitTreeAppl(ITree arg) throws IOException {
            ISourceLocation argLoc = TreeAdapter.getLocation(arg);
            if (argLoc != null && argLoc.getOffset() == this.focus.getOffset() && argLoc.getLength() == this.focus.getLength()) {
                this.fStream.write(this.BACKGROUND_ON);
                this.insideFocus = true;
                super.visitTreeAppl(arg);
                this.insideFocus = false;
                this.fStream.write(this.BACKGROUND_OFF);
            } else {
                super.visitTreeAppl(arg);
            }
            return arg;
        }
    }

    private static class Unparser
    extends TreeVisitor<IOException> {
        protected final Writer fStream;
        private final boolean fHighlight;
        private final Map<String, Ansi> ansiOpen = new HashMap<String, Ansi>();
        private final Map<String, Ansi> ansiClose = new HashMap<String, Ansi>();

        public Unparser(Writer stream, boolean highlight) {
            this.fStream = stream;
            this.fHighlight = highlight;
            this.ansiOpen.put(TreeAdapter.NORMAL, Ansi.ansi().a(Ansi.Attribute.ITALIC_OFF).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).fgBright(Ansi.Color.DEFAULT));
            this.ansiClose.put(TreeAdapter.NORMAL, Ansi.ansi().a(Ansi.Attribute.ITALIC_OFF).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).fgBright(Ansi.Color.DEFAULT));
            this.ansiOpen.put(TreeAdapter.NONTERMINAL_LABEL, Ansi.ansi().a(Ansi.Attribute.ITALIC).fg(Ansi.Color.CYAN));
            this.ansiClose.put(TreeAdapter.NONTERMINAL_LABEL, Ansi.ansi().a(Ansi.Attribute.ITALIC_OFF).fg(Ansi.Color.DEFAULT));
            this.ansiOpen.put(TreeAdapter.META_KEYWORD, Ansi.ansi().fg(Ansi.Color.MAGENTA));
            this.ansiClose.put(TreeAdapter.META_KEYWORD, Ansi.ansi().fg(Ansi.Color.DEFAULT));
            this.ansiOpen.put(TreeAdapter.VARIABLE, Ansi.ansi().a(Ansi.Attribute.ITALIC).fgBright(Ansi.Color.GREEN));
            this.ansiClose.put(TreeAdapter.VARIABLE, Ansi.ansi().a(Ansi.Attribute.ITALIC_OFF).fgBright(Ansi.Color.DEFAULT));
            this.ansiOpen.put(TreeAdapter.META_VARIABLE, Ansi.ansi().a(Ansi.Attribute.ITALIC).fgBright(Ansi.Color.GREEN));
            this.ansiClose.put(TreeAdapter.META_VARIABLE, Ansi.ansi().a(Ansi.Attribute.ITALIC_OFF).fgBright(Ansi.Color.DEFAULT));
            this.ansiOpen.put(TreeAdapter.META_AMBIGUITY, Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).fgBright(Ansi.Color.RED));
            this.ansiClose.put(TreeAdapter.META_AMBIGUITY, Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD_OFF).fgBright(Ansi.Color.DEFAULT));
            this.ansiOpen.put(TreeAdapter.META_SKIPPED, Ansi.ansi().bgBright(Ansi.Color.RED));
            this.ansiClose.put(TreeAdapter.META_SKIPPED, Ansi.ansi().bgBright(Ansi.Color.WHITE));
            this.ansiOpen.put(TreeAdapter.COMMENT, Ansi.ansi().a(Ansi.Attribute.ITALIC).fg(Ansi.Color.GREEN));
            this.ansiClose.put(TreeAdapter.COMMENT, Ansi.ansi().a(Ansi.Attribute.ITALIC_OFF).fg(Ansi.Color.DEFAULT));
            this.ansiOpen.put(TreeAdapter.COMMENT_LEGACY, Ansi.ansi().a(Ansi.Attribute.ITALIC).fg(Ansi.Color.GREEN));
            this.ansiClose.put(TreeAdapter.COMMENT_LEGACY, Ansi.ansi().a(Ansi.Attribute.ITALIC_OFF).fg(Ansi.Color.DEFAULT));
        }

        @Override
        public ITree visitTreeAmb(ITree arg) throws IOException {
            ISet alts = TreeAdapter.getAlternatives(arg);
            if (alts.isEmpty()) {
                return arg;
            }
            Iterator alternatives = alts.iterator();
            ITree tree = (ITree)alternatives.next();
            while (alternatives.hasNext() && CycleDetector.detect(tree)) {
                tree = (ITree)alternatives.next();
            }
            tree.accept(this);
            return arg;
        }

        @Override
        public ITree visitTreeCycle(ITree arg) throws IOException {
            return arg;
        }

        @Override
        public ITree visitTreeChar(ITree arg) throws IOException {
            this.fStream.write(Character.toChars(((IInteger)arg.get(TreeAdapter.CHARACTER_TREE_ITEM)).intValue()));
            return arg;
        }

        @Override
        public ITree visitTreeAppl(ITree arg) throws IOException {
            Object code;
            boolean reset = false;
            String category = null;
            if (this.fHighlight) {
                IConstructor prod = TreeAdapter.getProduction(arg);
                category = ProductionAdapter.getCategory(prod);
                if (category == null && (TreeAdapter.isLiteral(arg) || TreeAdapter.isCILiteral(arg))) {
                    category = TreeAdapter.META_KEYWORD;
                    for (IValue child : TreeAdapter.getArgs(arg)) {
                        int c = TreeAdapter.getCharacter((ITree)child);
                        if (c == 45 || Character.isJavaIdentifierPart(c)) continue;
                        category = null;
                    }
                }
                if (category != null && (code = this.ansiOpen.get(category)) != null) {
                    this.fStream.write(((Ansi)code).toString());
                    reset = true;
                }
            }
            IList children = (IList)arg.get("args");
            code = children.iterator();
            while (code.hasNext()) {
                IValue child;
                child = (IValue)code.next();
                child.accept(this);
            }
            if (this.fHighlight && reset && (code = this.ansiClose.get(category)) != null) {
                this.fStream.write(((Ansi)code).toString());
            }
            return arg;
        }

        private static class CycleDetector
        extends TreeVisitor<IOException> {
            private boolean result = false;

            private CycleDetector() {
            }

            @Override
            public ITree visitTreeCycle(ITree arg) throws IOException {
                this.result = true;
                return arg;
            }

            @Override
            public ITree visitTreeAppl(ITree arg) throws IOException {
                if (!this.result) {
                    IList children = (IList)arg.get("args");
                    for (IValue child : children) {
                        child.accept(this);
                        if (!this.result) continue;
                        break;
                    }
                }
                return arg;
            }

            @Override
            public ITree visitTreeAmb(ITree arg) throws IOException {
                return arg;
            }

            @Override
            public ITree visitTreeChar(ITree arg) throws IOException {
                return arg;
            }

            public static boolean detect(ITree tree) throws IOException {
                CycleDetector look = new CycleDetector();
                tree.accept(look);
                return look.result;
            }
        }
    }

    public static class FieldResult {
        public IConstructor symbol;
        public ITree tree;

        public FieldResult(IConstructor symbol, ITree tree) {
            this.symbol = symbol;
            this.tree = tree;
        }
    }
}

