/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.vallang.ICollection;
import io.usethesource.vallang.IValue;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public interface IWriter<T extends ICollection<T>>
extends Iterable<IValue>,
Collector<IValue, IWriter<T>, T> {
    default public IWriter<T> unique() {
        return this;
    }

    public void insert(IValue ... var1);

    default public void append(IValue ... value) {
        this.insert(value);
    }

    default public void appendAll(Iterable<? extends IValue> collection) {
        for (IValue iValue : collection) {
            this.append(iValue);
        }
    }

    public void insertTuple(IValue ... var1);

    default public void appendTuple(IValue ... fields) {
        this.insertTuple(fields);
    }

    default public void insertAll(Iterable<? extends IValue> collection) {
        for (IValue iValue : collection) {
            this.insert(iValue);
        }
    }

    public T done();

    @Override
    default public BiConsumer<IWriter<T>, IValue> accumulator() {
        return (writer, elem) -> writer.append((IValue)elem);
    }

    @Override
    public Supplier<IWriter<T>> supplier();

    @Override
    default public Function<IWriter<T>, T> finisher() {
        return w -> w.done();
    }

    @Override
    default public BinaryOperator<IWriter<T>> combiner() {
        return (w1, w2) -> {
            w2.forEach(e -> w1.append((IValue)e));
            return w1;
        };
    }

    @Override
    default public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }
}

