/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.impl.persistent.List;
import io.usethesource.vallang.impl.persistent.Tuple;
import io.usethesource.vallang.impl.util.collections.ShareableValuesList;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Iterator;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class ListWriter
implements IListWriter {
    private Type elementType;
    private final ShareableValuesList data;
    private @MonotonicNonNull IList constructedList;
    private final boolean unique;

    ListWriter() {
        this.elementType = TypeFactory.getInstance().voidType();
        this.data = new ShareableValuesList();
        this.unique = false;
    }

    private ListWriter(boolean unique) {
        this.elementType = TypeFactory.getInstance().voidType();
        this.data = new ShareableValuesList();
        this.unique = unique;
    }

    @Override
    public IWriter<IList> unique() {
        return new ListWriter(true);
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.data.iterator();
    }

    ListWriter(Type elementType, ShareableValuesList data) {
        this.elementType = elementType;
        this.data = data;
        this.unique = false;
    }

    @Override
    public void insertTuple(IValue ... fields) {
        this.insert((IValue)Tuple.newTuple(fields));
    }

    public void append(IValue element) {
        this.checkMutation();
        if (this.unique && this.data.contains(element)) {
            return;
        }
        this.updateType(element);
        this.data.append(element);
    }

    @Override
    public void appendTuple(IValue ... fields) {
        this.append((IValue)Tuple.newTuple(fields));
    }

    private void updateType(IValue element) {
        this.elementType = this.elementType.lub(element.getType());
    }

    @Override
    public void append(IValue ... elems) {
        this.checkMutation();
        boolean notUnique = false;
        for (IValue elem : elems) {
            if (this.unique && this.data.contains(elem)) {
                notUnique = true;
                break;
            }
            this.updateType(elem);
        }
        if (!notUnique) {
            this.data.appendAll(elems);
        } else {
            for (IValue next : elems) {
                if (this.unique && this.data.contains(next)) continue;
                this.updateType(next);
                this.data.append(next);
            }
        }
    }

    @Override
    public void appendAll(Iterable<? extends IValue> collection) {
        this.checkMutation();
        for (IValue iValue : collection) {
            if (this.unique && this.data.contains(iValue)) continue;
            this.updateType(iValue);
            this.data.append(iValue);
        }
    }

    public void insert(IValue elem) {
        this.checkMutation();
        if (this.unique && this.data.contains(elem)) {
            return;
        }
        this.updateType(elem);
        this.data.insert(elem);
    }

    @Override
    public void insert(IValue ... elements) {
        this.insert(elements, 0, elements.length);
    }

    @Override
    public void insert(IValue[] elements, int start, int length) {
        this.checkMutation();
        this.checkBounds(elements, start, length);
        for (int i = start + length - 1; i >= start; --i) {
            this.updateType(elements[i]);
            if (this.unique && this.data.contains(elements[i])) continue;
            this.data.insert(elements[i]);
        }
    }

    @Override
    public void insertAll(Iterable<? extends IValue> collection) {
        this.checkMutation();
        for (IValue iValue : collection) {
            if (this.unique && this.data.contains(iValue)) continue;
            this.updateType(iValue);
            this.data.insert(iValue);
        }
    }

    @Override
    public void insertAt(int index, IValue ... elements) {
        this.insertAt(index, elements, 0, 0);
    }

    @Override
    public void insertAt(int index, IValue[] elements, int start, int length) {
        this.checkMutation();
        this.checkBounds(elements, start, length);
        for (int i = start + length - 1; i >= start; --i) {
            this.updateType(elements[i]);
            this.data.insertAt(index, elements[i]);
        }
    }

    @Override
    public IValue replaceAt(int index, IValue element) {
        this.checkMutation();
        this.updateType(element);
        return this.data.set(index, element);
    }

    @Override
    public IValue get(int i) throws IndexOutOfBoundsException {
        return (IValue)this.data.get(i);
    }

    @Override
    public int length() {
        return this.data.size();
    }

    protected void checkMutation() {
        if (this.constructedList != null) {
            throw new UnsupportedOperationException("Mutation of a finalized list is not supported.");
        }
    }

    private void checkBounds(IValue[] elems, int start, int length) {
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException("start < 0");
        }
        if (start + length > elems.length) {
            throw new ArrayIndexOutOfBoundsException("(start + length) > elems.length");
        }
    }

    @Override
    public IList done() {
        if (this.constructedList == null) {
            this.constructedList = List.newList(this.elementType, this.data);
        }
        return this.constructedList;
    }

    @Override
    public Supplier<IWriter<IList>> supplier() {
        return () -> new ListWriter();
    }
}

