/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.stream;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.io.binary.message.IValueReader;
import io.usethesource.vallang.io.binary.stream.Compressor;
import io.usethesource.vallang.io.binary.stream.Header;
import io.usethesource.vallang.io.binary.util.FileChannelDirectInputStream;
import io.usethesource.vallang.io.binary.wire.binary.BinaryWireInputStream;
import io.usethesource.vallang.type.TypeStore;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IValueInputStream
implements Closeable {
    private final @Nullable BinaryWireInputStream reader;
    private final IValueFactory vf;
    private final Supplier<TypeStore> typeStoreSupplier;

    public IValueInputStream(InputStream in, IValueFactory vf, Supplier<TypeStore> typeStoreSupplier) throws IOException {
        this.vf = vf;
        this.typeStoreSupplier = typeStoreSupplier;
        byte[] currentHeader = new byte[Header.MAIN.length];
        for (int read = 0; read < currentHeader.length; read += in.read(currentHeader, read, currentHeader.length - read)) {
        }
        if (!Arrays.equals(currentHeader, Header.MAIN)) {
            throw new IOException("Incorrect file header, expected: [" + IValueInputStream.toHex(Header.MAIN) + "] but found: [" + IValueInputStream.toHex(currentHeader) + "]");
        }
        int compression = in.read();
        in = Compressor.wrapStream(in, compression);
        this.reader = new BinaryWireInputStream(in);
    }

    private static String toHex(byte[] main) {
        Object result = "";
        for (byte b : main) {
            result = (String)result + String.format("%#04x ", b);
        }
        return ((String)result).trim();
    }

    public IValueInputStream(FileChannel channel, IValueFactory vf, Supplier<TypeStore> typeStoreSupplier) throws IOException {
        this(new FileChannelDirectInputStream(channel), vf, typeStoreSupplier);
    }

    public IValue read() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Incorrect initialization");
        }
        return IValueReader.readValue(this.reader, this.vf, this.typeStoreSupplier);
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

