/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import io.usethesource.vallang.io.binary.util.ArrayUtil;
import io.usethesource.vallang.io.binary.util.ClearableWindow;
import io.usethesource.vallang.io.binary.util.TrackLastWritten;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class OpenAddressingLastWritten<T>
implements TrackLastWritten<T>,
ClearableWindow {
    private final int maximumEntries;
    private final int maximumSize;
    private int tableSize;
    private int resizeAfter;
    private @Nullable Object[] keys;
    private long[] writtenAt;
    private int[] hashes;
    private int[] oldest;
    private long written;

    public static <T> OpenAddressingLastWritten<T> referenceEquality(int maximumEntries) {
        return new OpenAddressingLastWritten<T>(maximumEntries){

            @Override
            protected boolean equals(T a, T b) {
                return a == b;
            }

            @Override
            protected int hash(T obj) {
                return System.identityHashCode(obj);
            }
        };
    }

    public static <T> OpenAddressingLastWritten<T> objectEquality(int maximumEntries) {
        return new OpenAddressingLastWritten<T>(maximumEntries){

            @Override
            protected boolean equals(T a, T b) {
                return a.equals(b);
            }

            @Override
            protected int hash(T obj) {
                return obj.hashCode();
            }
        };
    }

    public OpenAddressingLastWritten(int maximumEntries) {
        if (maximumEntries <= 0) {
            throw new IllegalArgumentException("Maximum entries should be a positive number");
        }
        if (maximumEntries > 0x2AAAAAAA) {
            throw new IllegalArgumentException("Maximum entries should be smaller than 715827882");
        }
        this.maximumEntries = maximumEntries;
        this.maximumSize = OpenAddressingLastWritten.closestPrime(maximumEntries * 3);
        this.tableSize = Math.min(571, this.maximumSize);
        this.resizeAfter = Math.min(this.tableSize / 3, maximumEntries);
        this.keys = new Object[this.tableSize];
        this.writtenAt = new long[this.tableSize];
        this.hashes = new int[this.tableSize];
        this.oldest = new int[this.resizeAfter];
        ArrayUtil.fill(this.oldest, -1);
        this.written = 0L;
    }

    private static boolean isPrime(int num) {
        if (num < 2) {
            return false;
        }
        if (num == 2) {
            return true;
        }
        if (num % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= num) {
            if (num % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    private static int closestPrime(int i) {
        if (i <= 2) {
            return 2;
        }
        if (i % 2 == 0) {
            ++i;
        }
        while (i > 0 && !OpenAddressingLastWritten.isPrime(i)) {
            i += 2;
        }
        if (i <= 0) {
            return 0x7FFFFFF7;
        }
        return i;
    }

    @Override
    public int howLongAgo(T obj) {
        int pos = this.locate(obj);
        if (pos != -1) {
            return (int)(this.written - this.writtenAt[pos] - 1L);
        }
        return -1;
    }

    private int translateOldest(long index) {
        return (int)(index % (long)this.resizeAfter);
    }

    private int locate(T obj) {
        @Nullable Object[] keys = this.keys;
        int pos = (this.hash(obj) & Integer.MAX_VALUE) % this.tableSize;
        Object current = keys[pos];
        if (current == null) {
            return -1;
        }
        while (!this.equals(current, obj)) {
            current = keys[pos = (pos + 1) % this.tableSize];
            if (current != null) continue;
            return -1;
        }
        return pos;
    }

    protected abstract boolean equals(T var1, T var2);

    protected abstract int hash(T var1);

    private int findSpace(int hash) {
        int pos = (hash & Integer.MAX_VALUE) % this.tableSize;
        while (this.keys[pos] != null) {
            pos = (pos + 1) % this.tableSize;
        }
        return pos;
    }

    @Override
    public void write(T obj) {
        this.growIfNeeded();
        int historyPos = this.translateOldest(this.written);
        int oldestEntry = this.oldest[historyPos];
        if (oldestEntry != -1) {
            this.remove(oldestEntry);
        }
        int hash = this.hash(obj);
        int pos = this.findSpace(hash);
        this.keys[pos] = obj;
        ++this.written;
        this.hashes[pos] = hash;
        this.oldest[historyPos] = pos;
    }

    private void remove(int oldestEntry) {
        int space = oldestEntry;
        @Nullable Object[] keys = this.keys;
        while (true) {
            int k;
            int candidate = space;
            Object curr = null;
            do {
                if ((curr = keys[candidate = (candidate + 1) % this.tableSize]) == null) {
                    keys[space] = null;
                    return;
                }
                k = (this.hashes[candidate] & Integer.MAX_VALUE) % this.tableSize;
            } while (!(space <= candidate ? space >= k || k > candidate : space >= k && k > candidate));
            keys[space] = Objects.requireNonNull(curr);
            this.writtenAt[space] = this.writtenAt[candidate];
            this.hashes[space] = this.hashes[candidate];
            this.oldest[this.translateOldest((long)this.writtenAt[space])] = space;
            space = candidate;
        }
    }

    private void growIfNeeded() {
        if (this.written == (long)this.resizeAfter && this.tableSize != this.maximumSize) {
            this.tableSize = Math.min(OpenAddressingLastWritten.closestPrime(this.tableSize * 2), this.maximumSize);
            this.resizeAfter = Math.min(this.tableSize / 3, this.maximumEntries);
            @Nullable Object[] oldKeys = this.keys;
            long[] oldWrittenAt = this.writtenAt;
            int[] oldHashes = this.hashes;
            this.keys = new Object[this.tableSize];
            this.writtenAt = new long[this.tableSize];
            this.hashes = new int[this.tableSize];
            this.oldest = new int[this.resizeAfter];
            ArrayUtil.fill(this.oldest, -1);
            for (int i = 0; i < oldKeys.length; ++i) {
                Object key = oldKeys[i];
                if (key == null) continue;
                int hash = oldHashes[i];
                int newIndex = this.findSpace(hash);
                long at = oldWrittenAt[i];
                this.keys[newIndex] = key;
                this.hashes[newIndex] = hash;
                this.writtenAt[newIndex] = at;
                this.oldest[this.translateOldest((long)at)] = newIndex;
            }
        }
    }

    @Override
    public int size() {
        return this.maximumEntries;
    }

    @Override
    public void clear() {
        ArrayUtil.fill(this.keys, null);
        ArrayUtil.fill(this.oldest, -1);
        this.written = 0L;
    }
}

