/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BoolType
extends DefaultSubtypeOfValue {
    BoolType() {
    }

    public static BoolType getInstance() {
        return InstanceKeeper.sInstance;
    }

    @Override
    public IValue randomValue(Random random, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxBreadth) {
        return vf.bool(random.nextBoolean());
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return obj == BoolType.getInstance();
    }

    @Override
    public int hashCode() {
        return 84121;
    }

    @Override
    public String toString() {
        return "bool";
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitBool(this);
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithBool(this);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfBool(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithBool(this);
    }

    @Override
    protected boolean isSubtypeOfBool(Type type) {
        return true;
    }

    @Override
    protected Type lubWithBool(Type type) {
        return this;
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithBool(this);
    }

    @Override
    protected boolean intersectsWithBool(Type type) {
        return true;
    }

    @Override
    protected Type glbWithBool(Type type) {
        return this;
    }

    @Override
    public boolean isBool() {
        return true;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("bool", new Object[0]);
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            return BoolType.getInstance();
        }

        @Override
        public Type randomInstance(Supplier<Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.tf().boolType();
        }
    }

    private static final class InstanceKeeper {
        public static final BoolType sInstance = new BoolType();

        private InstanceKeeper() {
        }
    }
}

