/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Toplevel;

public abstract class Body
extends AbstractAST {
    public Body(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasToplevels() {
        return false;
    }

    public List<Toplevel> getToplevels() {
        throw new UnsupportedOperationException();
    }

    public boolean isToplevels() {
        return false;
    }

    public static class Toplevels
    extends Body {
        private final List<Toplevel> toplevels;

        public Toplevels(ISourceLocation src, IConstructor node, List<Toplevel> toplevels) {
            super(src, node);
            this.toplevels = toplevels;
        }

        @Override
        public boolean isToplevels() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitBodyToplevels(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.toplevels) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Toplevels)) {
                return false;
            }
            Toplevels tmp = (Toplevels)o;
            return tmp.toplevels.equals(this.toplevels);
        }

        @Override
        public int hashCode() {
            return 743 + 137 * this.toplevels.hashCode();
        }

        @Override
        public List<Toplevel> getToplevels() {
            return this.toplevels;
        }

        @Override
        public boolean hasToplevels() {
            return true;
        }

        @Override
        public Object clone() {
            return Toplevels.newInstance(this.getClass(), this.src, null, this.clone(this.toplevels));
        }
    }
}

