/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Statement;

public abstract class Catch
extends AbstractAST {
    public Catch(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasPattern() {
        return false;
    }

    public Expression getPattern() {
        throw new UnsupportedOperationException();
    }

    public boolean hasBody() {
        return false;
    }

    public Statement getBody() {
        throw new UnsupportedOperationException();
    }

    public boolean isBinding() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends Catch {
        private final Statement body;

        public Default(ISourceLocation src, IConstructor node, Statement body) {
            super(src, node);
            this.body = body;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCatchDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.body.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.body.equals(this.body);
        }

        @Override
        public int hashCode() {
            return 757 + 443 * this.body.hashCode();
        }

        @Override
        public Statement getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.body));
        }
    }

    public static class Binding
    extends Catch {
        private final Expression pattern;
        private final Statement body;

        public Binding(ISourceLocation src, IConstructor node, Expression pattern, Statement body) {
            super(src, node);
            this.pattern = pattern;
            this.body = body;
        }

        @Override
        public boolean isBinding() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCatchBinding(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.pattern.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.pattern.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.body.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.body.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Binding)) {
                return false;
            }
            Binding tmp = (Binding)o;
            return tmp.pattern.equals(this.pattern) && tmp.body.equals(this.body);
        }

        @Override
        public int hashCode() {
            return 499 + 113 * this.pattern.hashCode() + 601 * this.body.hashCode();
        }

        @Override
        public Expression getPattern() {
            return this.pattern;
        }

        @Override
        public boolean hasPattern() {
            return true;
        }

        @Override
        public Statement getBody() {
            return this.body;
        }

        @Override
        public boolean hasBody() {
            return true;
        }

        @Override
        public Object clone() {
            return Binding.newInstance(this.getClass(), this.src, null, this.clone(this.pattern), this.clone(this.body));
        }
    }
}

