/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.KeywordFormal;

public abstract class CommonKeywordParameters
extends AbstractAST {
    public CommonKeywordParameters(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasKeywordFormalList() {
        return false;
    }

    public List<KeywordFormal> getKeywordFormalList() {
        throw new UnsupportedOperationException();
    }

    public boolean isAbsent() {
        return false;
    }

    public boolean isPresent() {
        return false;
    }

    public static class Present
    extends CommonKeywordParameters {
        private final List<KeywordFormal> keywordFormalList;

        public Present(ISourceLocation src, IConstructor node, List<KeywordFormal> keywordFormalList) {
            super(src, node);
            this.keywordFormalList = keywordFormalList;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCommonKeywordParametersPresent(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.keywordFormalList) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Present)) {
                return false;
            }
            Present tmp = (Present)o;
            return tmp.keywordFormalList.equals(this.keywordFormalList);
        }

        @Override
        public int hashCode() {
            return 443 + 503 * this.keywordFormalList.hashCode();
        }

        @Override
        public List<KeywordFormal> getKeywordFormalList() {
            return this.keywordFormalList;
        }

        @Override
        public boolean hasKeywordFormalList() {
            return true;
        }

        @Override
        public Object clone() {
            return Present.newInstance(this.getClass(), this.src, null, this.clone(this.keywordFormalList));
        }
    }

    public static class Absent
    extends CommonKeywordParameters {
        public Absent(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isAbsent() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitCommonKeywordParametersAbsent(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Absent)) {
                return false;
            }
            Absent tmp = (Absent)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 157;
        }

        @Override
        public Object clone() {
            return Absent.newInstance(this.getClass(), this.src, null);
        }
    }
}

