/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Type;
import org.rascalmpl.ast.TypeArg;

public abstract class FunctionType
extends AbstractAST {
    public FunctionType(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasArguments() {
        return false;
    }

    public List<TypeArg> getArguments() {
        throw new UnsupportedOperationException();
    }

    public boolean hasType() {
        return false;
    }

    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public boolean isTypeArguments() {
        return false;
    }

    public static class TypeArguments
    extends FunctionType {
        private final Type type;
        private final List<TypeArg> arguments;

        public TypeArguments(ISourceLocation src, IConstructor node, Type type, List<TypeArg> arguments) {
            super(src, node);
            this.type = type;
            this.arguments = arguments;
        }

        @Override
        public boolean isTypeArguments() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitFunctionTypeTypeArguments(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.type.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.type.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.arguments) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof TypeArguments)) {
                return false;
            }
            TypeArguments tmp = (TypeArguments)o;
            return tmp.type.equals(this.type) && tmp.arguments.equals(this.arguments);
        }

        @Override
        public int hashCode() {
            return 599 + 281 * this.type.hashCode() + 43 * this.arguments.hashCode();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean hasType() {
            return true;
        }

        @Override
        public List<TypeArg> getArguments() {
            return this.arguments;
        }

        @Override
        public boolean hasArguments() {
            return true;
        }

        @Override
        public Object clone() {
            return TypeArguments.newInstance(this.getClass(), this.src, null, this.clone(this.type), this.clone(this.arguments));
        }
    }
}

