/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Formals;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.KeywordFormals;

public abstract class Parameters
extends AbstractAST {
    public Parameters(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasFormals() {
        return false;
    }

    public Formals getFormals() {
        throw new UnsupportedOperationException();
    }

    public boolean hasKeywordFormals() {
        return false;
    }

    public KeywordFormals getKeywordFormals() {
        throw new UnsupportedOperationException();
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isVarArgs() {
        return false;
    }

    public static class VarArgs
    extends Parameters {
        private final Formals formals;
        private final KeywordFormals keywordFormals;

        public VarArgs(ISourceLocation src, IConstructor node, Formals formals, KeywordFormals keywordFormals) {
            super(src, node);
            this.formals = formals;
            this.keywordFormals = keywordFormals;
        }

        @Override
        public boolean isVarArgs() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitParametersVarArgs(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.formals.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.formals.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.keywordFormals.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.keywordFormals.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof VarArgs)) {
                return false;
            }
            VarArgs tmp = (VarArgs)o;
            return tmp.formals.equals(this.formals) && tmp.keywordFormals.equals(this.keywordFormals);
        }

        @Override
        public int hashCode() {
            return 31 + 13 * this.formals.hashCode() + 857 * this.keywordFormals.hashCode();
        }

        @Override
        public Formals getFormals() {
            return this.formals;
        }

        @Override
        public boolean hasFormals() {
            return true;
        }

        @Override
        public KeywordFormals getKeywordFormals() {
            return this.keywordFormals;
        }

        @Override
        public boolean hasKeywordFormals() {
            return true;
        }

        @Override
        public Object clone() {
            return VarArgs.newInstance(this.getClass(), this.src, null, this.clone(this.formals), this.clone(this.keywordFormals));
        }
    }

    public static class Default
    extends Parameters {
        private final Formals formals;
        private final KeywordFormals keywordFormals;

        public Default(ISourceLocation src, IConstructor node, Formals formals, KeywordFormals keywordFormals) {
            super(src, node);
            this.formals = formals;
            this.keywordFormals = keywordFormals;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitParametersDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.formals.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.formals.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.keywordFormals.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.keywordFormals.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.formals.equals(this.formals) && tmp.keywordFormals.equals(this.keywordFormals);
        }

        @Override
        public int hashCode() {
            return 829 + 809 * this.formals.hashCode() + 157 * this.keywordFormals.hashCode();
        }

        @Override
        public Formals getFormals() {
            return this.formals;
        }

        @Override
        public boolean hasFormals() {
            return true;
        }

        @Override
        public KeywordFormals getKeywordFormals() {
            return this.keywordFormals;
        }

        @Override
        public boolean hasKeywordFormals() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.formals), this.clone(this.keywordFormals));
        }
    }
}

