/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.CaseInsensitiveStringConstant;
import org.rascalmpl.ast.Class;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.IntegerLiteral;
import org.rascalmpl.ast.NonterminalLabel;
import org.rascalmpl.ast.StringConstant;

public abstract class Sym
extends AbstractAST {
    public Sym(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasAlternatives() {
        return false;
    }

    public List<Sym> getAlternatives() {
        throw new UnsupportedOperationException();
    }

    public boolean hasParameters() {
        return false;
    }

    public List<Sym> getParameters() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSequence() {
        return false;
    }

    public List<Sym> getSequence() {
        throw new UnsupportedOperationException();
    }

    public boolean hasCistring() {
        return false;
    }

    public CaseInsensitiveStringConstant getCistring() {
        throw new UnsupportedOperationException();
    }

    public boolean hasCharClass() {
        return false;
    }

    public Class getCharClass() {
        throw new UnsupportedOperationException();
    }

    public boolean hasColumn() {
        return false;
    }

    public IntegerLiteral getColumn() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNonterminal() {
        return false;
    }

    public org.rascalmpl.ast.Nonterminal getNonterminal() {
        throw new UnsupportedOperationException();
    }

    public boolean hasLabel() {
        return false;
    }

    public NonterminalLabel getLabel() {
        throw new UnsupportedOperationException();
    }

    public boolean hasString() {
        return false;
    }

    public StringConstant getString() {
        throw new UnsupportedOperationException();
    }

    public boolean hasFirst() {
        return false;
    }

    public Sym getFirst() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMatch() {
        return false;
    }

    public Sym getMatch() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSep() {
        return false;
    }

    public Sym getSep() {
        throw new UnsupportedOperationException();
    }

    public boolean hasSymbol() {
        return false;
    }

    public Sym getSymbol() {
        throw new UnsupportedOperationException();
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isCaseInsensitiveLiteral() {
        return false;
    }

    public boolean isCharacterClass() {
        return false;
    }

    public boolean isColumn() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isEndOfLine() {
        return false;
    }

    public boolean isExcept() {
        return false;
    }

    public boolean isFollow() {
        return false;
    }

    public boolean isIter() {
        return false;
    }

    public boolean isIterSep() {
        return false;
    }

    public boolean isIterStar() {
        return false;
    }

    public boolean isIterStarSep() {
        return false;
    }

    public boolean isLabeled() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isNonterminal() {
        return false;
    }

    public boolean isNotFollow() {
        return false;
    }

    public boolean isNotPrecede() {
        return false;
    }

    public boolean isOptional() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public boolean isParametrized() {
        return false;
    }

    public boolean isPrecede() {
        return false;
    }

    public boolean isSequence() {
        return false;
    }

    public boolean isStart() {
        return false;
    }

    public boolean isStartOfLine() {
        return false;
    }

    public boolean isUnequal() {
        return false;
    }

    public static class Unequal
    extends Sym {
        private final Sym symbol;
        private final Sym match;

        public Unequal(ISourceLocation src, IConstructor node, Sym symbol, Sym match) {
            super(src, node);
            this.symbol = symbol;
            this.match = match;
        }

        @Override
        public boolean isUnequal() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymUnequal(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.match.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.match.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Unequal)) {
                return false;
            }
            Unequal tmp = (Unequal)o;
            return tmp.symbol.equals(this.symbol) && tmp.match.equals(this.match);
        }

        @Override
        public int hashCode() {
            return 61 + 241 * this.symbol.hashCode() + 409 * this.match.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Sym getMatch() {
            return this.match;
        }

        @Override
        public boolean hasMatch() {
            return true;
        }

        @Override
        public Object clone() {
            return Unequal.newInstance(this.getClass(), this.src, null, this.clone(this.symbol), this.clone(this.match));
        }
    }

    public static class StartOfLine
    extends Sym {
        private final Sym symbol;

        public StartOfLine(ISourceLocation src, IConstructor node, Sym symbol) {
            super(src, node);
            this.symbol = symbol;
        }

        @Override
        public boolean isStartOfLine() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymStartOfLine(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof StartOfLine)) {
                return false;
            }
            StartOfLine tmp = (StartOfLine)o;
            return tmp.symbol.equals(this.symbol);
        }

        @Override
        public int hashCode() {
            return 263 + 19 * this.symbol.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Object clone() {
            return StartOfLine.newInstance(this.getClass(), this.src, null, this.clone(this.symbol));
        }
    }

    public static class Start
    extends Sym {
        private final org.rascalmpl.ast.Nonterminal nonterminal;

        public Start(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Nonterminal nonterminal) {
            super(src, node);
            this.nonterminal = nonterminal;
        }

        @Override
        public boolean isStart() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymStart(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.nonterminal.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.nonterminal.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Start)) {
                return false;
            }
            Start tmp = (Start)o;
            return tmp.nonterminal.equals(this.nonterminal);
        }

        @Override
        public int hashCode() {
            return 61 + 281 * this.nonterminal.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Nonterminal getNonterminal() {
            return this.nonterminal;
        }

        @Override
        public boolean hasNonterminal() {
            return true;
        }

        @Override
        public Object clone() {
            return Start.newInstance(this.getClass(), this.src, null, this.clone(this.nonterminal));
        }
    }

    public static class Sequence
    extends Sym {
        private final Sym first;
        private final List<Sym> sequence;

        public Sequence(ISourceLocation src, IConstructor node, Sym first, List<Sym> sequence) {
            super(src, node);
            this.first = first;
            this.sequence = sequence;
        }

        @Override
        public boolean isSequence() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymSequence(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.first.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.first.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.sequence) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Sequence)) {
                return false;
            }
            Sequence tmp = (Sequence)o;
            return tmp.first.equals(this.first) && tmp.sequence.equals(this.sequence);
        }

        @Override
        public int hashCode() {
            return 787 + 863 * this.first.hashCode() + 557 * this.sequence.hashCode();
        }

        @Override
        public Sym getFirst() {
            return this.first;
        }

        @Override
        public boolean hasFirst() {
            return true;
        }

        @Override
        public List<Sym> getSequence() {
            return this.sequence;
        }

        @Override
        public boolean hasSequence() {
            return true;
        }

        @Override
        public Object clone() {
            return Sequence.newInstance(this.getClass(), this.src, null, this.clone(this.first), this.clone(this.sequence));
        }
    }

    public static class Precede
    extends Sym {
        private final Sym match;
        private final Sym symbol;

        public Precede(ISourceLocation src, IConstructor node, Sym match, Sym symbol) {
            super(src, node);
            this.match = match;
            this.symbol = symbol;
        }

        @Override
        public boolean isPrecede() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymPrecede(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.match.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.match.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.symbol.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Precede)) {
                return false;
            }
            Precede tmp = (Precede)o;
            return tmp.match.equals(this.match) && tmp.symbol.equals(this.symbol);
        }

        @Override
        public int hashCode() {
            return 541 + 353 * this.match.hashCode() + 23 * this.symbol.hashCode();
        }

        @Override
        public Sym getMatch() {
            return this.match;
        }

        @Override
        public boolean hasMatch() {
            return true;
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Object clone() {
            return Precede.newInstance(this.getClass(), this.src, null, this.clone(this.match), this.clone(this.symbol));
        }
    }

    public static class Parametrized
    extends Sym {
        private final org.rascalmpl.ast.Nonterminal nonterminal;
        private final List<Sym> parameters;

        public Parametrized(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Nonterminal nonterminal, List<Sym> parameters) {
            super(src, node);
            this.nonterminal = nonterminal;
            this.parameters = parameters;
        }

        @Override
        public boolean isParametrized() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymParametrized(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.nonterminal.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.nonterminal.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.parameters) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Parametrized)) {
                return false;
            }
            Parametrized tmp = (Parametrized)o;
            return tmp.nonterminal.equals(this.nonterminal) && tmp.parameters.equals(this.parameters);
        }

        @Override
        public int hashCode() {
            return 67 + 769 * this.nonterminal.hashCode() + 149 * this.parameters.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Nonterminal getNonterminal() {
            return this.nonterminal;
        }

        @Override
        public boolean hasNonterminal() {
            return true;
        }

        @Override
        public List<Sym> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean hasParameters() {
            return true;
        }

        @Override
        public Object clone() {
            return Parametrized.newInstance(this.getClass(), this.src, null, this.clone(this.nonterminal), this.clone(this.parameters));
        }
    }

    public static class Parameter
    extends Sym {
        private final org.rascalmpl.ast.Nonterminal nonterminal;

        public Parameter(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Nonterminal nonterminal) {
            super(src, node);
            this.nonterminal = nonterminal;
        }

        @Override
        public boolean isParameter() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymParameter(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.nonterminal.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.nonterminal.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter tmp = (Parameter)o;
            return tmp.nonterminal.equals(this.nonterminal);
        }

        @Override
        public int hashCode() {
            return 941 + 103 * this.nonterminal.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Nonterminal getNonterminal() {
            return this.nonterminal;
        }

        @Override
        public boolean hasNonterminal() {
            return true;
        }

        @Override
        public Object clone() {
            return Parameter.newInstance(this.getClass(), this.src, null, this.clone(this.nonterminal));
        }
    }

    public static class Optional
    extends Sym {
        private final Sym symbol;

        public Optional(ISourceLocation src, IConstructor node, Sym symbol) {
            super(src, node);
            this.symbol = symbol;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymOptional(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Optional)) {
                return false;
            }
            Optional tmp = (Optional)o;
            return tmp.symbol.equals(this.symbol);
        }

        @Override
        public int hashCode() {
            return 599 + 29 * this.symbol.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Object clone() {
            return Optional.newInstance(this.getClass(), this.src, null, this.clone(this.symbol));
        }
    }

    public static class NotPrecede
    extends Sym {
        private final Sym match;
        private final Sym symbol;

        public NotPrecede(ISourceLocation src, IConstructor node, Sym match, Sym symbol) {
            super(src, node);
            this.match = match;
            this.symbol = symbol;
        }

        @Override
        public boolean isNotPrecede() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymNotPrecede(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.match.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.match.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.symbol.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NotPrecede)) {
                return false;
            }
            NotPrecede tmp = (NotPrecede)o;
            return tmp.match.equals(this.match) && tmp.symbol.equals(this.symbol);
        }

        @Override
        public int hashCode() {
            return 347 + 509 * this.match.hashCode() + 151 * this.symbol.hashCode();
        }

        @Override
        public Sym getMatch() {
            return this.match;
        }

        @Override
        public boolean hasMatch() {
            return true;
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Object clone() {
            return NotPrecede.newInstance(this.getClass(), this.src, null, this.clone(this.match), this.clone(this.symbol));
        }
    }

    public static class NotFollow
    extends Sym {
        private final Sym symbol;
        private final Sym match;

        public NotFollow(ISourceLocation src, IConstructor node, Sym symbol, Sym match) {
            super(src, node);
            this.symbol = symbol;
            this.match = match;
        }

        @Override
        public boolean isNotFollow() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymNotFollow(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.match.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.match.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NotFollow)) {
                return false;
            }
            NotFollow tmp = (NotFollow)o;
            return tmp.symbol.equals(this.symbol) && tmp.match.equals(this.match);
        }

        @Override
        public int hashCode() {
            return 409 + 907 * this.symbol.hashCode() + 89 * this.match.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Sym getMatch() {
            return this.match;
        }

        @Override
        public boolean hasMatch() {
            return true;
        }

        @Override
        public Object clone() {
            return NotFollow.newInstance(this.getClass(), this.src, null, this.clone(this.symbol), this.clone(this.match));
        }
    }

    public static class Nonterminal
    extends Sym {
        private final org.rascalmpl.ast.Nonterminal nonterminal;

        public Nonterminal(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Nonterminal nonterminal) {
            super(src, node);
            this.nonterminal = nonterminal;
        }

        @Override
        public boolean isNonterminal() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymNonterminal(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.nonterminal.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.nonterminal.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Nonterminal)) {
                return false;
            }
            Nonterminal tmp = (Nonterminal)o;
            return tmp.nonterminal.equals(this.nonterminal);
        }

        @Override
        public int hashCode() {
            return 647 + 991 * this.nonterminal.hashCode();
        }

        @Override
        public org.rascalmpl.ast.Nonterminal getNonterminal() {
            return this.nonterminal;
        }

        @Override
        public boolean hasNonterminal() {
            return true;
        }

        @Override
        public Object clone() {
            return Nonterminal.newInstance(this.getClass(), this.src, null, this.clone(this.nonterminal));
        }
    }

    public static class Literal
    extends Sym {
        private final StringConstant string;

        public Literal(ISourceLocation src, IConstructor node, StringConstant string) {
            super(src, node);
            this.string = string;
        }

        @Override
        public boolean isLiteral() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymLiteral(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.string.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.string.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal tmp = (Literal)o;
            return tmp.string.equals(this.string);
        }

        @Override
        public int hashCode() {
            return 577 + 263 * this.string.hashCode();
        }

        @Override
        public StringConstant getString() {
            return this.string;
        }

        @Override
        public boolean hasString() {
            return true;
        }

        @Override
        public Object clone() {
            return Literal.newInstance(this.getClass(), this.src, null, this.clone(this.string));
        }
    }

    public static class Labeled
    extends Sym {
        private final Sym symbol;
        private final NonterminalLabel label;

        public Labeled(ISourceLocation src, IConstructor node, Sym symbol, NonterminalLabel label) {
            super(src, node);
            this.symbol = symbol;
            this.label = label;
        }

        @Override
        public boolean isLabeled() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymLabeled(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.label.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Labeled)) {
                return false;
            }
            Labeled tmp = (Labeled)o;
            return tmp.symbol.equals(this.symbol) && tmp.label.equals(this.label);
        }

        @Override
        public int hashCode() {
            return 587 + 67 * this.symbol.hashCode() + 191 * this.label.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public NonterminalLabel getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public Object clone() {
            return Labeled.newInstance(this.getClass(), this.src, null, this.clone(this.symbol), this.clone(this.label));
        }
    }

    public static class IterStarSep
    extends Sym {
        private final Sym symbol;
        private final Sym sep;

        public IterStarSep(ISourceLocation src, IConstructor node, Sym symbol, Sym sep) {
            super(src, node);
            this.symbol = symbol;
            this.sep = sep;
        }

        @Override
        public boolean isIterStarSep() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymIterStarSep(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.sep.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.sep.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof IterStarSep)) {
                return false;
            }
            IterStarSep tmp = (IterStarSep)o;
            return tmp.symbol.equals(this.symbol) && tmp.sep.equals(this.sep);
        }

        @Override
        public int hashCode() {
            return 19 + 761 * this.symbol.hashCode() + 89 * this.sep.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Sym getSep() {
            return this.sep;
        }

        @Override
        public boolean hasSep() {
            return true;
        }

        @Override
        public Object clone() {
            return IterStarSep.newInstance(this.getClass(), this.src, null, this.clone(this.symbol), this.clone(this.sep));
        }
    }

    public static class IterStar
    extends Sym {
        private final Sym symbol;

        public IterStar(ISourceLocation src, IConstructor node, Sym symbol) {
            super(src, node);
            this.symbol = symbol;
        }

        @Override
        public boolean isIterStar() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymIterStar(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof IterStar)) {
                return false;
            }
            IterStar tmp = (IterStar)o;
            return tmp.symbol.equals(this.symbol);
        }

        @Override
        public int hashCode() {
            return 467 + 149 * this.symbol.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Object clone() {
            return IterStar.newInstance(this.getClass(), this.src, null, this.clone(this.symbol));
        }
    }

    public static class IterSep
    extends Sym {
        private final Sym symbol;
        private final Sym sep;

        public IterSep(ISourceLocation src, IConstructor node, Sym symbol, Sym sep) {
            super(src, node);
            this.symbol = symbol;
            this.sep = sep;
        }

        @Override
        public boolean isIterSep() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymIterSep(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.sep.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.sep.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof IterSep)) {
                return false;
            }
            IterSep tmp = (IterSep)o;
            return tmp.symbol.equals(this.symbol) && tmp.sep.equals(this.sep);
        }

        @Override
        public int hashCode() {
            return 619 + 5 * this.symbol.hashCode() + 191 * this.sep.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Sym getSep() {
            return this.sep;
        }

        @Override
        public boolean hasSep() {
            return true;
        }

        @Override
        public Object clone() {
            return IterSep.newInstance(this.getClass(), this.src, null, this.clone(this.symbol), this.clone(this.sep));
        }
    }

    public static class Iter
    extends Sym {
        private final Sym symbol;

        public Iter(ISourceLocation src, IConstructor node, Sym symbol) {
            super(src, node);
            this.symbol = symbol;
        }

        @Override
        public boolean isIter() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymIter(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Iter)) {
                return false;
            }
            Iter tmp = (Iter)o;
            return tmp.symbol.equals(this.symbol);
        }

        @Override
        public int hashCode() {
            return 311 + 73 * this.symbol.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Object clone() {
            return Iter.newInstance(this.getClass(), this.src, null, this.clone(this.symbol));
        }
    }

    public static class Follow
    extends Sym {
        private final Sym symbol;
        private final Sym match;

        public Follow(ISourceLocation src, IConstructor node, Sym symbol, Sym match) {
            super(src, node);
            this.symbol = symbol;
            this.match = match;
        }

        @Override
        public boolean isFollow() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymFollow(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.match.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.match.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Follow)) {
                return false;
            }
            Follow tmp = (Follow)o;
            return tmp.symbol.equals(this.symbol) && tmp.match.equals(this.match);
        }

        @Override
        public int hashCode() {
            return 331 + 359 * this.symbol.hashCode() + 151 * this.match.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Sym getMatch() {
            return this.match;
        }

        @Override
        public boolean hasMatch() {
            return true;
        }

        @Override
        public Object clone() {
            return Follow.newInstance(this.getClass(), this.src, null, this.clone(this.symbol), this.clone(this.match));
        }
    }

    public static class Except
    extends Sym {
        private final Sym symbol;
        private final NonterminalLabel label;

        public Except(ISourceLocation src, IConstructor node, Sym symbol, NonterminalLabel label) {
            super(src, node);
            this.symbol = symbol;
            this.label = label;
        }

        @Override
        public boolean isExcept() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymExcept(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.label.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.label.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Except)) {
                return false;
            }
            Except tmp = (Except)o;
            return tmp.symbol.equals(this.symbol) && tmp.label.equals(this.label);
        }

        @Override
        public int hashCode() {
            return 59 + 139 * this.symbol.hashCode() + 233 * this.label.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public NonterminalLabel getLabel() {
            return this.label;
        }

        @Override
        public boolean hasLabel() {
            return true;
        }

        @Override
        public Object clone() {
            return Except.newInstance(this.getClass(), this.src, null, this.clone(this.symbol), this.clone(this.label));
        }
    }

    public static class EndOfLine
    extends Sym {
        private final Sym symbol;

        public EndOfLine(ISourceLocation src, IConstructor node, Sym symbol) {
            super(src, node);
            this.symbol = symbol;
        }

        @Override
        public boolean isEndOfLine() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymEndOfLine(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof EndOfLine)) {
                return false;
            }
            EndOfLine tmp = (EndOfLine)o;
            return tmp.symbol.equals(this.symbol);
        }

        @Override
        public int hashCode() {
            return 821 + 821 * this.symbol.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public Object clone() {
            return EndOfLine.newInstance(this.getClass(), this.src, null, this.clone(this.symbol));
        }
    }

    public static class Empty
    extends Sym {
        public Empty(ISourceLocation src, IConstructor node) {
            super(src, node);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymEmpty(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty tmp = (Empty)o;
            return true;
        }

        @Override
        public int hashCode() {
            return 809;
        }

        @Override
        public Object clone() {
            return Empty.newInstance(this.getClass(), this.src, null);
        }
    }

    public static class Column
    extends Sym {
        private final Sym symbol;
        private final IntegerLiteral column;

        public Column(ISourceLocation src, IConstructor node, Sym symbol, IntegerLiteral column) {
            super(src, node);
            this.symbol = symbol;
            this.column = column;
        }

        @Override
        public boolean isColumn() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymColumn(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.symbol.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.symbol.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            $l = this.column.getLocation();
            if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.column.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Column)) {
                return false;
            }
            Column tmp = (Column)o;
            return tmp.symbol.equals(this.symbol) && tmp.column.equals(this.column);
        }

        @Override
        public int hashCode() {
            return 839 + 577 * this.symbol.hashCode() + 41 * this.column.hashCode();
        }

        @Override
        public Sym getSymbol() {
            return this.symbol;
        }

        @Override
        public boolean hasSymbol() {
            return true;
        }

        @Override
        public IntegerLiteral getColumn() {
            return this.column;
        }

        @Override
        public boolean hasColumn() {
            return true;
        }

        @Override
        public Object clone() {
            return Column.newInstance(this.getClass(), this.src, null, this.clone(this.symbol), this.clone(this.column));
        }
    }

    public static class CharacterClass
    extends Sym {
        private final Class charClass;

        public CharacterClass(ISourceLocation src, IConstructor node, Class charClass) {
            super(src, node);
            this.charClass = charClass;
        }

        @Override
        public boolean isCharacterClass() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymCharacterClass(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.charClass.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.charClass.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof CharacterClass)) {
                return false;
            }
            CharacterClass tmp = (CharacterClass)o;
            return tmp.charClass.equals(this.charClass);
        }

        @Override
        public int hashCode() {
            return 71 + 683 * this.charClass.hashCode();
        }

        @Override
        public Class getCharClass() {
            return this.charClass;
        }

        @Override
        public boolean hasCharClass() {
            return true;
        }

        @Override
        public Object clone() {
            return CharacterClass.newInstance(this.getClass(), this.src, null, this.clone(this.charClass));
        }
    }

    public static class CaseInsensitiveLiteral
    extends Sym {
        private final CaseInsensitiveStringConstant cistring;

        public CaseInsensitiveLiteral(ISourceLocation src, IConstructor node, CaseInsensitiveStringConstant cistring) {
            super(src, node);
            this.cistring = cistring;
        }

        @Override
        public boolean isCaseInsensitiveLiteral() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymCaseInsensitiveLiteral(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.cistring.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.cistring.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof CaseInsensitiveLiteral)) {
                return false;
            }
            CaseInsensitiveLiteral tmp = (CaseInsensitiveLiteral)o;
            return tmp.cistring.equals(this.cistring);
        }

        @Override
        public int hashCode() {
            return 373 + 83 * this.cistring.hashCode();
        }

        @Override
        public CaseInsensitiveStringConstant getCistring() {
            return this.cistring;
        }

        @Override
        public boolean hasCistring() {
            return true;
        }

        @Override
        public Object clone() {
            return CaseInsensitiveLiteral.newInstance(this.getClass(), this.src, null, this.clone(this.cistring));
        }
    }

    public static class Alternative
    extends Sym {
        private final Sym first;
        private final List<Sym> alternatives;

        public Alternative(ISourceLocation src, IConstructor node, Sym first, List<Sym> alternatives) {
            super(src, node);
            this.first = first;
            this.alternatives = alternatives;
        }

        @Override
        public boolean isAlternative() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitSymAlternative(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            ISourceLocation $l;
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            if (($l = this.first.getLocation()).hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                this.first.addForLineNumber($line, $result);
            }
            if ($l.getBeginLine() > $line) {
                return;
            }
            for (AbstractAST abstractAST : this.alternatives) {
                $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Alternative)) {
                return false;
            }
            Alternative tmp = (Alternative)o;
            return tmp.first.equals(this.first) && tmp.alternatives.equals(this.alternatives);
        }

        @Override
        public int hashCode() {
            return 911 + 379 * this.first.hashCode() + 811 * this.alternatives.hashCode();
        }

        @Override
        public Sym getFirst() {
            return this.first;
        }

        @Override
        public boolean hasFirst() {
            return true;
        }

        @Override
        public List<Sym> getAlternatives() {
            return this.alternatives;
        }

        @Override
        public boolean hasAlternatives() {
            return true;
        }

        @Override
        public Object clone() {
            return Alternative.newInstance(this.getClass(), this.src, null, this.clone(this.first), this.clone(this.alternatives));
        }
    }
}

