/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.exceptions;

import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.net.URISyntaxException;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.JavaCompilation;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.values.ValueFactoryFactory;

public class RuntimeExceptionFactory {
    private static TypeFactory TF = TypeFactory.getInstance();
    private static IValueFactory VF = ValueFactoryFactory.getValueFactory();
    public static final TypeStore TS = new TypeStore(new TypeStore[0]);
    public static final Type Exception = TF.abstractDataType(TS, "RuntimeException", new Type[0]);
    public static final Type Ambiguity = TF.constructor(TS, Exception, "Ambiguity", TF.sourceLocationType(), "location", TF.stringType(), "nonterminal", TF.stringType(), "sentence");
    public static final Type ArithmeticException = TF.constructor(TS, Exception, "ArithmeticException", TF.stringType(), "message");
    public static final Type ArityMismatch = TF.constructor(TS, Exception, "ArityMismatch", TF.integerType(), "expectedArity", TF.integerType(), "gotArity");
    public static final Type AssertionFailed = TF.constructor(TS, Exception, "AssertionFailed", new Type[0]);
    public static final Type LabeledAssertionFailed = TF.constructor(TS, Exception, "AssertionFailed", TF.stringType(), "label");
    public static final Type DateTimeParsingError = TF.constructor(TS, Exception, "DateTimeParsingError", TF.stringType(), "message");
    public static final Type DateTimePrintingError = TF.constructor(TS, Exception, "DateTimePrintingError", TF.stringType(), "message");
    public static final Type EmptyList = TF.constructor(TS, Exception, "EmptyList", new Type[0]);
    public static final Type EmptyMap = TF.constructor(TS, Exception, "EmptyMap", new Type[0]);
    public static final Type CallFailed = TF.constructor(TS, Exception, "CallFailed", TF.listType(TF.valueType()), "arguments");
    public static final Type EmptySet = TF.constructor(TS, Exception, "EmptySet", new Type[0]);
    public static final Type Figure = TF.constructor(TS, Exception, "Figure", TF.stringType(), "message", TF.valueType(), "figure");
    public static final Type IllegalArgument = TF.constructor(TS, Exception, "IllegalArgument", TF.valueType(), "v", TF.stringType(), "message");
    public static final Type AnonymousIllegalArgument = TF.constructor(TS, Exception, "IllegalArgument", new Type[0]);
    public static final Type IllegalTypeArgument = TF.constructor(TS, Exception, "IllegalTypeArgument", TF.stringType(), "type", TF.stringType(), "message");
    public static final Type ImplodeError = TF.constructor(TS, Exception, "ImplodeError", TF.stringType(), "message");
    public static final Type IndexOutOfBounds = TF.constructor(TS, Exception, "IndexOutOfBounds", TF.integerType(), "index");
    public static final Type InvalidUseOfDate = TF.constructor(TS, Exception, "InvalidUseOfDate", TF.dateTimeType(), "msg");
    public static final Type InvalidUseOfDateTime = TF.constructor(TS, Exception, "InvalidUseOfDateTime", TF.dateTimeType(), "msg");
    public static final Type InvalidUseOfLocation = TF.constructor(TS, Exception, "InvalidUseOfLocation", TF.stringType(), "message");
    public static final Type InvalidUseOfTime = TF.constructor(TS, Exception, "InvalidUseOfTime", TF.dateTimeType(), "msg");
    public static final Type IO = TF.constructor(TS, Exception, "IO", TF.stringType(), "message");
    public static final Type Java = TF.constructor(TS, Exception, "Java", TF.stringType(), "class", TF.stringType(), "message");
    public static final Type JavaCompilation = TF.constructor(TS, Exception, "JavaCompilation", TF.stringType(), "message", TF.integerType(), "line", TF.integerType(), "column", TF.stringType(), "source", TF.listType(TF.sourceLocationType()), "classpath");
    public static final Type JavaWithCause = TF.constructor(TS, Exception, "Java", TF.stringType(), "class", TF.stringType(), "message", Exception, "cause");
    public static final Type MalFormedURI = TF.constructor(TS, Exception, "MalFormedURI", TF.stringType(), "malFormedUri");
    public static final Type ModuleNotFound = TF.constructor(TS, Exception, "ModuleNotFound", TF.stringType(), "name");
    public static final Type MultipleKey = TF.constructor(TS, Exception, "MultipleKey", TF.valueType(), "key", TF.valueType(), "first", TF.valueType(), "second");
    public static final Type NoSuchAnnotation = TF.constructor(TS, Exception, "NoSuchAnnotation", TF.stringType(), "label");
    public static final Type NoSuchElement = TF.constructor(TS, Exception, "NoSuchElement", TF.valueType(), "v");
    public static final Type NoSuchField = TF.constructor(TS, Exception, "NoSuchField", TF.stringType(), "name");
    public static final Type NoSuchKey = TF.constructor(TS, Exception, "NoSuchKey", TF.valueType(), "key");
    public static final Type ParseError = TF.constructor(TS, Exception, "ParseError", TF.sourceLocationType(), "location");
    public static final Type PathNotFound = TF.constructor(TS, Exception, "PathNotFound", TF.sourceLocationType(), "location");
    public static final Type PermissionDenied = TF.constructor(TS, Exception, "PermissionDenied", TF.stringType(), "message");
    public static final Type AnonymousPermissionDenied = TF.constructor(TS, Exception, "PermissionDenied", new Type[0]);
    public static final Type RegExpSyntaxError = TF.constructor(TS, Exception, "RegExpSyntaxError", TF.stringType(), "message");
    public static final Type SchemeNotSupported = TF.constructor(TS, Exception, "SchemeNotSupported", TF.sourceLocationType(), "location");
    public static final Type NoParent = TF.constructor(TS, Exception, "NoParent", TF.sourceLocationType(), "noParentUri");
    public static final Type NameMismatch = TF.constructor(TS, Exception, "NameMismatch", TF.stringType(), "expectedName", TF.stringType(), "gotName");
    public static final Type Timeout = TF.constructor(TS, Exception, "Timeout", new Type[0]);
    public static final Type StackOverflow = TF.constructor(TS, Exception, "StackOverflow", new Type[0]);
    public static final Type UnavailableInformation = TF.constructor(TS, Exception, "UnavailableInformation", new Type[0]);

    public static Throw ambiguity(ISourceLocation loc, IString type, IString string) {
        return new Throw(VF.constructor(Ambiguity, loc, type, string));
    }

    public static Throw ambiguity(ISourceLocation loc, IString type, IString string, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(Ambiguity, loc, type, string), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw callFailed(IList arguments, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(CallFailed, arguments), ast != null ? (ast != null ? ast.getLocation() : null) : null, trace);
    }

    public static Throw callFailed(IList arguments) {
        return new Throw(VF.constructor(CallFailed, arguments));
    }

    public static Throw arithmeticException(IString msg) {
        return new Throw(VF.constructor(ArithmeticException, msg));
    }

    public static Throw arithmeticException(String msg) {
        return new Throw(VF.constructor(ArithmeticException, VF.string(msg)));
    }

    public static Throw arithmeticException(String msg, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(ArithmeticException, VF.string(msg)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw arityMismatch(IInteger expected, IInteger got) {
        return new Throw(VF.constructor(ArityMismatch, expected, got));
    }

    public static Throw arityMismatch(int expected, int got) {
        return new Throw(VF.constructor(ArityMismatch, VF.integer(expected), VF.integer(got)));
    }

    public static Throw arityMismatch(IInteger expected, IInteger got, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(ArityMismatch, expected, got), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw arityMismatch(int expected, int got, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(ArityMismatch, VF.integer(expected), VF.integer(got)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw assertionFailed() {
        return new Throw(VF.constructor(AssertionFailed));
    }

    public static Throw assertionFailed(AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(AssertionFailed), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw assertionFailed(IString msg) {
        return new Throw(VF.constructor(LabeledAssertionFailed, msg));
    }

    public static Throw assertionFailed(IString msg, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(LabeledAssertionFailed, msg), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw callFailed(ISourceLocation loc, IList arguments) {
        return new Throw(VF.constructor(CallFailed, arguments));
    }

    public static Throw callFailed(ISourceLocation loc, IList arguments, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(CallFailed, arguments), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw dateTimeParsingError(IString message) {
        return new Throw(VF.constructor(DateTimeParsingError, message));
    }

    public static Throw dateTimeParsingError(String message) {
        return new Throw(VF.constructor(DateTimeParsingError, VF.string(message)));
    }

    public static Throw dateTimeParsingError(IString message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(DateTimeParsingError, message), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw dateTimeParsingError(String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(DateTimeParsingError, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw dateTimePrintingError(IString message) {
        return new Throw(VF.constructor(DateTimePrintingError, message));
    }

    public static Throw dateTimePrintingError(String message) {
        return new Throw(VF.constructor(DateTimePrintingError, VF.string(message)));
    }

    public static Throw dateTimePrintingError(IString message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(DateTimePrintingError, message), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw dateTimePrintingError(String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(DateTimePrintingError, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw emptyList() {
        return new Throw(VF.constructor(EmptyList));
    }

    public static Throw emptyList(AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(EmptyList), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw emptyMap() {
        return new Throw(VF.constructor(EmptyMap));
    }

    public static Throw emptyMap(AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(EmptyMap), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw emptySet() {
        return new Throw(VF.constructor(EmptySet));
    }

    public static Throw emptySet(AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(EmptySet), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw figureException(IString message, IValue v) {
        return new Throw(VF.constructor(Figure, message, v));
    }

    public static Throw figureException(IString message, IValue v, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(Figure, message, v), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw figureException(String message, IValue v, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(Figure, VF.string(message), v), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw illegalArgument() {
        return new Throw(VF.constructor(AnonymousIllegalArgument));
    }

    public static Throw illegalArgument(AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(AnonymousIllegalArgument), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw illegalArgument(IValue v) {
        return new Throw(VF.constructor(IllegalArgument, v, VF.string("")));
    }

    public static Throw illegalArgument(IValue v, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(IllegalArgument, v, VF.string("")), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw illegalArgument(IValue v, IString message) {
        return new Throw(VF.constructor(IllegalArgument, v, message));
    }

    public static Throw illegalArgument(IValue v, String message) {
        return new Throw(VF.constructor(IllegalArgument, v, VF.string(message)));
    }

    public static Throw illegalArgument(IValue v, IString message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(IllegalArgument, v, message), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw illegalArgument(IValue v, String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(IllegalArgument, v, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw illegalArgument(IValue v, AbstractAST ast, StackTrace trace, String message) {
        return new Throw(VF.constructor(IllegalArgument, v, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw implodeError(IString msg) {
        return new Throw(VF.constructor(ImplodeError, msg));
    }

    public static Throw implodeError(String msg) {
        return new Throw(VF.constructor(ImplodeError, VF.string(msg)));
    }

    public static Throw implodeError(IString msg, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(ImplodeError, msg), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw implodeError(String msg, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(ImplodeError, VF.string(msg)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw indexOutOfBounds(IInteger i) {
        return new Throw(VF.constructor(IndexOutOfBounds, i));
    }

    public static Throw indexOutOfBounds(IInteger i, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(IndexOutOfBounds, i), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfDate(IString message) {
        return new Throw(VF.constructor(InvalidUseOfDate, message));
    }

    public static Throw invalidUseOfDateException(String message) {
        return new Throw(VF.constructor(InvalidUseOfDate, VF.string(message)));
    }

    public static Throw invalidUseOfDate(String message) {
        return new Throw(VF.constructor(InvalidUseOfDate, VF.string(message)));
    }

    public static Throw invalidUseOfDate(IString message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfDate, message), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfDateException(String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfDate, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfDate(String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfDate, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfDateTime(IString message) {
        return new Throw(VF.constructor(InvalidUseOfDateTime, message));
    }

    public static Throw invalidUseOfDateTimeException(String message) {
        return new Throw(VF.constructor(InvalidUseOfDateTime, VF.string(message)));
    }

    public static Throw invalidUseOfDateTime(String message) {
        return new Throw(VF.constructor(InvalidUseOfDateTime, VF.string(message)));
    }

    public static Throw invalidUseOfDateTime(IString message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfDateTime, message), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfDateTimeException(String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfDateTime, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfDateTime(String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfDateTime, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfLocation(IString msg) {
        return new Throw(VF.constructor(InvalidUseOfLocation, msg));
    }

    public static Throw invalidUseOfLocation(String msg) {
        return new Throw(VF.constructor(InvalidUseOfLocation, VF.string(msg)));
    }

    public static Throw invalidUseOfLocation(IString msg, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfLocation, msg), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfLocation(String msg, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfLocation, VF.string(msg)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfTime(IString message) {
        return new Throw(VF.constructor(InvalidUseOfTime, message));
    }

    public static Throw invalidUseOfTimeException(String message) {
        return new Throw(VF.constructor(InvalidUseOfTime, VF.string(message)));
    }

    public static Throw invalidUseOfTime(String message) {
        return new Throw(VF.constructor(InvalidUseOfTime, VF.string(message)));
    }

    public static Throw invalidUseOfTime(IString message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfTime, message), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfTimeException(String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfTime, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw invalidUseOfTime(String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(InvalidUseOfTime, VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw io(IString msg) {
        return new Throw(VF.constructor(IO, msg));
    }

    public static Throw io(String msg) {
        return new Throw(VF.constructor(IO, VF.string(msg)));
    }

    public static Throw io(IString msg, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(IO, msg), ast != null ? ast.getLocation() : null, trace);
    }

    private static Throw javaException(String clazz, String message, IValue cause, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(JavaWithCause, VF.string(clazz), VF.string(message), cause), ast != null ? ast.getLocation() : null, trace);
    }

    private static Throw javaException(String clazz, String message, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(Java, VF.string(clazz), VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw javaCompilerException(JavaCompilation e) {
        return RuntimeExceptionFactory.javaCompilerException(e, null, null);
    }

    public static Throw javaCompilerException(JavaCompilation e, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(JavaCompilation, VF.string(e.getMessage()), VF.integer(e.getLine()), VF.integer(e.getColumn()), VF.string(e.getSource())), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw javaException(Throwable targetException, AbstractAST ast, StackTrace rascalTrace) throws ImplementationError {
        try {
            String clazz = targetException.getClass().getSimpleName();
            String msg = targetException.getMessage();
            StackTrace trace = RuntimeExceptionFactory.buildTrace(targetException, rascalTrace);
            Throwable cause = targetException.getCause();
            if (cause != null && cause != targetException) {
                Throw throwCause = cause instanceof Throw ? (Throw)cause : RuntimeExceptionFactory.javaException(cause, ast, rascalTrace);
                return RuntimeExceptionFactory.javaException(clazz, msg != null ? msg : "", throwCause.getException(), ast, trace);
            }
            return RuntimeExceptionFactory.javaException(clazz, msg != null ? msg : "", ast, trace);
        }
        catch (IOException e1) {
            throw new ImplementationError("Could not create stack trace", e1);
        }
    }

    private static ISourceLocation robustSourceLocation(String path, int offset, int length, int beginLine, int endLine, int beginCol, int endCol) {
        ISourceLocation locRoot;
        if (path == null) {
            path = "UNKNOWN_FILENAME";
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        try {
            locRoot = VF.sourceLocation("unknown", "", (String)path);
        }
        catch (URISyntaxException e) {
            locRoot = VF.sourceLocation((String)path);
        }
        if (offset < 0) {
            offset = 0;
        }
        if (length < 0) {
            length = 0;
        }
        if (beginLine < 0) {
            beginLine = 0;
        }
        if (beginCol < 0) {
            beginCol = 0;
        }
        if (endCol < 0) {
            endCol = 0;
        }
        if (endLine < beginLine) {
            endLine = beginLine;
        }
        if (endLine == beginLine && endCol < beginCol) {
            endCol = beginCol;
        }
        return VF.sourceLocation(locRoot, offset, length, beginLine, endLine, beginCol, endCol);
    }

    private static StackTrace buildTrace(Throwable targetException, StackTrace rascalTrace) throws IOException {
        StackTraceElement[] stackTrace = targetException.getStackTrace();
        StackTrace newTrace = new StackTrace();
        for (StackTraceElement elem : stackTrace) {
            if (elem.getMethodName().equals("invoke")) break;
            newTrace.add(RuntimeExceptionFactory.robustSourceLocation(elem.getFileName(), 0, 0, elem.getLineNumber(), elem.getLineNumber(), 0, 0), elem.getClassName() + "." + elem.getMethodName());
        }
        newTrace.addAll(rascalTrace);
        return newTrace.freeze();
    }

    public static Throw malformedURI(IString uri) {
        return new Throw(VF.constructor(MalFormedURI, uri));
    }

    public static Throw malformedURI(String uri) {
        return new Throw(VF.constructor(MalFormedURI, VF.string(uri)));
    }

    public static Throw malformedURI(IString uri, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(MalFormedURI, uri), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw malformedURI(String uri, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(MalFormedURI, VF.string(uri)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw moduleNotFound(IString module) {
        return new Throw(VF.constructor(ModuleNotFound, module));
    }

    public static Throw moduleNotFound(IString module, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(ModuleNotFound, module), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw MultipleKey(IValue v, IValue first, IValue second) {
        return new Throw(VF.constructor(MultipleKey, v, first, second));
    }

    public static Throw MultipleKey(IValue v, IValue first, IValue second, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(MultipleKey, v, first, second), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw noParent(ISourceLocation loc) {
        return new Throw(VF.constructor(NoParent, loc));
    }

    public static Throw noParent(ISourceLocation loc, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(NoParent, loc), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw noSuchAnnotation(IString label) {
        return new Throw(VF.constructor(NoSuchAnnotation, label));
    }

    public static Throw noSuchAnnotation(String label) {
        return new Throw(VF.constructor(NoSuchAnnotation, VF.string(label)));
    }

    public static Throw noSuchAnnotation(IString label, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(NoSuchAnnotation, label), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw noSuchAnnotation(String label, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(NoSuchAnnotation, VF.string(label)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw noSuchElement(IValue v) {
        return new Throw(VF.constructor(NoSuchElement, v));
    }

    public static Throw noSuchElement(IValue v, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(NoSuchElement, v), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw noSuchField(IString name) {
        return new Throw(VF.constructor(NoSuchField, name));
    }

    public static Throw noSuchField(String name) {
        return new Throw(VF.constructor(NoSuchField, VF.string(name)));
    }

    public static Throw noSuchField(IString name, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(NoSuchField, name), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw noSuchField(String name, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(NoSuchField, VF.string(name)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw noSuchKey(IValue v) {
        return new Throw(VF.constructor(NoSuchKey, v));
    }

    public static Throw noSuchKey(IValue v, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(NoSuchKey, v), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw parseError(ISourceLocation loc) {
        return new Throw(VF.constructor(ParseError, loc));
    }

    public static Throw jsonParseError(ISourceLocation loc, String cause, String path) {
        return new Throw(VF.constructor(ParseError, loc).asWithKeywordParameters().setParameter("reason", VF.string(cause)).asWithKeywordParameters().setParameter("path", VF.string(path)));
    }

    public static Throw parseError(ISourceLocation loc, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(ParseError, loc), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw pathNotFound(ISourceLocation loc) {
        return new Throw(VF.constructor(PathNotFound, loc));
    }

    public static Throw pathNotFound(ISourceLocation loc, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(PathNotFound, loc), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw permissionDenied() {
        return new Throw(VF.constructor(AnonymousPermissionDenied));
    }

    public static Throw permissionDenied(AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(AnonymousPermissionDenied), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw permissionDenied(IString msg) {
        return new Throw(VF.constructor(PermissionDenied, msg));
    }

    public static Throw permissionDenied(IString msg, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(PermissionDenied, msg), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw regExpSyntaxError(String message) {
        return new Throw(VF.constructor(RegExpSyntaxError, VF.string(message)));
    }

    public static Throw schemeNotSupported(ISourceLocation file) {
        return new Throw(VF.constructor(SchemeNotSupported, file));
    }

    public static Throw stackOverflow() {
        return new Throw(VF.constructor(StackOverflow));
    }

    public static Throw stackOverflow(AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(StackOverflow), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw timeout(AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(Timeout), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw unavailableInformation(AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(UnavailableInformation), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw illegalTypeArgument(IString type, IString message) {
        return new Throw(VF.constructor(IllegalTypeArgument, type, message));
    }

    public static Throw illegalTypeArgument(IString type, AbstractAST ast, StackTrace trace, IString message) {
        return new Throw(VF.constructor(IllegalTypeArgument, type, message), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw illegalTypeArgument(String type, AbstractAST ast, StackTrace trace, String message) {
        return new Throw(VF.constructor(IllegalTypeArgument, VF.string(type), VF.string(message)), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw illegalTypeArgument(IString type) {
        return new Throw(VF.constructor(IllegalTypeArgument, type, VF.string("")));
    }

    public static Throw illegalTypeArgument(IString type, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(IllegalTypeArgument, type, VF.string("")), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw illegalTypeArgument(String type, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(IllegalTypeArgument, VF.string(type), VF.string("")), ast != null ? ast.getLocation() : null, trace);
    }

    public static Throw nameMismatch(String expected, String got, AbstractAST ast, StackTrace trace) {
        return new Throw(VF.constructor(NameMismatch, VF.string(expected), VF.string(got)), ast != null ? ast.getLocation() : null, trace);
    }
}

