/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter;

import io.usethesource.vallang.ISourceLocation;
import java.io.PrintWriter;
import org.rascalmpl.interpreter.ITestResultListener;
import org.rascalmpl.repl.streams.ReplTextWriter;

public class DefaultTestResultListener
implements ITestResultListener {
    private int successes;
    private int failures;
    private int errors;
    private int count;
    private int ignored;
    private String context;
    private final boolean verbose;
    private PrintWriter out;
    private PrintWriter err;

    public DefaultTestResultListener(PrintWriter out, PrintWriter err) {
        this(out, err, true);
    }

    public DefaultTestResultListener(PrintWriter out, PrintWriter err, boolean verbose) {
        this.err = err;
        this.out = out;
        this.verbose = verbose;
        this.reset();
    }

    private void reset() {
        this.successes = 0;
        this.failures = 0;
        this.errors = 0;
        this.ignored = 0;
    }

    public void setErrorStream(PrintWriter errorStream) {
        this.err = errorStream;
    }

    @Override
    public void ignored(String test, ISourceLocation loc) {
        ++this.ignored;
    }

    @Override
    public void start(String context, int count) {
        this.context = context;
        this.reset();
        this.count = count;
    }

    @Override
    public void done() {
        if (this.count > 0) {
            if (!this.verbose) {
                this.out.println();
            }
            this.out.println("Test report for " + this.context);
            if (this.errors + this.failures == 0) {
                this.out.println("\tall " + (this.count - this.ignored) + "/" + this.count + " tests succeeded");
            } else {
                this.out.println("\t" + this.successes + "/" + this.count + " tests succeeded");
                this.err.println("\t" + this.failures + "/" + this.count + " tests failed");
                this.err.println("\t" + this.errors + "/" + this.count + " tests threw exceptions");
            }
            if (this.ignored != 0) {
                this.out.println("\t" + this.ignored + "/" + this.count + " tests ignored");
            }
            this.out.flush();
            this.err.flush();
        }
    }

    @Override
    public void report(boolean successful, String test, ISourceLocation loc, String message, Throwable t2) {
        if (successful) {
            ++this.successes;
        } else if (t2 != null) {
            ++this.errors;
            if (!this.verbose) {
                this.out.println();
                this.out.flush();
            }
            this.err.println("error: " + test + " @ " + ReplTextWriter.valueToString(loc));
            this.err.println(message);
        } else {
            ++this.failures;
            if (!this.verbose) {
                this.out.println();
            }
            this.out.println("failure: " + test + " @ " + ReplTextWriter.valueToString(loc));
            this.out.println(message);
        }
        this.out.flush();
    }

    public int getNumberOfTests() {
        return this.successes + this.failures + this.errors + this.ignored;
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getFailures() {
        return this.failures;
    }

    public int getErrors() {
        return this.errors;
    }

    public boolean allOk() {
        return this.failures == 0 && this.errors == 0;
    }
}

