/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.TraverseResult;
import org.rascalmpl.interpreter.control_exceptions.Failure;
import org.rascalmpl.interpreter.control_exceptions.Insert;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.IBooleanResult;
import org.rascalmpl.interpreter.matching.LiteralPattern;
import org.rascalmpl.interpreter.matching.RegExpPatternValue;
import org.rascalmpl.interpreter.matching.TypedVariablePattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.ArgumentMismatch;
import org.rascalmpl.interpreter.staticErrors.SyntaxError;
import org.rascalmpl.interpreter.staticErrors.UndeclaredFunction;
import org.rascalmpl.interpreter.staticErrors.UndeclaredModule;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.utils.Cases;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.types.RascalType;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public class TraversalEvaluator {
    private final IEvaluator<Result<IValue>> eval;
    private static final TypeFactory tf = TypeFactory.getInstance();
    private final List<IValue> traversalContext;

    public TraversalEvaluator(IEvaluator<Result<IValue>> eval) {
        this.eval = eval;
        this.traversalContext = new Vector<IValue>();
    }

    public IList getContext() {
        IListWriter lw = this.eval.getValueFactory().listWriter();
        for (IValue v : this.traversalContext) {
            lw.append(v);
        }
        return ((IList)lw.done()).reverse();
    }

    public IValue traverse(IValue subject, CaseBlockList casesOrRules, DIRECTION direction, PROGRESS progress, FIXEDPOINT fixedpoint) {
        return this.traverseOnce(subject, casesOrRules, direction, progress, fixedpoint, new TraverseResult());
    }

    private IValue traverseOnce(IValue subject, CaseBlockList casesOrRules, DIRECTION direction, PROGRESS progress, FIXEDPOINT fixedpoint, TraverseResult tr) {
        Type subjectType = subject.getType();
        IValue result = subject;
        this.traversalContext.add(subject);
        if (subjectType.isString()) {
            result = this.traverseStringOnce(subject, casesOrRules, tr);
            this.traversalContext.remove(this.traversalContext.size() - 1);
            return result;
        }
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (direction == DIRECTION.TopDown) {
            IValue newTop = this.traverseTop(subject, casesOrRules, tr);
            if (progress == PROGRESS.Breaking && tr.matched) {
                this.traversalContext.remove(this.traversalContext.size() - 1);
                return newTop;
            }
            if (fixedpoint == FIXEDPOINT.Yes && tr.changed) {
                do {
                    tr.changed = false;
                    newTop = this.traverseTop(newTop, casesOrRules, tr);
                } while (tr.changed);
                tr.changed = true;
                subject = newTop;
            } else {
                subject = newTop;
            }
            hasMatched = tr.matched;
            hasChanged = tr.changed;
        }
        result = subjectType.isAbstractData() || RascalType.isNonterminal(subjectType) || RascalType.isReified(subjectType) ? this.traverseADTOnce(subject, casesOrRules, direction, progress, fixedpoint, tr) : (subjectType.isNode() ? this.traverseNodeOnce(subject, casesOrRules, direction, progress, fixedpoint, tr) : (subjectType.isList() ? this.traverseListOnce(subject, casesOrRules, direction, progress, fixedpoint, tr) : (subjectType.isSet() ? this.traverseSetOnce(subject, casesOrRules, direction, progress, fixedpoint, tr) : (subjectType.isMap() ? this.traverseMapOnce(subject, casesOrRules, direction, progress, fixedpoint, tr) : (subjectType.isTuple() ? this.traverseTupleOnce(subject, casesOrRules, direction, progress, fixedpoint, tr) : subject)))));
        if (direction == DIRECTION.TopDown) {
            tr.matched |= hasMatched;
            tr.changed |= hasChanged;
        }
        if (direction == DIRECTION.BottomUp) {
            if (progress == PROGRESS.Breaking && tr.matched) {
                this.traversalContext.remove(this.traversalContext.size() - 1);
                return result;
            }
            hasMatched = tr.matched;
            hasChanged = tr.changed;
            tr.matched = false;
            tr.changed = false;
            result = this.traverseTop(result, casesOrRules, tr);
            if (tr.changed && fixedpoint == FIXEDPOINT.Yes) {
                do {
                    tr.changed = false;
                    tr.matched = false;
                    result = this.traverseTop(result, casesOrRules, tr);
                } while (tr.changed);
                tr.changed = true;
                tr.matched = true;
            }
            tr.changed |= hasChanged;
            tr.matched |= hasMatched;
        }
        this.traversalContext.remove(this.traversalContext.size() - 1);
        return result;
    }

    private IValue traverseStringOnce(IValue subject, CaseBlockList casesOrRules, TraverseResult tr) {
        boolean hasMatched = tr.matched;
        boolean hasChanged = tr.changed;
        tr.matched = false;
        tr.changed = false;
        IValue res = this.traverseString(subject, casesOrRules, tr);
        tr.matched |= hasMatched;
        tr.changed |= hasChanged;
        return res;
    }

    private IValue traverseTupleOnce(IValue subject, CaseBlockList casesOrRules, DIRECTION direction, PROGRESS progress, FIXEDPOINT fixedpoint, TraverseResult tr) {
        ITuple tuple = (ITuple)subject;
        int arity = tuple.arity();
        IValue[] args = new IValue[arity];
        boolean hasMatched = false;
        boolean hasChanged = false;
        for (int i = 0; i < arity; ++i) {
            tr.changed = false;
            tr.matched = false;
            args[i] = this.traverseOnce(tuple.get(i), casesOrRules, direction, progress, fixedpoint, tr);
            hasMatched |= tr.matched;
            hasChanged |= tr.changed;
        }
        ITuple result = this.eval.getValueFactory().tuple(args);
        tr.changed = hasChanged;
        tr.matched = hasMatched;
        return result;
    }

    private IValue traverseADTOnce(IValue subject, CaseBlockList casesOrRules, DIRECTION direction, PROGRESS progress, FIXEDPOINT fixedpoint, TraverseResult tr) {
        IConstructor cons = (IConstructor)subject;
        HashMap<String, IValue> kwParams = null;
        if (cons.mayHaveKeywordParameters() && cons.asWithKeywordParameters().hasParameters()) {
            kwParams = new HashMap<String, IValue>();
        }
        if (cons.arity() == 0 && kwParams == null) {
            return subject;
        }
        if (casesOrRules.hasAllConcretePatternCases() && cons.getType().isSubtypeOf(RascalValueFactory.Tree) && TreeAdapter.isChar((ITree)cons)) {
            return subject;
        }
        IValue[] args = null;
        if (casesOrRules.hasAllConcretePatternCases() && cons.getType().isSubtypeOf(RascalValueFactory.Tree) && TreeAdapter.isAppl((ITree)cons)) {
            args = new IValue[cons.arity()];
            ITree tree = (ITree)cons;
            if (TreeAdapter.isLexical(tree) || TreeAdapter.isLiteral(tree)) {
                return subject;
            }
            args[0] = TreeAdapter.getProduction(tree);
            IList list = TreeAdapter.getArgs(tree);
            int len = list.length();
            if (len > 0) {
                IListWriter w = null;
                boolean hasChanged = false;
                boolean hasMatched = false;
                boolean isTop = TreeAdapter.isTop(tree);
                if (isTop) {
                    w = this.eval.getValueFactory().listWriter();
                    w.append(list.get(0));
                    tr.changed = false;
                    tr.matched = false;
                    w.append(this.traverseOnce(list.get(1), casesOrRules, direction, progress, fixedpoint, tr));
                    hasChanged |= tr.changed;
                    hasMatched |= tr.matched;
                    w.append(list.get(2));
                } else {
                    for (int i = 0; i < len; ++i) {
                        IValue elem = list.get(i);
                        if (i % 2 == 0) {
                            tr.changed = false;
                            tr.matched = false;
                            IValue newElem = this.traverseOnce(elem, casesOrRules, direction, progress, fixedpoint, tr);
                            if (hasChanged) {
                                assert (w != null);
                                w.append(newElem);
                            } else if (tr.changed) {
                                w = this.eval.getValueFactory().listWriter();
                                for (int j = 0; j < i; ++j) {
                                    w.append(list.get(j));
                                }
                                w.append(newElem);
                            }
                            hasChanged |= tr.changed;
                            hasMatched |= tr.matched;
                            continue;
                        }
                        if (!hasChanged) continue;
                        w.append(list.get(i));
                    }
                }
                tr.changed = hasChanged;
                tr.matched = hasMatched;
                args[1] = hasChanged ? w.done() : list;
            } else {
                args[1] = list;
            }
        } else {
            boolean hasChanged = false;
            boolean hasMatched = false;
            for (int i = 0; i < cons.arity(); ++i) {
                IValue child = cons.get(i);
                tr.matched = false;
                tr.changed = false;
                IValue newChild = this.traverseOnce(child, casesOrRules, direction, progress, fixedpoint, tr);
                if (hasChanged) {
                    assert (args != null);
                    args[i] = newChild;
                } else if (tr.changed) {
                    args = new IValue[cons.arity()];
                    for (int j = 0; j < i; ++j) {
                        args[j] = cons.get(j);
                    }
                    args[i] = newChild;
                }
                hasChanged |= tr.changed;
                hasMatched |= tr.matched;
            }
            if (kwParams != null) {
                IWithKeywordParameters<? extends IConstructor> consKw = cons.asWithKeywordParameters();
                for (String kwName : consKw.getParameterNames()) {
                    IValue val = consKw.getParameter(kwName);
                    tr.changed = false;
                    tr.matched = false;
                    IValue newVal = this.traverseOnce(val, casesOrRules, direction, progress, fixedpoint, tr);
                    kwParams.put(kwName, newVal);
                    if (!hasChanged && tr.changed) {
                        args = new IValue[cons.arity()];
                        for (int j = 0; j < cons.arity(); ++j) {
                            args[j] = cons.get(j);
                        }
                    }
                    hasChanged |= tr.changed;
                    hasMatched |= tr.matched;
                }
            }
            tr.matched = hasMatched;
            tr.changed = hasChanged;
        }
        if (tr.changed) {
            IConstructor rcons;
            try {
                assert (args != null);
                QualifiedName n = Names.toQualifiedName(cons.getType().getName(), cons.getName(), null);
                rcons = (IConstructor)this.eval.call(n, kwParams != null ? kwParams : Collections.emptyMap(), args);
            }
            catch (ArgumentMismatch | UndeclaredFunction | UndeclaredModule e) {
                rcons = kwParams != null ? this.eval.getValueFactory().constructor(cons.getConstructorType(), args, kwParams) : this.eval.getValueFactory().constructor(cons.getConstructorType(), args);
            }
            catch (MatchFailed e) {
                throw new UnexpectedType(cons.getConstructorType().getFieldTypes(), tf.tupleType(args), (AbstractAST)null);
            }
            return rcons;
        }
        return subject;
    }

    private IValue traverseMapOnce(IValue subject, CaseBlockList casesOrRules, DIRECTION direction, PROGRESS progress, FIXEDPOINT fixedpoint, TraverseResult tr) {
        IMap map = (IMap)subject;
        if (!map.isEmpty()) {
            IMapWriter w = this.eval.getValueFactory().mapWriter();
            Iterator<Map.Entry<IValue, IValue>> iter = map.entryIterator();
            boolean hasChanged = false;
            boolean hasMatched = false;
            while (iter.hasNext()) {
                Map.Entry<IValue, IValue> entry = iter.next();
                tr.changed = false;
                tr.matched = false;
                IValue newKey = this.traverseOnce(entry.getKey(), casesOrRules, direction, progress, fixedpoint, tr);
                hasChanged |= tr.changed;
                hasMatched |= tr.matched;
                tr.changed = false;
                tr.matched = false;
                IValue newValue = this.traverseOnce(entry.getValue(), casesOrRules, direction, progress, fixedpoint, tr);
                hasChanged |= tr.changed;
                hasMatched |= tr.matched;
                w.put(newKey, newValue);
            }
            tr.changed = hasChanged;
            tr.matched = hasMatched;
            return w.done();
        }
        return subject;
    }

    private IValue traverseSetOnce(IValue subject, CaseBlockList casesOrRules, DIRECTION direction, PROGRESS progress, FIXEDPOINT fixedpoint, TraverseResult tr) {
        ISet set = (ISet)subject;
        if (!set.isEmpty()) {
            ISetWriter w = this.eval.getValueFactory().setWriter();
            boolean hasChanged = false;
            boolean hasMatched = false;
            for (IValue v : set) {
                tr.changed = false;
                tr.matched = false;
                w.insert(this.traverseOnce(v, casesOrRules, direction, progress, fixedpoint, tr));
                hasChanged |= tr.changed;
                hasMatched |= tr.matched;
            }
            tr.changed = hasChanged;
            tr.matched = hasMatched;
            return w.done();
        }
        return subject;
    }

    private IValue traverseListOnce(IValue subject, CaseBlockList casesOrRules, DIRECTION direction, PROGRESS progress, FIXEDPOINT fixedpoint, TraverseResult tr) {
        IList list = (IList)subject;
        int len = list.length();
        if (len > 0) {
            IWriter w = null;
            boolean hasChanged = false;
            boolean hasMatched = false;
            for (int i = 0; i < len; ++i) {
                IValue elem = list.get(i);
                tr.changed = false;
                tr.matched = false;
                IValue newElem = this.traverseOnce(elem, casesOrRules, direction, progress, fixedpoint, tr);
                if (hasChanged) {
                    assert (w != null);
                    w.append(newElem);
                } else if (tr.changed) {
                    w = this.eval.getValueFactory().listWriter();
                    for (int j = 0; j < i; ++j) {
                        w.append(list.get(j));
                    }
                    w.append(newElem);
                }
                hasChanged |= tr.changed;
                hasMatched |= tr.matched;
            }
            tr.changed = hasChanged;
            tr.matched = hasMatched;
            return tr.changed ? w.done() : list;
        }
        return subject;
    }

    private IValue traverseNodeOnce(IValue subject, CaseBlockList casesOrRules, DIRECTION direction, PROGRESS progress, FIXEDPOINT fixedpoint, TraverseResult tr) {
        IValue result;
        INode node = (INode)subject;
        if (!(node.arity() != 0 || node.mayHaveKeywordParameters() && node.asWithKeywordParameters().hasParameters())) {
            result = subject;
        } else {
            IValue[] args = null;
            HashMap<String, IValue> kwParams = null;
            if (node.mayHaveKeywordParameters() && node.asWithKeywordParameters().hasParameters()) {
                kwParams = new HashMap<String, IValue>();
            }
            boolean hasChanged = false;
            boolean hasMatched = false;
            for (int i = 0; i < node.arity(); ++i) {
                IValue child = node.get(i);
                tr.changed = false;
                tr.matched = false;
                IValue newChild = this.traverseOnce(child, casesOrRules, direction, progress, fixedpoint, tr);
                if (hasChanged) {
                    assert (args != null);
                    args[i] = newChild;
                } else if (tr.changed) {
                    args = new IValue[node.arity()];
                    for (int j = 0; j < i; ++j) {
                        args[j] = node.get(j);
                    }
                    args[i] = newChild;
                }
                hasChanged |= tr.changed;
                hasMatched |= tr.matched;
            }
            if (kwParams != null) {
                IWithKeywordParameters<? extends INode> nodeKw = node.asWithKeywordParameters();
                for (String kwName : nodeKw.getParameterNames()) {
                    IValue val = nodeKw.getParameter(kwName);
                    tr.changed = false;
                    tr.matched = false;
                    IValue newVal = this.traverseOnce(val, casesOrRules, direction, progress, fixedpoint, tr);
                    kwParams.put(kwName, newVal);
                    hasChanged |= tr.changed;
                    hasMatched |= tr.matched;
                }
            }
            tr.changed = hasChanged;
            tr.matched = hasMatched;
            INode n = null;
            if (kwParams != null) {
                if (!hasChanged) {
                    return node;
                }
                if (args == null) {
                    args = new IValue[node.arity()];
                    for (int j = 0; j < node.arity(); ++j) {
                        args[j] = node.get(j);
                    }
                }
                n = this.eval.getValueFactory().node(node.getName(), args, kwParams);
            } else {
                n = hasChanged ? this.eval.getValueFactory().node(node.getName(), args) : node;
            }
            result = n;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue applyCases(IValue subject, CaseBlockList casesOrRules, TraverseResult tr) {
        for (Cases.CaseBlock cs : casesOrRules.getCases()) {
            Environment old = this.eval.getCurrentEnvt();
            AbstractAST prevAst = this.eval.getCurrentAST();
            try {
                this.eval.pushEnv();
                tr.matched = cs.matchAndEval(this.eval, ResultFactory.makeResult(subject.getType(), subject, this.eval));
                if (!tr.matched) continue;
                IValue iValue = subject;
                return iValue;
            }
            catch (Failure e) {}
            continue;
            finally {
                this.eval.unwind(old);
                this.eval.setCurrentAST(prevAst);
            }
        }
        return subject;
    }

    public IValue traverseTop(IValue subject, CaseBlockList casesOrRules, TraverseResult tr) {
        try {
            return this.applyCases(subject, casesOrRules, tr);
        }
        catch (Insert e) {
            tr.changed = true;
            tr.matched = true;
            Result<IValue> toBeInserted = e.getValue();
            if (!toBeInserted.getStaticType().isSubtypeOf(e.getStaticType())) {
                throw new UnexpectedType(e.getStaticType(), toBeInserted.getStaticType(), this.eval.getCurrentAST());
            }
            return e.getValue().getValue();
        }
    }

    public IValue traverseString(IValue subject, CaseBlockList casesOrRules, TraverseResult tr) {
        String subjectString = ((IString)subject).getValue();
        int len = subjectString.length();
        int subjectCursor = 0;
        int subjectCursorForResult = 0;
        StringBuffer replacementString = null;
        boolean hasMatched = false;
        boolean hasChanged = false;
        if (subjectString.length() == 0) {
            return this.traverseTop(subject, casesOrRules, tr);
        }
        while (subjectCursor < len) {
            try {
                IString substring;
                IString subresult = substring = this.eval.getValueFactory().string(subjectString.substring(subjectCursor, len));
                tr.matched = false;
                tr.changed = false;
                this.applyCases(subresult, casesOrRules, tr);
                hasMatched |= tr.matched;
                hasChanged |= tr.changed;
                ++subjectCursor;
            }
            catch (Insert e) {
                IValue repl = e.getValue().getValue();
                hasChanged = true;
                hasMatched = true;
                if (repl.getType().isString()) {
                    int end;
                    int start;
                    IBooleanResult lastPattern = e.getMatchPattern();
                    if (lastPattern == null) {
                        throw new ImplementationError("No last pattern known");
                    }
                    if (lastPattern instanceof RegExpPatternValue) {
                        start = ((RegExpPatternValue)lastPattern).getStart();
                        end = ((RegExpPatternValue)lastPattern).getEnd();
                    } else if (lastPattern instanceof LiteralPattern || lastPattern instanceof TypedVariablePattern) {
                        start = 0;
                        end = subjectString.length();
                    } else {
                        throw new SyntaxError("Illegal pattern " + lastPattern + " in string visit", this.eval.getCurrentAST().getLocation());
                    }
                    if (replacementString == null) {
                        replacementString = new StringBuffer();
                    }
                    while (subjectCursorForResult < subjectCursor + start) {
                        replacementString.append(subjectString.charAt(subjectCursorForResult));
                        ++subjectCursorForResult;
                    }
                    subjectCursorForResult = subjectCursor + end;
                    replacementString.append(((IString)repl).getValue());
                    tr.matched = true;
                    tr.changed = true;
                    subjectCursor += end;
                    continue;
                }
                throw new UnexpectedType(tf.stringType(), repl.getType(), this.eval.getCurrentAST());
            }
        }
        tr.changed |= hasChanged;
        tr.matched |= hasMatched;
        if (!tr.changed) {
            return subject;
        }
        while (subjectCursorForResult < len) {
            replacementString.append(subjectString.charAt(subjectCursorForResult));
            ++subjectCursorForResult;
        }
        return this.eval.getValueFactory().string(replacementString.toString());
    }

    public static class CaseBlockList {
        private List<Cases.CaseBlock> cases;
        private boolean allConcretePatternCases = true;
        private boolean hasRegexp = false;

        public CaseBlockList(List<Cases.CaseBlock> cases) {
            this.cases = cases;
            for (Cases.CaseBlock c : cases) {
                this.allConcretePatternCases &= c.allConcrete;
                this.hasRegexp |= c.hasRegExp;
            }
        }

        public boolean hasRegexp() {
            return this.hasRegexp;
        }

        public int length() {
            return this.cases.size();
        }

        public boolean hasAllConcretePatternCases() {
            return this.allConcretePatternCases;
        }

        public List<Cases.CaseBlock> getCases() {
            return this.cases;
        }
    }

    public static enum PROGRESS {
        Continuing,
        Breaking;

    }

    public static enum FIXEDPOINT {
        Yes,
        No;

    }

    public static enum DIRECTION {
        BottomUp,
        TopDown;

    }
}

